/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.migration.mapping;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.spis.migration.mapping.AuditAuthorConverter;
import com.atlassian.jira.auditing.spis.migration.mapping.AuditExtraAttributesConverter;
import com.atlassian.jira.auditing.spis.migration.mapping.AuditResourcesConverter;
import com.atlassian.jira.auditing.spis.migration.mapping.ChangedValueConverter;
import com.atlassian.jira.auditing.spis.migration.mapping.CoverageAreaConverter;
import com.atlassian.jira.model.querydsl.AuditChangedValueDTO;
import com.atlassian.jira.model.querydsl.AuditItemDTO;
import com.atlassian.jira.model.querydsl.AuditLogDTO;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AuditEntityConverter {
    @VisibleForTesting
    static final String UNKNOWN_ACTION_I18N_KEY = "";
    private final CoverageAreaConverter coverageAreaConverter;
    private final AuditAuthorConverter auditAuthorConverter;
    private final AuditResourcesConverter auditResourceConverter;
    private final ChangedValueConverter changedValueConverter;
    private final AuditExtraAttributesConverter auditExtraAttributesConverter;

    public AuditEntityConverter(@Nonnull CoverageAreaConverter coverageAreaConverter, @Nonnull AuditAuthorConverter auditAuthorConverter, @Nonnull AuditResourcesConverter auditResourceConverter, @Nonnull ChangedValueConverter changedValueConverter, @Nonnull AuditExtraAttributesConverter auditExtraAttributesConverter) {
        this.coverageAreaConverter = Objects.requireNonNull(coverageAreaConverter);
        this.auditAuthorConverter = Objects.requireNonNull(auditAuthorConverter);
        this.auditResourceConverter = Objects.requireNonNull(auditResourceConverter);
        this.changedValueConverter = Objects.requireNonNull(changedValueConverter);
        this.auditExtraAttributesConverter = auditExtraAttributesConverter;
    }

    @Nonnull
    public AuditEntity convert(@Nonnull AuditLogDTO auditLog, @Nonnull Collection<AuditItemDTO> auditItems, @Nonnull Collection<AuditChangedValueDTO> changedValues) {
        CoverageArea coverageArea = this.coverageAreaConverter.apply(AuditingCategory.getCategoryById(auditLog.getCategory()), CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION);
        String action = StringUtils.defaultString((String)auditLog.getSummary());
        AuditType auditType = AuditEntitiesUtils.newAuditTypeWithTranslations(coverageArea, this.extractCategoryI18nKey(auditLog), UNKNOWN_ACTION_I18N_KEY, CoverageLevel.BASE, StringUtils.defaultString((String)auditLog.getCategory()), action);
        return AuditEntity.builder((AuditType)auditType).author(this.auditAuthorConverter.apply(auditLog)).affectedObjects(this.auditResourceConverter.apply(auditLog, auditItems)).changedValues(this.changedValuesFrom(changedValues)).extraAttributes(this.auditExtraAttributesConverter.apply(auditLog)).timestamp(Optional.ofNullable(auditLog.getCreated()).map(Timestamp::toInstant).orElse(Instant.now())).source(auditLog.getRemoteAddress()).system(null).node(UNKNOWN_ACTION_I18N_KEY).method("Unknown").build();
    }

    private String extractCategoryI18nKey(@Nonnull AuditLogDTO auditLog) {
        return Optional.ofNullable(AuditingCategory.getCategoryById(auditLog.getCategory())).map(AuditingCategory::getNameI18nKey).orElse(UNKNOWN_ACTION_I18N_KEY);
    }

    private List<ChangedValue> changedValuesFrom(@Nonnull Collection<AuditChangedValueDTO> changedValues) {
        return changedValues.stream().map(this.changedValueConverter).collect(Collectors.toList());
    }
}

