/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.service;

import com.atlassian.audit.core.spi.service.CurrentUserProvider;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.jira.auditing.converters.AuditAuthors;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.web.context.HttpContext;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class JiraCurrentUserProviderImpl
implements CurrentUserProvider {
    private final HttpContext httpContext;
    private final JiraAuthenticationContext authenticationContext;

    public JiraCurrentUserProviderImpl(JiraAuthenticationContext authenticationContext, HttpContext httpContext) {
        this.httpContext = httpContext;
        this.authenticationContext = authenticationContext;
    }

    @Nonnull
    public AuditAuthor currentUser() {
        ApplicationUser currentUser = null;
        try {
            currentUser = this.authenticationContext.getLoggedInUser();
            HttpServletRequest request = this.httpContext.getRequest();
            if (request == null) {
                return AuditAuthor.SYSTEM_AUTHOR;
            }
            if (currentUser == null) {
                return AuditAuthor.ANONYMOUS_AUTHOR;
            }
            return AuditAuthors.from(currentUser);
        }
        catch (IllegalStateException ise) {
            if (currentUser != null) {
                return AuditAuthors.from(currentUser);
            }
            return AuditAuthor.SYSTEM_AUTHOR;
        }
    }
}

