/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.avatar.AvatarFilenames;
import com.atlassian.jira.avatar.AvatarFormatPolicy;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.AvatarImageDataStorage;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarManagerStats;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.avatar.ImageScaler;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.io.MediaConsumer;
import com.atlassian.jira.io.ResourceData;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.icon.IconTypeDefinition;
import com.atlassian.jira.plugin.icon.IconTypeDefinitionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarManagerImpl
implements AvatarManager {
    private static final Logger log = LoggerFactory.getLogger(AvatarManagerImpl.class);
    private static final String ICON_DEFAULT_ID_CACHE_NAME = AvatarManagerImpl.class.getName() + ".iconDefaultIDMap";
    private final ApplicationProperties applicationProperties;
    private final AvatarImageDataStorage avatarImageDataStorage;
    private final AvatarManagerStats stats;
    private final AvatarStore store;
    private final AvatarTagger avatarTagger;
    private final AvatarTranscoder avatarTranscoder;
    private final JiraHomeChangeEventPublisher jiraHomeChangeEventPublisher;
    private final GlobalPermissionManager globalPermissionManager;
    private final IconTypeDefinitionFactory iconTypeFactory;
    private final ImageScaler scaler;
    private final PermissionManager permissionManager;
    private final RequestCache<IconType, Long> iconDefaultIdCache;
    private final AvatarFileStoreProvider avatarFileStoreProvider;

    public AvatarManagerImpl(AvatarStore store, ApplicationProperties applicationProperties, GlobalPermissionManager globalPermissionManager, AvatarTagger avatarTagger, AvatarImageDataStorage avatarImageDataStorage, PermissionManager permissionManager, JiraHomeChangeEventPublisher jiraHomeChangeEventPublisher, IconTypeDefinitionFactory iconTypeFactory, RequestCacheFactory requestCacheFactory, AvatarTranscoder avatarTranscoder, AvatarManagerStats avatarManagerStats, AvatarFileStoreProvider avatarFileStoreProvider) {
        this.store = store;
        this.applicationProperties = applicationProperties;
        this.globalPermissionManager = globalPermissionManager;
        this.avatarTagger = avatarTagger;
        this.jiraHomeChangeEventPublisher = jiraHomeChangeEventPublisher;
        this.scaler = new ImageScaler();
        this.avatarImageDataStorage = avatarImageDataStorage;
        this.permissionManager = permissionManager;
        this.iconTypeFactory = iconTypeFactory;
        this.avatarTranscoder = avatarTranscoder;
        this.iconDefaultIdCache = requestCacheFactory.createRequestCache(ICON_DEFAULT_ID_CACHE_NAME, this::loadDefaultAvatarId);
        this.stats = avatarManagerStats;
        this.avatarFileStoreProvider = Objects.requireNonNull(avatarFileStoreProvider);
    }

    public Avatar getById(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        return this.store.getById(avatarId);
    }

    public Avatar getByIdTagged(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        return this.store.getByIdTagged(avatarId);
    }

    public boolean delete(Long avatarId) {
        return this.delete(avatarId, true);
    }

    public boolean delete(Long avatarId, boolean alsoDeleteAvatarFile) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        Avatar avatar = this.store.getById(avatarId);
        if (avatar == null) {
            return false;
        }
        if (alsoDeleteAvatarFile) {
            Avatar.Size[] imageSizes = Avatar.Size.values();
            ArrayList<FileStore.Path> deletedAvatars = new ArrayList<FileStore.Path>();
            for (Avatar.Size imageSize : imageSizes) {
                FileStore.Path path = this.getAvatarPath(avatar, imageSize);
                if (!path.tryDeleteFile()) continue;
                deletedAvatars.add(path);
            }
            if (!deletedAvatars.isEmpty()) {
                this.jiraHomeChangeEventPublisher.publishIfApplicable(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.AVATAR, deletedAvatars);
            }
        }
        return this.store.delete(avatarId);
    }

    public void update(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.notNull((String)"avatar.id", (Object)avatar.getId());
        this.store.update(avatar);
    }

    @Nonnull
    public Avatar create(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.stateTrue((String)"avatar.id must be null", (avatar.getId() == null ? 1 : 0) != 0);
        return this.store.create(avatar);
    }

    @Nonnull
    public Avatar create(Avatar avatar, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"avatar", (Object)avatar);
        if (avatar.isSystemAvatar()) {
            throw new IllegalArgumentException("System avatars cannot be created with custom image data");
        }
        Assertions.notNull((String)"imageData", (Object)imageData);
        Avatar newAvatar = null;
        ArrayList createdFiles = Lists.newArrayList();
        try {
            newAvatar = this.create(avatar);
            FileStore.Path largeAvatarFile = this.processImage(newAvatar, imageData, croppingSelection, Avatar.Size.largest());
            createdFiles.add(largeAvatarFile);
            for (Avatar.Size size : Avatar.Size.values()) {
                if (Avatar.Size.largest().equals((Object)size)) continue;
                try (InputStream inputStream = largeAvatarFile.fileReader().openInputStream();){
                    FileStore.Path filePath = this.processImage(newAvatar, inputStream, null, size);
                    createdFiles.add(filePath);
                }
            }
            return newAvatar;
        }
        catch (RuntimeException failedCreate) {
            this.handleCreationFailure(createdFiles, newAvatar);
            throw failedCreate;
        }
    }

    @Nonnull
    public Avatar create(Avatar.Type avatarType, @Nonnull String owningObjectId, @Nonnull AvatarImageDataProvider imageDataProvider) throws IOException {
        return this.create(this.toIconType(avatarType), new IconOwningObjectId(owningObjectId), imageDataProvider);
    }

    @Nonnull
    public Avatar create(@Nonnull IconType iconType, @Nonnull IconOwningObjectId owningObjectId, @Nonnull AvatarImageDataProvider imageDataProvider) throws IOException {
        Assertions.notNull((String)"iconType", (Object)iconType);
        Assertions.notNull((String)"owningObjectId", (Object)owningObjectId);
        Assertions.notNull((String)"imageDataProvider", (Object)imageDataProvider);
        AvatarImpl avatarStub = new AvatarImpl(null, this.avatarImageDataStorage.getNextFilenameStub() + ".png", "image/png", iconType, owningObjectId.getId(), false);
        Avatar newAvatar = this.store.create(avatarStub);
        try {
            this.avatarImageDataStorage.storeAvatarFiles(newAvatar, imageDataProvider);
        }
        catch (IOException e) {
            this.store.delete(newAvatar.getId());
            throw e;
        }
        catch (RuntimeException e) {
            this.store.delete(newAvatar.getId());
            throw e;
        }
        return newAvatar;
    }

    @Nonnull
    public Avatar create(String fileName, String contentType, IconType iconType, IconOwningObjectId owner, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"fileName", (Object)fileName);
        Assertions.notNull((String)"contentType", (Object)contentType);
        Assertions.notNull((String)"iconType", (Object)iconType);
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"imageData", (Object)imageData);
        return this.create(AvatarImpl.createCustomAvatar(fileName, contentType, owner.getId(), iconType), imageData, croppingSelection);
    }

    @Nonnull
    public Avatar create(String fileName, String contentType, Project project, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"fileName", (Object)fileName);
        Assertions.notNull((String)"contentType", (Object)contentType);
        Assertions.notNull((String)"project", (Object)project);
        Assertions.notNull((String)"imageData", (Object)imageData);
        String owner = project.getId().toString();
        return this.create(AvatarImpl.createCustomAvatar(fileName, contentType, owner, IconType.PROJECT_ICON_TYPE), imageData, croppingSelection);
    }

    @Nonnull
    public Avatar create(String fileName, String contentType, ApplicationUser owner, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"fileName", (Object)fileName);
        Assertions.notNull((String)"contentType", (Object)contentType);
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"imageData", (Object)imageData);
        String user = owner.getKey();
        return this.create(AvatarImpl.createCustomAvatar(fileName, "image/png", user, IconType.USER_ICON_TYPE), imageData, croppingSelection);
    }

    private void handleCreationFailure(List<FileStore.Path> avatarPaths, Avatar avatar) {
        if (avatar != null) {
            try {
                this.store.delete(avatar.getId());
            }
            catch (DataAccessException e) {
                log.warn("Avatar save failed, then failed to delete in database during cleanup. id={}", (Object)avatar.getId());
            }
        }
        for (FileStore.Path avatarPath : avatarPaths) {
            try {
                if (avatarPath == null || !avatarPath.fileExists()) continue;
                avatarPath.deleteFile();
            }
            catch (IOException | RuntimeException failedDeleteFile) {
                log.warn(String.format("Avatar save failed, then failed to delete file '%s' during cleanup.", avatarPath), (Throwable)failedDeleteFile);
            }
        }
    }

    @VisibleForTesting
    FileStore.Path processImage(Avatar created, InputStream imageData, Selection croppingSelection, Avatar.Size size) throws IOException {
        RenderedImage image = this.scaler.getSelectedImageData(new Thumber().getImage(imageData), croppingSelection, size.getPixels());
        FileStore.Path path = this.getAvatarPath(created, size);
        path.fileWriter().write(outputStream -> this.avatarTagger.saveTaggedAvatar(image, AVATAR_IMAGE_FORMAT_FULL.getName(), outputStream));
        this.jiraHomeChangeEventPublisher.publishIfApplicable(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.AVATAR, Collections.singleton(path));
        return path;
    }

    @VisibleForTesting
    FileStore.Path getAvatarPath(Avatar avatar, Avatar.Size size) {
        FileStore.Path base = this.avatarFileStoreProvider.getBasePath();
        return base.path(new String[]{AvatarFilenames.getAvatarFilename(avatar, size)});
    }

    @Nonnull
    public List<Avatar> getAllSystemAvatars(Avatar.Type type) {
        return this.getAllSystemAvatars(this.toIconType(type));
    }

    @Nonnull
    public List<Avatar> getAllSystemAvatars(IconType iconType) {
        try {
            return Lists.newArrayList((Iterable)Iterables.filter(this.store.getAllSystemAvatars(iconType), this.isUsableAvatarPredicate(iconType)));
        }
        catch (UnsupportedOperationException e) {
            return Lists.newArrayList();
        }
    }

    private Predicate<? super Avatar> isUsableAvatarPredicate(final IconType iconType) {
        return new Predicate<Avatar>(){

            public boolean apply(@Nullable Avatar input) {
                if (null == input) {
                    return false;
                }
                if (iconType.equals((Object)IconType.PROJECT_ICON_TYPE)) {
                    return !Avatar.demotedSystemProjectAvatars.contains(input.getFileName());
                }
                if (iconType.equals((Object)IconType.USER_ICON_TYPE)) {
                    return !Avatar.demotedSystemUserAvatars.contains(input.getFileName());
                }
                return true;
            }
        };
    }

    @Nonnull
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type type, String ownerId) {
        return this.getCustomAvatarsForOwner(this.toIconType(type), ownerId);
    }

    @Nonnull
    public List<Avatar> getCustomAvatarsForOwner(IconType iconType, String ownerId) {
        return this.store.getCustomAvatarsForOwner(iconType, ownerId);
    }

    public boolean isAvatarOwner(Avatar avatar, String ownerId) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.notNull((String)"owner", (Object)ownerId);
        return this.getCustomAvatarsForOwner(avatar.getIconType(), ownerId).contains(avatar);
    }

    private void processAvatarData(Avatar avatar, MediaConsumer mediaConsumer, Avatar.Size size, AvatarFormatPolicy formatPolicy) throws IOException {
        Option<Avatar> avatarOption = this.transformToJIRAAvatar(avatar);
        if (avatarOption.isEmpty()) {
            return;
        }
        ResourceData resourceData = formatPolicy.getData((Avatar)avatarOption.get(), () -> this.getAvatarInputStream((Avatar)avatarOption.get(), size), () -> {
            try (InputStream svgInputStream = this.getAvatarInputStream((Avatar)avatarOption.get(), size);){
                InputStream inputStream = this.avatarTranscoder.getOrCreateRasterizedAvatarFile((Avatar)avatarOption.get(), size, svgInputStream).fileReader().openInputStream();
                return inputStream;
            }
        });
        try (InputStream is = resourceData.getInputStream();){
            mediaConsumer.consumeContentType(resourceData.getContentType());
            mediaConsumer.consumeData(is);
        }
    }

    private InputStream getAvatarInputStream(Avatar icon, Avatar.Size size) throws IOException {
        InputStream data = null;
        if (icon.isSystemAvatar()) {
            data = this.getIconTypeDefinitionStrict(icon.getIconType()).getSystemIconImageProvider().getSystemIconInputStream(icon, size);
            if (data == null) {
                log.error("Failed to get image data for system icon " + icon.getFileName());
                throw new IOException("File not found");
            }
        } else {
            FileStore.Path path = this.getOrGenerateAvatarFile(icon, size);
            data = path.fileReader().openInputStream();
        }
        return data;
    }

    private Option<Avatar> transformToJIRAAvatar(Avatar avatar) {
        return Option.option((Object)avatar.getId()).flatMap(avatarId -> Option.option((Object)this.getByIdTagged((Long)avatarId)));
    }

    private FileStore.Path getOrGenerateAvatarFile(Avatar avatar, Avatar.Size size) throws IOException {
        FileStore.Path largeAvatarPath;
        FileStore.Path path = this.getAvatarPath(avatar, size);
        if (!path.fileExists() && (largeAvatarPath = this.getPathToLargestAvatarImage(avatar)) != null) {
            FileStore.Path path2;
            block9: {
                InputStream inputStream = largeAvatarPath.fileReader().openInputStream();
                try {
                    path2 = this.processImage(avatar, inputStream, null, size);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IOException(String.format("Failed to generate new image for '%s' from image '%s'", size, largeAvatarPath), e);
                    }
                }
                inputStream.close();
            }
            return path2;
        }
        return path;
    }

    private FileStore.Path getPathToLargestAvatarImage(Avatar avatar) throws IOException {
        ArrayList reversedSizes = new ArrayList(Avatar.Size.inPixelOrder());
        Collections.reverse(reversedSizes);
        for (Avatar.Size size : reversedSizes) {
            FileStore.Path avatarPath = this.getAvatarPath(avatar, size);
            if (!avatarPath.fileExists()) continue;
            return avatarPath;
        }
        return null;
    }

    public void readAvatarData(Avatar avatar, AvatarManager.ImageSize size, Consumer<InputStream> dataAccessor) throws IOException {
        this.readAvatarData(avatar, size.getSize(), dataAccessor);
    }

    public void readAvatarData(@Nonnull Avatar avatar, @Nonnull Avatar.Size size, @Nonnull Consumer<InputStream> dataAccessor) throws IOException {
        this.readAvatarData(avatar, size, AvatarFormatPolicy.createOriginalDataPolicy(), new MediaConsumer(dataAccessor));
    }

    public void readAvatarData(@Nonnull Avatar avatar, @Nonnull Avatar.Size size, @Nonnull AvatarFormatPolicy avatarFormatPolicy, @Nonnull MediaConsumer mediaConsumer) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.processAvatarData(avatar, mediaConsumer, size, avatarFormatPolicy);
        this.stats.readAvatarData(stopwatch.elapsed(), this.avatarFileStoreProvider.getFileStoreAnalyticInfo());
    }

    public Long getDefaultAvatarId(Avatar.Type ofType) {
        return this.getDefaultAvatarId(this.toIconType(ofType));
    }

    private Long loadDefaultAvatarId(@Nonnull IconType iconType) {
        Avatar.Type oldType;
        Long result = null;
        List<Avatar> avatars = this.store.getSystemAvatarsForFilename(iconType, this.iconTypeFactory.getDefaultSystemIconFilename(iconType));
        if (avatars != null && !avatars.isEmpty()) {
            result = avatars.get(0).getId();
        }
        if (result == null && (oldType = Avatar.Type.getByIconType((IconType)iconType)) != null && (oldType == Avatar.Type.ISSUETYPE || oldType == Avatar.Type.PROJECT || oldType == Avatar.Type.USER)) {
            result = oldType.getDefaultId(this.applicationProperties);
        }
        return result;
    }

    public Long getDefaultAvatarId(@Nonnull IconType iconType) {
        Assertions.notNull((String)"iconType", (Object)iconType);
        return (Long)this.iconDefaultIdCache.get((Object)iconType);
    }

    public Avatar getDefaultAvatar(IconType iconType) {
        Long id = this.getDefaultAvatarId(iconType);
        if (id == null) {
            return null;
        }
        return this.getById(id);
    }

    public boolean isValidIconType(@Nonnull IconType iconType) {
        return this.iconTypeFactory.getDefinition(iconType) != null;
    }

    private IconType toIconType(@Nonnull Avatar.Type avatarType) {
        if (avatarType == Avatar.Type.OTHER) {
            return null;
        }
        return new IconType(avatarType.getName());
    }

    public Long getAnonymousAvatarId() {
        String avatarId = this.applicationProperties.getString("jira.avatar.user.anonymous.id");
        return avatarId != null ? Long.valueOf(avatarId) : null;
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, Avatar.Type type, String ownerId) {
        IconType iconType = this.toIconType(type);
        DummyAvatar tempAvatar = new DummyAvatar(iconType, ownerId);
        return this.userCanView(remoteUser, tempAvatar);
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, Project project) {
        if (project == null) {
            return false;
        }
        IconType iconType = IconType.PROJECT_ICON_TYPE;
        DummyAvatar tempAvatar = new DummyAvatar(iconType, String.valueOf(project.getId()));
        return this.userCanView(remoteUser, tempAvatar);
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, ApplicationUser owner) {
        IconType iconType = IconType.USER_ICON_TYPE;
        DummyAvatar tempAvatar = new DummyAvatar(iconType, owner.getKey());
        return this.userCanView(remoteUser, tempAvatar);
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, Avatar.Type type, String ownerId) {
        IconType iconType = this.toIconType(type);
        return this.userCanCreateFor(remoteUser, iconType, new IconOwningObjectId(ownerId));
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, ApplicationUser owner) {
        if (Users.isAnonymous((ApplicationUser)remoteUser) || owner == null) {
            return false;
        }
        IconType iconType = IconType.USER_ICON_TYPE;
        return this.userCanCreateFor(remoteUser, iconType, new IconOwningObjectId(owner.getKey()));
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, Project owner) {
        if (owner == null) {
            return false;
        }
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, remoteUser) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, owner, remoteUser);
    }

    public static boolean isSvgContentType(String mimeType) {
        return "image/svg+xml".equals(mimeType);
    }

    public static boolean isAvatarTranscodeable(@Nonnull Avatar avatar) {
        return AvatarManagerImpl.isSvgContentType(avatar.getContentType()) && avatar.isSystemAvatar();
    }

    public boolean userCanView(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        IconTypeDefinition iconTypeDefinition = this.getIconTypeDefinition(icon.getIconType());
        return iconTypeDefinition != null && iconTypeDefinition.getPolicy().userCanView(remoteUser, icon);
    }

    public boolean userCanDelete(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        IconTypeDefinition iconTypeDefinition = this.getIconTypeDefinition(icon.getIconType());
        return iconTypeDefinition != null && iconTypeDefinition.getPolicy().userCanDelete(remoteUser, icon);
    }

    public boolean userCanCreateFor(@Nullable ApplicationUser remoteUser, @Nonnull IconType iconType, @Nonnull IconOwningObjectId owningObjectId) {
        IconTypeDefinition iconTypeDefinition = this.getIconTypeDefinition(iconType);
        return iconTypeDefinition != null && iconTypeDefinition.getPolicy().userCanCreateFor(remoteUser, owningObjectId);
    }

    public boolean hasImage(@Nonnull Avatar avatar, @Nonnull Avatar.Size size) {
        if (avatar.isSystemAvatar()) {
            try {
                this.getIconTypeDefinitionStrict(avatar.getIconType()).getSystemIconImageProvider().getSystemIconInputStream(avatar, size).close();
                return true;
            }
            catch (IOException e) {
                log.warn("Exception during checking if system avatar has image", (Throwable)e);
                return false;
            }
        }
        FileStore.Path path = this.getAvatarPath(avatar, size);
        return path.tryFileExists();
    }

    @Nullable
    private IconTypeDefinition getIconTypeDefinition(IconType iconType) {
        return this.iconTypeFactory.getDefinition(iconType);
    }

    @Nonnull
    private IconTypeDefinition getIconTypeDefinitionStrict(IconType iconType) {
        IconTypeDefinition iconTypeDefinition = this.iconTypeFactory.getDefinition(iconType);
        if (iconTypeDefinition == null) {
            throw new IllegalArgumentException("Unknown IconType '" + iconType + "'");
        }
        return iconTypeDefinition;
    }

    private class DummyAvatar
    implements Avatar {
        private IconType iconType;
        private String owner;

        public DummyAvatar(IconType iconType, String owner) {
            this.iconType = iconType;
            this.owner = owner;
        }

        @Nonnull
        public Avatar.Type getAvatarType() {
            if (Avatar.Type.supportsName((String)this.iconType.getKey())) {
                return Avatar.Type.getByName((String)this.iconType.getKey());
            }
            return Avatar.Type.OTHER;
        }

        @Nonnull
        public IconType getIconType() {
            return this.iconType;
        }

        @Nonnull
        public String getFileName() {
            throw new NotImplementedException("Legacy permissions methods cannot supply the icon file name.");
        }

        @Nonnull
        public String getContentType() {
            return "text/plain";
        }

        public Long getId() {
            return null;
        }

        @Nonnull
        public String getOwner() {
            return this.owner;
        }

        public boolean isSystemAvatar() {
            return false;
        }
    }
}

