/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.banner;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.banner.AnnouncementBannerState;
import com.atlassian.jira.banner.EditAnnouncementBannerManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.announcement.AnnouncementBannerChangedEvent;
import org.apache.commons.lang3.StringUtils;

public final class EditAnnouncementBannerDefaultManager
implements EditAnnouncementBannerManager {
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;

    public EditAnnouncementBannerDefaultManager(ApplicationProperties applicationProperties, EventPublisher eventPublisher) {
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void updateAnnouncementBanner(AnnouncementBannerState state) {
        if (this.hasStateChanged(state)) {
            this.eventPublisher.publish((Object)new AnnouncementBannerChangedEvent(this.applicationProperties.getText("jira.alertheader"), state.getBanner(), this.applicationProperties.getString("jira.alertheader.visibility"), state.getVisibility()));
            this.applicationProperties.setText("jira.alertheader", state.getBanner());
            this.applicationProperties.setString("jira.alertheader.visibility", state.getVisibility());
        }
    }

    private boolean hasStateChanged(AnnouncementBannerState state) {
        String previous = this.applicationProperties.getText("jira.alertheader");
        String previousVisibility = this.applicationProperties.getString("jira.alertheader.visibility");
        return !StringUtils.equals((CharSequence)previous, (CharSequence)state.getBanner()) || !StringUtils.equals((CharSequence)previousVisibility, (CharSequence)state.getVisibility());
    }
}

