/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.config;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.StepDescriptor;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultConstantsService
implements ConstantsService {
    private final I18nHelper.BeanFactory i18n;
    private final ConstantsManager constantsMgr;
    private final PermissionManager permissionMgr;
    private final WorkflowSchemeManager workflowSchemeMgr;
    private final WorkflowManager workflowMgr;
    private final StatusCategoryManager statusCategoryManager;
    private final IssueTypeService issueTypeService;

    public DefaultConstantsService(I18nHelper.BeanFactory i18n, ConstantsManager constantsManager, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeMgr, WorkflowManager workflowMgr, StatusCategoryManager statusCategoryManager, IssueTypeService issueTypeService) {
        this.constantsMgr = constantsManager;
        this.permissionMgr = permissionManager;
        this.workflowSchemeMgr = workflowSchemeMgr;
        this.workflowMgr = workflowMgr;
        this.i18n = i18n;
        this.issueTypeService = issueTypeService;
        this.statusCategoryManager = statusCategoryManager;
    }

    public ServiceOutcome<Status> getStatusById(ApplicationUser user, String statusId) {
        Status status = this.constantsMgr.getStatusObject(statusId);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusId));
    }

    public ServiceOutcome<Status> getStatusByName(ApplicationUser user, String statusName) {
        Status status = this.constantsMgr.getStatusByName(statusName);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusName));
    }

    public ServiceOutcome<Status> getStatusByNameIgnoreCase(ApplicationUser user, String statusName) {
        Status status = (Status)this.constantsMgr.getConstantByNameIgnoreCase(ConstantsManager.STATUS_CONSTANT_TYPE, statusName);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusName));
    }

    public ServiceOutcome<Status> getStatusByTranslatedName(ApplicationUser user, String statusName) {
        Status status = this.constantsMgr.getStatusByTranslatedName(statusName);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusName));
    }

    private boolean isStatusVisible(ApplicationUser user, Status status) {
        return new IsStatusVisible(user, this.permissionMgr, this.workflowMgr, this.workflowSchemeMgr).apply(status);
    }

    public ServiceOutcome<Collection<Status>> getAllStatuses(ApplicationUser user) {
        return ServiceOutcomeImpl.ok(Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.constantsMgr.getStatuses(), (Predicate)new IsStatusVisible(user, this.permissionMgr, this.workflowMgr, this.workflowSchemeMgr))));
    }

    public ServiceOutcome<Collection<IssueType>> getAllIssueTypes(ApplicationUser user) {
        return ServiceOutcomeImpl.ok(Lists.newArrayList((Iterable)this.issueTypeService.getIssueTypes(user)));
    }

    public ServiceOutcome<IssueType> getIssueTypeById(final ApplicationUser user, final String issueTypeId) {
        Option issueType = this.issueTypeService.getIssueType(user, issueTypeId);
        return (ServiceOutcome)issueType.fold((Supplier)new Supplier<ServiceOutcome<IssueType>>(){

            @Override
            public ServiceOutcome<IssueType> get() {
                return ServiceOutcomeImpl.error(DefaultConstantsService.this.i18n.getInstance(user).getText("constants.service.issuetype.not.found", issueTypeId));
            }
        }, (Function)new Function<IssueType, ServiceOutcome<IssueType>>(){

            @Override
            public ServiceOutcome<IssueType> apply(IssueType issueType) {
                return ServiceOutcomeImpl.ok(issueType);
            }
        });
    }

    public ServiceOutcome<Collection<StatusCategory>> getAllStatusCategories(ApplicationUser user) {
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.any"));
        }
        return ServiceOutcomeImpl.ok(this.statusCategoryManager.getStatusCategories());
    }

    public ServiceOutcome<Collection<StatusCategory>> getUserVisibleStatusCategories(ApplicationUser user) {
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.any"));
        }
        return ServiceOutcomeImpl.ok(this.statusCategoryManager.getUserVisibleStatusCategories());
    }

    public ServiceOutcome<StatusCategory> getStatusCategoryById(ApplicationUser user, String id) {
        Long longId;
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.id", id));
        }
        try {
            longId = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.id", id));
        }
        StatusCategory statusCategory = this.statusCategoryManager.getStatusCategory(longId);
        if (statusCategory != null) {
            return ServiceOutcomeImpl.ok(statusCategory);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.id", id));
    }

    public ServiceOutcome<StatusCategory> getStatusCategoryByKey(ApplicationUser user, String key) {
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.key", key));
        }
        StatusCategory statusCategory = this.statusCategoryManager.getStatusCategoryByKey(key);
        if (statusCategory != null) {
            return ServiceOutcomeImpl.ok(statusCategory);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.key", key));
    }

    public ServiceOutcome<StatusCategory> getDefaultStatusCategory(ApplicationUser user) {
        StatusCategory statusCategory = this.statusCategoryManager.getDefaultStatusCategory();
        if (statusCategory != null) {
            return ServiceOutcomeImpl.ok(statusCategory);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.default"));
    }

    public boolean isStatusAsLozengeEnabled() {
        return this.statusCategoryManager.isStatusAsLozengeEnabled();
    }

    static class IsStatusVisible
    implements Predicate<Status> {
        final Set<String> seenStatusIds = new HashSet<String>();
        final HashSet<String> seenWorkflowNames = new HashSet();
        final LinkedList<String> pendingWorkflowNames = new LinkedList();
        final Iterator<Project> projects;
        private final PermissionManager permissionManager;
        private final WorkflowManager workflowManager;
        private final WorkflowFetcher workflowFetcher;

        IsStatusVisible(ApplicationUser user, PermissionManager permissionManager, WorkflowManager workflowManager, final WorkflowSchemeManager workflowSchemeManager) {
            this(user, permissionManager, workflowManager, new WorkflowFetcher(){

                @Override
                public List<String> getWorkflowNames(Project project) {
                    try {
                        GenericValue workflowScheme = workflowSchemeManager.getWorkflowScheme(project.getGenericValue());
                        if (workflowScheme == null) {
                            return Collections.singletonList("jira");
                        }
                        ArrayList<String> workflowNames = new ArrayList<String>(128);
                        GenericValue defaultEntity = workflowSchemeManager.getDefaultEntity(workflowScheme);
                        if (defaultEntity != null) {
                            workflowNames.add(defaultEntity.getString("workflow"));
                        }
                        for (GenericValue entity : workflowSchemeManager.getNonDefaultEntities(workflowScheme)) {
                            workflowNames.add(entity.getString("workflow"));
                        }
                        return workflowNames;
                    }
                    catch (GenericEntityException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        IsStatusVisible(ApplicationUser user, PermissionManager permissionManager, WorkflowManager workflowManager, WorkflowFetcher workflowFetcher) {
            this.permissionManager = permissionManager;
            this.workflowManager = workflowManager;
            this.projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user).iterator();
            this.workflowFetcher = workflowFetcher;
        }

        public boolean apply(Status input) {
            do {
                if (!this.seenStatusIds.contains(input.getId())) continue;
                return true;
            } while (this.findMoreStatuses());
            return false;
        }

        private boolean findMoreStatuses() {
            boolean changed = false;
            while (!changed && this.hasMoreWorkflows()) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(this.pendingWorkflowNames.removeFirst());
                List steps = workflow.getDescriptor().getSteps();
                for (StepDescriptor step : steps) {
                    String linkedStatusId = (String)step.getMetaAttributes().get("jira.status.id");
                    changed |= this.seenStatusIds.add(linkedStatusId);
                }
            }
            return changed;
        }

        private boolean hasMoreWorkflows() {
            while (this.pendingWorkflowNames.isEmpty()) {
                if (!this.projects.hasNext()) {
                    return false;
                }
                for (String workflowName : this.workflowFetcher.getWorkflowNames(this.projects.next())) {
                    if (!this.seenWorkflowNames.add(workflowName)) continue;
                    this.pendingWorkflowNames.addLast(workflowName);
                }
            }
            return true;
        }

        static interface WorkflowFetcher {
            public List<String> getWorkflowNames(Project var1);
        }
    }
}

