/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dashboard.item.property;

import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardNotFoundException;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStore;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStoreException;
import com.atlassian.jira.bc.dashboard.DashboardItem;
import com.atlassian.jira.bc.dashboard.DashboardItems;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.event.dashboard.item.property.DashboardItemPropertyDeletedEvent;
import com.atlassian.jira.event.dashboard.item.property.DashboardItemPropertySetEvent;
import com.atlassian.jira.event.entity.EntityPropertyDeletedEvent;
import com.atlassian.jira.event.entity.EntityPropertySetEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import java.util.function.Predicate;

@InjectableComponent
public final class DashboardItemPropertyHelper
implements EntityPropertyHelper<DashboardItem> {
    private final DashboardPermissionService dashboardPermissionService;
    private final DashboardStateStore dashboardStateStore;
    private final EntityPropertyHelper.CheckPermissionFunction<DashboardItem> hasEditPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<DashboardItem>(){

        public ErrorCollection apply(ApplicationUser applicationUser, DashboardItem dashboardItem) {
            return DashboardItemPropertyHelper.this.errorCollectionIfFalse(DashboardItemPropertyHelper.this.dashboardPermissionService.isWritableBy(dashboardItem.getLocator().getDashboardId(), DashboardItemPropertyHelper.this.username(applicationUser)), "user " + DashboardItemPropertyHelper.this.name(applicationUser) + " doesn't have permission to edit dashboard item " + dashboardItem.getId());
        }
    };
    private final EntityPropertyHelper.CheckPermissionFunction<DashboardItem> hasReadPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<DashboardItem>(){

        public ErrorCollection apply(ApplicationUser applicationUser, DashboardItem dashboardItem) {
            return DashboardItemPropertyHelper.this.errorCollectionIfFalse(DashboardItemPropertyHelper.this.dashboardPermissionService.isReadableBy(dashboardItem.getLocator().getDashboardId(), DashboardItemPropertyHelper.this.username(applicationUser)), "user " + DashboardItemPropertyHelper.this.name(applicationUser) + " doesn't have permission to access dashboard item " + dashboardItem.getId());
        }
    };
    private final java.util.function.Function<Long, Option<DashboardItem>> getEntityByIdFunction = new java.util.function.Function<Long, Option<DashboardItem>>(){

        @Override
        public Option<DashboardItem> apply(final Long itemId) {
            try {
                return Option.option((Object)DashboardItemPropertyHelper.this.dashboardStateStore.findDashboardWithGadget(GadgetId.valueOf((String)String.valueOf(itemId)))).flatMap((java.util.function.Function)new java.util.function.Function<DashboardState, Option<DashboardItem>>(){

                    @Override
                    public Option<DashboardItem> apply(final DashboardState dashboard) {
                        Iterable allItemsInDashboard = Iterables.transform((Iterable)Iterables.concat((Iterable)dashboard.getDashboardColumns().getColumns()), (Function)new Function<DashboardItemState, DashboardItem>(){

                            public DashboardItem apply(DashboardItemState dashboardItemState) {
                                return DashboardItems.fromDashboardItemState((DashboardItemState)dashboardItemState, (DashboardId)dashboard.getId());
                            }
                        });
                        return Option.option((Object)((DashboardItem)io.atlassian.fugue.Iterables.findFirst((Iterable)allItemsInDashboard, (Predicate)new Predicate<DashboardItem>(){

                            @Override
                            public boolean test(DashboardItem dashboardItem) {
                                return dashboardItem.getId().equals(itemId);
                            }
                        }).getOrNull()));
                    }
                });
            }
            catch (DashboardStateStoreException ex) {
                return Option.none();
            }
            catch (DashboardNotFoundException ex) {
                return Option.none();
            }
        }
    };
    private final BiFunction<ApplicationUser, EntityProperty, EntityPropertySetEvent> createSetPropertyEventFunction = new BiFunction<ApplicationUser, EntityProperty, EntityPropertySetEvent>(){

        @Override
        public EntityPropertySetEvent apply(ApplicationUser applicationUser, EntityProperty entityProperty) {
            return new DashboardItemPropertySetEvent(entityProperty, applicationUser);
        }
    };
    private final BiFunction<ApplicationUser, EntityProperty, EntityPropertyDeletedEvent> createDeletePropertyEventFunction = new BiFunction<ApplicationUser, EntityProperty, EntityPropertyDeletedEvent>(){

        @Override
        public EntityPropertyDeletedEvent apply(ApplicationUser applicationUser, EntityProperty entityProperty) {
            return new DashboardItemPropertyDeletedEvent(entityProperty, applicationUser);
        }
    };

    private String username(ApplicationUser applicationUser) {
        return applicationUser != null ? applicationUser.getUsername() : null;
    }

    private String name(ApplicationUser applicationUser) {
        return applicationUser != null ? applicationUser.getName() : null;
    }

    public DashboardItemPropertyHelper(DashboardPermissionService dashboardPermissionService, DashboardStateStore dashboardStateStore) {
        this.dashboardPermissionService = dashboardPermissionService;
        this.dashboardStateStore = dashboardStateStore;
    }

    public EntityPropertyHelper.CheckPermissionFunction<DashboardItem> hasEditPermissionFunction() {
        return this.hasEditPermissionFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<DashboardItem> hasReadPermissionFunction() {
        return this.hasReadPermissionFunction;
    }

    public java.util.function.Function<Long, Option<DashboardItem>> getEntityByIdFunction() {
        return this.getEntityByIdFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertySetEvent> createSetPropertyEventBiFunction() {
        return this.createSetPropertyEventFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertyDeletedEvent> createDeletePropertyEventBiFunction() {
        return this.createDeletePropertyEventFunction;
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.DASHBOARD_ITEM_PROPERTY;
    }

    private ErrorCollection errorCollectionIfFalse(boolean hasPermission, String message) {
        return hasPermission ? new SimpleErrorCollection() : new SimpleErrorCollection(message, ErrorCollection.Reason.FORBIDDEN);
    }
}

