/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.activeobjects.spi.ActiveObjectsImportExportException;
import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.NullBackupProgressMonitor;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.core.util.DataUtils;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.action.admin.export.EntitiesExporter;
import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.dataimport.EntityImportExportExclusions;
import com.atlassian.jira.bc.dataimport.ExportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ExportFailedEvent;
import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.bc.dataimport.ExportStartedEvent;
import com.atlassian.jira.bc.dataimport.ExportSuccessfulEvent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.filestore.S3FileStoreConfig;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.filestore.BackupFileStoreProvider;
import com.atlassian.jira.filestore.S3BackupFileStoreProvider;
import com.atlassian.jira.imports.xml.BackupPathProvider;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportService
implements ExportService {
    public static final String ACTIVEOBJECTS_XML = "activeobjects.xml";
    public static final String ENTITIES_XML = "entities.xml";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExportService.class);
    private final DelegatorInterface genericDelegator;
    private final EntitiesExporter entitiesExporter;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;
    private final JiraProperties jiraSystemProperties;
    private final BackupPathProvider backupPathProvider;
    private final BackupFileStoreProvider backupFileStoreProvider;
    private final FileStores fileStores;

    public DefaultExportService(DelegatorInterface genericDelegator, EntitiesExporter entitiesExporter, I18nHelper.BeanFactory i18nFactory, EventPublisher eventPublisher, JiraProperties jiraSystemProperties, BackupPathProvider backupPathProvider, BackupFileStoreProvider backupFileStoreProvider, FileStores fileStores) {
        this.genericDelegator = genericDelegator;
        this.entitiesExporter = entitiesExporter;
        this.i18nFactory = i18nFactory;
        this.eventPublisher = eventPublisher;
        this.jiraSystemProperties = jiraSystemProperties;
        this.backupPathProvider = backupPathProvider;
        this.backupFileStoreProvider = backupFileStoreProvider;
        this.fileStores = fileStores;
    }

    @Override
    public ServiceOutcome<Void> export(ApplicationUser loggedInUser, String filename, TaskProgressSink taskProgressSink) {
        return this.export(loggedInUser, filename, ExportService.Style.NORMAL, taskProgressSink);
    }

    @Override
    public ServiceOutcome<Void> export(ApplicationUser loggedInUser, String filename, ExportService.Style style, TaskProgressSink taskProgressSink) {
        String auditLogFilePath = this.backupPathProvider.isS3InUse() ? this.getS3FilePath(filename) : filename;
        long xmlExportTime = System.currentTimeMillis();
        this.publishExportStart(loggedInUser, auditLogFilePath, xmlExportTime);
        I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
        try {
            BackupZipFileLocation backupZipFileLocation = this.createBackupZipFile(loggedInUser, filename, style);
            if (this.shouldCopyToBackupFileStore(backupZipFileLocation)) {
                this.moveBackupToFileStoreLocation(backupZipFileLocation);
            }
            ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.ok(null);
            this.publishExportSuccess(loggedInUser, auditLogFilePath, xmlExportTime, outcome);
            return outcome;
        }
        catch (GenericEntityException e) {
            if (e.getMessage() != null && e.getMessage().contains("invalid XML character")) {
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                errorCollection.addErrorMessage(i18n.getText("admin.export.backup.data.invalid.characters"), ErrorCollection.Reason.VALIDATION_FAILED);
                ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
                this.publishExportFailure(loggedInUser, auditLogFilePath, xmlExportTime, outcome, ExportFailedEvent.Reason.INVALID_XML);
                return outcome;
            }
            LOG.error("Error during XML backup.", (Throwable)e);
            ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.dataexport.error.exporting.data", (Object)e));
            this.publishExportFailure(loggedInUser, auditLogFilePath, xmlExportTime, outcome, ExportFailedEvent.Reason.GENERIC);
            return outcome;
        }
        catch (ActiveObjectsImportExportException e) {
            LOG.error("Error during Active Objects Backup", (Throwable)e);
            ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.export.backup.activeobjects.exception", e.getPluginInformation().getPluginName()));
            this.publishExportFailure(loggedInUser, auditLogFilePath, xmlExportTime, outcome, ExportFailedEvent.Reason.ACTIVE_OBJECTS);
            return outcome;
        }
        catch (IOException e) {
            LOG.error("Error during XML backup.", (Throwable)e);
            ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.export.ioerror", filename));
            this.publishExportFailure(loggedInUser, auditLogFilePath, xmlExportTime, outcome, ExportFailedEvent.Reason.IO);
            return outcome;
        }
    }

    @Override
    public ServiceOutcome<Void> exportForDevelopment(ApplicationUser loggedInUser, String xmlFilename, TaskProgressSink taskProgressSink) {
        ServiceOutcomeImpl<Object> serviceOutcomeImpl;
        block11: {
            ExportService.Style style = ExportService.Style.NORMAL;
            I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
            long xmlExportTime = System.currentTimeMillis();
            this.publishExportStart(loggedInUser, xmlFilename, xmlExportTime);
            OutputStream xml = this.getXmlOutputStream(xmlFilename);
            try {
                this.exportJIRA(loggedInUser, style, xml);
                ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.ok(null);
                this.publishExportSuccess(loggedInUser, xmlFilename, xmlExportTime, outcome);
                serviceOutcomeImpl = outcome;
                if (xml == null) break block11;
            }
            catch (Throwable outcome) {
                try {
                    try {
                        if (xml != null) {
                            try {
                                xml.close();
                            }
                            catch (Throwable throwable) {
                                outcome.addSuppressed(throwable);
                            }
                        }
                        throw outcome;
                    }
                    catch (GenericEntityException e) {
                        if (e.getMessage() != null && e.getMessage().contains("invalid XML character")) {
                            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                            errorCollection.addErrorMessage(i18n.getText("admin.export.backup.data.invalid.characters"), ErrorCollection.Reason.VALIDATION_FAILED);
                            ServiceOutcomeImpl<Object> outcome2 = ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
                            this.publishExportFailure(loggedInUser, xmlFilename, xmlExportTime, outcome2, ExportFailedEvent.Reason.INVALID_XML);
                            return outcome2;
                        }
                        ServiceOutcomeImpl<Void> outcome3 = ServiceOutcomeImpl.error(i18n.getText("admin.errors.dataexport.error.exporting.data", (Object)e));
                        this.publishExportFailure(loggedInUser, xmlFilename, xmlExportTime, outcome3, ExportFailedEvent.Reason.GENERIC);
                        return outcome3;
                    }
                }
                catch (IOException e) {
                    LOG.error("Error during XML backup.", (Throwable)e);
                    ServiceOutcomeImpl<Void> outcome4 = ServiceOutcomeImpl.error(i18n.getText("admin.errors.export.ioerror", xmlFilename));
                    this.publishExportFailure(loggedInUser, xmlFilename, xmlExportTime, outcome4, ExportFailedEvent.Reason.IO);
                    return outcome4;
                }
            }
            xml.close();
        }
        return serviceOutcomeImpl;
    }

    @VisibleForTesting
    void tryToDeleteFile(String filename) throws IOException {
        Files.delete(Paths.get(filename, new String[0]));
    }

    @VisibleForTesting
    FileStore.Path createPath(String filename) {
        return FilesystemFileStore.forFile((File)new File(filename));
    }

    private boolean shouldCopyToBackupFileStore(BackupZipFileLocation backupZipFileLocation) {
        return backupZipFileLocation.fileStorePath.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveBackupToFileStoreLocation(BackupZipFileLocation backupZipFileLocation) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(backupZipFileLocation.localFilePath);){
            if (!backupZipFileLocation.fileStorePath.isPresent()) {
                throw new IOException("File store path is not present for backup file: " + backupZipFileLocation.localFilePath);
            }
            this.createPath(backupZipFileLocation.localFilePath).copyFile(backupZipFileLocation.fileStorePath.get());
            LOG.info("Backup file has been written to file store: {}", (Object)backupZipFileLocation.fileStorePath.get());
        }
        finally {
            try {
                this.tryToDeleteFile(backupZipFileLocation.localFilePath);
                LOG.info("Backup file has been deleted from temp directory: {}", (Object)backupZipFileLocation.localFilePath);
            }
            catch (IOException e) {
                LOG.error("Error deleting file: " + backupZipFileLocation.localFilePath, (Throwable)e);
            }
        }
    }

    private BackupZipFileLocation createBackupZipFile(ApplicationUser loggedInUser, String filename, ExportService.Style style) throws IOException, GenericEntityException {
        BackupZipFileLocation backupZipFileLocation = this.getBackupZipFileLocation(filename);
        LOG.info("Creating backup zip file: {}", (Object)backupZipFileLocation.localFilePath);
        try (ZipArchiveOutputStream zip = this.getZipOutputStream(backupZipFileLocation.localFilePath);){
            zip.setUseZip64(Zip64Mode.AsNeeded);
            zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(ENTITIES_XML));
            this.exportJIRA(loggedInUser, style, (OutputStream)zip);
            zip.closeArchiveEntry();
            zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(ACTIVEOBJECTS_XML));
            this.exportActiveObjects((OutputStream)zip);
            zip.closeArchiveEntry();
            BackupZipFileLocation backupZipFileLocation2 = backupZipFileLocation;
            return backupZipFileLocation2;
        }
    }

    private void publishExportStart(ApplicationUser loggedInUser, String xmlFilename, long xmlExportTime) {
        this.eventPublisher.publish((Object)new ExportStartedEvent(loggedInUser, xmlFilename, Long.valueOf(xmlExportTime)));
    }

    private void publishExportSuccess(ApplicationUser loggedInUser, String xmlFilename, long xmlExportTime, ServiceOutcomeImpl<Void> outcome) {
        this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, xmlFilename, outcome, Long.valueOf(xmlExportTime)));
        this.eventPublisher.publish((Object)new ExportSuccessfulEvent(xmlExportTime, System.currentTimeMillis() - xmlExportTime));
    }

    private void publishExportFailure(ApplicationUser loggedInUser, String xmlFilename, long xmlExportTime, ServiceOutcomeImpl<Void> outcome, ExportFailedEvent.Reason reason) {
        this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, xmlFilename, outcome, Long.valueOf(xmlExportTime)));
        this.eventPublisher.publish((Object)new ExportFailedEvent(xmlExportTime, System.currentTimeMillis() - xmlExportTime, reason));
    }

    private void exportJIRA(ApplicationUser loggedInUser, ExportService.Style style, OutputStream out) throws GenericEntityException, IOException {
        TreeSet<String> entityNames = this.entitiesToExport();
        int numberOfEntities = entityNames.size();
        LOG.debug("numberOfEntities = " + numberOfEntities);
        EntityXmlWriter entityWriter = style.getEntityXmlWriter();
        long start = System.currentTimeMillis();
        long entitiesWritten = this.entitiesExporter.exportEntities(out, entityNames, entityWriter, loggedInUser);
        LOG.info("Data export completed in " + (System.currentTimeMillis() - start) + "ms. Wrote " + entitiesWritten + " entities to export in memory.");
    }

    private void exportActiveObjects(OutputStream out) throws IOException {
        Backup activeObjects = this.getActiveObjectsBackup();
        if (activeObjects == null) {
            LOG.error("Could not find ActiveObjects in OSGi fairy land. Plugins using ActiveObjects have not been backed up.");
        } else {
            LOG.info("Attempting to save the Active Objects Backup");
            try {
                activeObjects.save(out, NullBackupProgressMonitor.INSTANCE);
            }
            catch (NoSuchMethodError ex) {
                String javaRuntimeVersion = this.jiraSystemProperties.getProperty("java.runtime.version");
                String message = "Error exporting Active Objects. You must run JRE 1.6_18 or higher. java.runtime.version: " + javaRuntimeVersion;
                LOG.error(message, (Throwable)ex);
                throw new NoSuchMethodError(message);
            }
            LOG.info("Finished saving the Active Objects Backup");
        }
    }

    protected Backup getActiveObjectsBackup() {
        return (Backup)ComponentAccessor.getOSGiComponentInstanceOfType(Backup.class);
    }

    protected ZipArchiveOutputStream getZipOutputStream(String filename) throws IOException {
        String zipFileName = DataUtils.getZipFilename((String)filename);
        File zipFile = new File(zipFileName);
        FileUtils.openOutputStream((File)zipFile).close();
        return new ZipArchiveOutputStream(zipFile);
    }

    protected OutputStream getXmlOutputStream(String filename) throws IOException {
        String xmlFileName = DataUtils.getXmlFilename((String)filename);
        return FileUtils.openOutputStream((File)new File(xmlFileName));
    }

    private TreeSet<String> entitiesToExport() throws GenericEntityException {
        ModelReader reader = this.genericDelegator.getModelReader();
        return Sets.newTreeSet((Iterable)Sets.difference((Set)Sets.newHashSet((Iterable)reader.getEntityNames()), EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT));
    }

    private BackupZipFileLocation getBackupZipFileLocation(String filename) throws IOException {
        boolean useFileStore = this.shouldUseFileStore(filename);
        String requestedAbsPath = DataUtils.getZipFilename((String)filename);
        String zipFileName = new File(requestedAbsPath).getName();
        if (!useFileStore) {
            return new BackupZipFileLocation(requestedAbsPath, Optional.empty());
        }
        FileStore.Path fileStorePath = this.backupFileStoreProvider.getBasePath().path(new String[]{zipFileName});
        File tempDirectory = FileUtils.getTempDirectory();
        String destinationFile = new File(tempDirectory, "xmlbackup_" + UUID.randomUUID() + "_" + zipFileName).getCanonicalPath();
        return new BackupZipFileLocation(destinationFile, Optional.of(fileStorePath));
    }

    private boolean shouldUseFileStore(String filename) {
        File parentFile = new File(filename).getParentFile();
        if (parentFile != null && parentFile.toPath().normalize().equals(this.fileStores.getExportPath().asJavaPath().normalize())) {
            return false;
        }
        return this.backupPathProvider.isFileStoreFullyConfigured();
    }

    private String getS3FilePath(String xmlFilename) {
        S3BackupFileStoreProvider s3backupFileStoreProvider = (S3BackupFileStoreProvider)this.backupFileStoreProvider;
        S3FileStoreConfig s3FileStoreConfig = s3backupFileStoreProvider.getS3FileStoreConfig();
        String bucketName = s3FileStoreConfig.getBucketName();
        String s3BackupsPathPrefix = s3backupFileStoreProvider.getS3BackupsPathPrefix();
        String filename = new File(xmlFilename).getName();
        return String.format("s3://%s/%s/%s", bucketName, s3BackupsPathPrefix, filename);
    }

    private static class BackupZipFileLocation {
        private final String localFilePath;
        private final Optional<FileStore.Path> fileStorePath;

        private BackupZipFileLocation(String localFilePath, Optional<FileStore.Path> fileStorePath) {
            this.localFilePath = localFilePath;
            this.fileStorePath = fileStorePath;
        }
    }
}

