/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.jira.action.admin.export.EscapedAttributes;
import com.atlassian.jira.bc.dataimport.EntityImportExportExclusions;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.imports.project.util.XMLEscapeUtil;
import com.atlassian.jira.model.querydsl.UpgradeHistoryDTO;
import com.atlassian.jira.model.querydsl.UpgradeVersionHistoryDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.xml.SecureXmlEntityResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OfbizImportHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(OfbizImportHandler.class);
    static final Set<String> PROPERTY_ENTRY_VALUE_TAGS = ImmutableSet.of((Object)"OSPropertyDate", (Object)"OSPropertyDecimal", (Object)"OSPropertyNumber", (Object)"OSPropertyString", (Object)"OSPropertyText");
    private static final String ENTITY_ENGINE_XML = "entity-engine-xml";
    private static final String SQL_STATE_DEADLOCK = "40001";
    private static final int MAX_SQL_RETRIES = 5;
    private static final int INITIAL_STRING_BUILDER_BUFFER_SIZE = 16384;
    private static final int MAX_STRING_BUILDER_SIZE_TO_REUSE = 0x1000000;
    public static final SecureXmlEntityResolver EMPTY_ENTITY_RESOLVER = new SecureXmlEntityResolver();
    private final OfBizDelegator ofBizDelegator;
    private final Executor executor;
    private TaskProgressSink taskProgressSink = TaskProgressSink.NULL_SINK;
    private final Map<String, String> osPropertyStringMap = new HashMap<String, String>();
    private final Map<String, String> osPropertyTextMap = new HashMap<String, String>();
    private final Map<String, String> osPropertyNumberMap = new HashMap<String, String>();
    private final Set<String> propertyKeysRequiredByPlugins;
    private final Map<String, String> propertyKeyToId = new HashMap<String, String>();
    private final AtomicReference<Throwable> importError = new AtomicReference();
    private final Map<String, Long> latestPropertyEntryIdByUniqueKey = new HashMap<String, Long>();
    private final Set<Long> latestPropertyEntryIds = new HashSet<Long>();
    private final List<String> licenseStrings = new ArrayList<String>();
    private final Map<String, String> licenseIds = new HashMap<String, String>();
    private StringBuilder textBuffer = new StringBuilder(16384);
    private boolean hasText;
    private boolean hasRootElement;
    private List<GenericValue> valueBatch;
    private ErrorCollection errorCollection;
    private String inEntity;
    @Nullable
    private GenericValue value;
    private boolean createEntities;
    private long entityCount;
    private String buildNumberId;
    private String buildNumber;
    private String versionId;
    private String version;
    private String minimumDowngradeVersionId;
    private String minimumDowngradeVersion;
    private Option<String> exportDate;
    private final List<UpgradeHistoryDTO> upgradeHistoryItems = new LinkedList<UpgradeHistoryDTO>();
    private final List<UpgradeVersionHistoryDTO> upgradeVersionHistoryItems = new ArrayList<UpgradeVersionHistoryDTO>();

    OfbizImportHandler(OfBizDelegator ofBizDelegator, Executor executor) {
        this(ofBizDelegator, executor, Collections.emptySet());
    }

    public OfbizImportHandler(OfBizDelegator ofBizDelegator, Executor executor, Set<String> propertyKeysRequiredByPlugins) {
        this.ofBizDelegator = ofBizDelegator;
        this.executor = executor;
        this.propertyKeysRequiredByPlugins = Sets.newHashSet(propertyKeysRequiredByPlugins);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return EMPTY_ENTITY_RESOLVER.resolveEntity(publicId, systemId);
    }

    @Override
    public void startDocument() throws SAXException {
        log.debug("Starting Document");
        this.entityCount = 0L;
        this.errorCollection = new SimpleErrorCollection();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.hasRootElement) {
            throw new SAXException("XML file ended too early.  There was no </entity-engine-xml> tag.");
        }
        this.createBuildNumber();
        this.createVersionString();
        this.createMinimumDowngradeVersionString();
        this.createLicenseString();
        log.debug("Ending Document");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.importError.get() != null) {
            throw new SAXException(new Exception(this.importError.get()));
        }
        if (this.hasRootElement) {
            if (this.inEntity != null) {
                if (!EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT.contains(this.inEntity)) {
                    if (this.value == null) {
                        throw new SAXException("Somehow we have got inside an Entity without creating a GenericValue for it.");
                    }
                    log.debug("Read opening subelement {} of entity {}", (Object)qName, (Object)this.value.getEntityName());
                    this.resetTextBuffer();
                }
            } else {
                log.debug("Read opening {} element", (Object)qName);
                EscapedAttributes decodedAttributes = new EscapedAttributes(attributes);
                this.inEntity = qName;
                this.value = this.createEntities ? this.parseValue(qName, decodedAttributes) : this.parseValueFailsafe(qName, decodedAttributes);
                this.recordElementsInfo(qName, decodedAttributes);
                this.recordUpgradeHistory(qName, this.value);
            }
        } else if (ENTITY_ENGINE_XML.equals(qName)) {
            log.debug("Read opening ROOT element");
            this.hasRootElement = true;
            this.valueBatch = new ArrayList<GenericValue>();
            String date = attributes.getValue("date");
            this.exportDate = Option.option((Object)date);
            if (this.createEntities) {
                this.latestPropertyEntryIds.addAll(this.latestPropertyEntryIdByUniqueKey.values());
            }
        } else {
            throw new SAXException("The XML document does not contain the <entity-engine-xml> root element or it was closed too early.");
        }
    }

    private void recordLicenseInfo(String qName, GenericValue value) {
        if (!qName.equals("ProductLicense")) {
            return;
        }
        String license = value.getString("license");
        if (license != null) {
            this.licenseStrings.add(license);
        }
    }

    @VisibleForTesting
    void recordUpgradeHistory(String qName, GenericValue gv) {
        if (qName.equals("UpgradeHistory")) {
            this.upgradeHistoryItems.add(UpgradeHistoryDTO.fromGenericValue(gv));
        } else if (qName.equals("UpgradeVersionHistory")) {
            this.upgradeVersionHistoryItems.add(UpgradeVersionHistoryDTO.fromGenericValue(gv));
        }
    }

    private GenericValue parseValueFailsafe(String qName, Attributes decodedAttributes) {
        try {
            return this.parseValue(qName, decodedAttributes);
        }
        catch (RuntimeException e) {
            if (log.isInfoEnabled()) {
                log.info("Failed to parse value for element " + qName + ".", (Throwable)e);
            }
            if (!this.errorCollection.hasAnyErrors()) {
                this.errorCollection.addErrorMessage(e.getMessage());
            }
            return new GenericValue(new ModelEntity());
        }
    }

    private GenericValue parseValue(String qName, Attributes decodedAttributes) {
        GenericValue genericValue = this.ofBizDelegator.makeValue(qName);
        ModelEntity modelEntity = genericValue.getModelEntity();
        if (EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT.contains(modelEntity.getEntityName())) {
            return null;
        }
        Iterator i = modelEntity.getFieldsIterator();
        while (i.hasNext()) {
            ModelField modelField = (ModelField)i.next();
            String name = modelField.getName();
            String attr = decodedAttributes.getValue(name);
            if (attr == null) continue;
            try {
                log.debug("Setting attribute {} with value {}", (Object)name, (Object)attr);
                genericValue.setString(name, attr);
            }
            catch (RuntimeException e) {
                log.error("Failed to set attribute '" + qName + "." + name + "' with value '" + attr + "'. Error: " + e.getMessage());
                throw e;
            }
        }
        return genericValue;
    }

    void createBuildNumber() {
        if (this.buildNumberId != null) {
            this.buildNumber = this.osPropertyStringMap.get(this.buildNumberId);
        }
    }

    private void createVersionString() {
        if (this.versionId != null) {
            this.version = this.osPropertyStringMap.get(this.versionId);
        }
    }

    private void createMinimumDowngradeVersionString() {
        if (this.minimumDowngradeVersionId != null) {
            this.minimumDowngradeVersion = this.osPropertyStringMap.get(this.minimumDowngradeVersionId);
        }
    }

    void createLicenseString() {
        String license = this.osPropertyTextMap.get(this.licenseIds.get("License20"));
        if (license != null) {
            this.licenseStrings.add(license);
        }
    }

    void recordElementsInfo(String qName, Attributes attributes) {
        this.recordProperties(qName, attributes, "OSPropertyString", this.osPropertyStringMap);
        this.recordProperties(qName, attributes, "OSPropertyText", this.osPropertyTextMap);
        this.recordProperties(qName, attributes, "OSPropertyNumber", this.osPropertyNumberMap);
        if (this.isPropertyEntry(qName, attributes, "jira.version.patched")) {
            this.buildNumberId = attributes.getValue("id");
        }
        if (this.isPropertyEntry(qName, attributes, "jira.version")) {
            this.versionId = attributes.getValue("id");
        }
        if (this.isPropertyEntry(qName, attributes, "jira.downgrade.minimum.version")) {
            this.minimumDowngradeVersionId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "License20")) {
            this.licenseIds.put("License20", attributes.getValue("id"));
        }
        if (StringUtils.equals((CharSequence)"OSPropertyEntry", (CharSequence)qName) && this.propertyKeysRequiredByPlugins.contains(attributes.getValue("propertyKey")) && StringUtils.isNotBlank((CharSequence)attributes.getValue("id"))) {
            this.propertyKeyToId.put(attributes.getValue("propertyKey"), attributes.getValue("id"));
        }
    }

    private void recordGenericValueInfo(String entityName, GenericValue value) {
        if (entityName.equals("OSPropertyText")) {
            this.recordOsPropertyTextValue(value);
        }
    }

    private void recordProperties(String qName, Attributes attributes, String entityName, Map<String, String> store) {
        if (entityName.equals(qName)) {
            String id = attributes.getValue("id");
            String value = attributes.getValue("value");
            if (id != null && value != null) {
                store.put(id, value);
            }
        }
    }

    private void recordOsPropertyTextValue(GenericValue genericValue) {
        String id = genericValue.getString("id");
        String value = genericValue.getString("value");
        if (id != null && value != null) {
            this.osPropertyTextMap.put(id, value);
        }
    }

    private boolean isPropertyEntry(String qName, Attributes attributes, String property) {
        return StringUtils.equals((CharSequence)"OSPropertyEntry", (CharSequence)qName) && StringUtils.equals((CharSequence)property, (CharSequence)attributes.getValue("propertyKey")) && StringUtils.isNotBlank((CharSequence)attributes.getValue("id"));
    }

    private boolean isPropertyString(String qName) {
        return StringUtils.equals((CharSequence)"OSPropertyString", (CharSequence)qName);
    }

    private boolean isPropertyNumber(String qName) {
        return StringUtils.equals((CharSequence)"OSPropertyNumber", (CharSequence)qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.hasRootElement) {
            if (ENTITY_ENGINE_XML.equals(qName)) {
                if (this.createEntities) {
                    this.createValue(this.valueBatch);
                    this.valueBatch = new ArrayList<GenericValue>();
                }
                log.debug("Read closing ROOT element");
                this.hasRootElement = false;
            } else {
                if (this.inEntity == null) {
                    throw new SAXException("There is no entity set");
                }
                if (this.inEntity.equals(qName)) {
                    this.recordGenericValueInfo(this.inEntity, this.value);
                    this.recordLicenseInfo(qName, this.value);
                    log.debug("Read closing " + qName + " element");
                    ++this.entityCount;
                    boolean isPropertyEntry = "OSPropertyEntry".equals(qName);
                    if (this.createEntities) {
                        long id;
                        if (this.valueBatch.size() > 64) {
                            this.createValue(this.valueBatch);
                            this.valueBatch = new ArrayList<GenericValue>();
                        }
                        boolean isPropertyEntryValue = PROPERTY_ENTRY_VALUE_TAGS.contains(qName);
                        if ((isPropertyEntry || isPropertyEntryValue) && !this.latestPropertyEntryIds.contains(id = Objects.requireNonNull(this.value.getLong("id")).longValue())) {
                            log.debug("Skipping {} with ID: {}", (Object)qName, (Object)id);
                            this.value = null;
                        }
                        if (this.value != null) {
                            this.valueBatch.add(this.value);
                        }
                        this.taskProgressSink.makeProgress(this.entityCount, "data.import.store.entities", "data.import.store.entities.progress");
                    } else if (isPropertyEntry) {
                        this.recordLatestPropertyEntryId(this.value);
                    }
                    this.value = null;
                    this.inEntity = null;
                } else if (!EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT.contains(this.inEntity)) {
                    log.debug("Read closing subelement " + qName + " of entity " + this.value);
                    if (this.hasText) {
                        if (log.isDebugEnabled()) {
                            log.debug("Setting attribute " + qName + " with value " + this.textBuffer.toString());
                        }
                        this.value.setString(qName, this.textBuffer.toString());
                    }
                }
                this.resetTextBuffer();
            }
        } else {
            throw new SAXException("How did we get here an exception should already have been thrown");
        }
    }

    private void recordLatestPropertyEntryId(GenericValue value) {
        String entityName = Objects.requireNonNull(value.getString("entityName"));
        long entityId = Objects.requireNonNull(value.getLong("entityId"));
        String propertyKey = Objects.requireNonNull(value.getString("propertyKey"));
        long id = Objects.requireNonNull(value.getLong("id"));
        this.latestPropertyEntryIdByUniqueKey.merge(String.format("%s-%s-%s", entityName, entityId, propertyKey), id, Long::max);
    }

    private void createValue(List<GenericValue> valueBatch) {
        this.executor.execute(() -> {
            try {
                this.createWithRetry(valueBatch);
            }
            catch (Error e) {
                log.error("Exception importing entity: " + e, (Throwable)e);
                this.importError.set(e);
                throw e;
            }
            catch (Exception e) {
                log.error("Exception importing entity: " + e, (Throwable)e);
                this.importError.set(new DataAccessException((Throwable)e));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWithRetry(List<GenericValue> valueBatch) throws GenericEntityException {
        boolean failed;
        int attempts = 0;
        do {
            failed = false;
            Transaction transaction = Txn.begin();
            try {
                for (GenericValue genericValue : valueBatch) {
                    genericValue.create();
                }
                transaction.commit();
            }
            catch (GenericEntityException e) {
                String sqlState = OfbizImportHandler.getSqlState(e);
                if (++attempts <= 5) {
                    failed = true;
                    if (sqlState != null && sqlState.equals(SQL_STATE_DEADLOCK)) {
                        log.warn("SQL deadlock detected. Attempt [{}] out of [{}]", (Object)attempts, (Object)5);
                        continue;
                    }
                    log.warn("Create failed - retrying. Attempt [{}] out of [{}]", new Object[]{attempts, 5, e});
                    continue;
                }
                throw e;
            }
            finally {
                transaction.finallyRollbackIfNotCommitted();
                if (failed) {
                    try {
                        Thread.sleep((int)(Math.random() * 100.0) + attempts * 100);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } while (failed);
    }

    private static String getSqlState(GenericEntityException e) {
        Throwable ex = e.getNested();
        while (ex != null) {
            if (ex instanceof SQLException) {
                return ((SQLException)ex).getSQLState();
            }
            if (ex instanceof GenericEntityException) {
                ex = ((GenericEntityException)ex).getNested();
                continue;
            }
            ex = null;
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = XMLEscapeUtil.unicodeDecode(new String(ch, start, length));
        this.textBuffer.append(s);
        this.hasText = true;
    }

    private void resetTextBuffer() {
        if (this.textBuffer.length() > 0x1000000) {
            this.textBuffer = new StringBuilder(16384);
        } else {
            this.textBuffer.setLength(0);
        }
        this.hasText = false;
    }

    public void setCreateEntities(boolean createEntities) {
        this.createEntities = createEntities;
    }

    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    public long getEntityCount() {
        return this.entityCount;
    }

    @Nullable
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Nonnull
    public Iterable<String> getLicenseStrings() {
        return this.licenseStrings;
    }

    public Throwable getImportError() {
        return this.importError.get();
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getMinimumDowngradeVersion() {
        return this.minimumDowngradeVersion;
    }

    @Nonnull
    public List<UpgradeHistoryDTO> getUpgradeHistory() {
        return this.upgradeHistoryItems;
    }

    public long getLastUpgradeBuildNumber() {
        return this.upgradeVersionHistoryItems.stream().map(UpgradeVersionHistoryDTO::getTargetbuild).mapToInt(Integer::parseInt).max().orElse(0);
    }

    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    public Option<String> getExportDate() {
        return this.exportDate;
    }

    Map<String, String> getOsPropertyStringMap() {
        return Collections.unmodifiableMap(this.osPropertyStringMap);
    }

    Map<String, String> getOsPropertyTextMap() {
        return Collections.unmodifiableMap(this.osPropertyTextMap);
    }

    Map<String, String> getOsPropertyNumberMap() {
        return Collections.unmodifiableMap(this.osPropertyNumberMap);
    }

    Map<String, String> getPropertyKeyToId() {
        return Collections.unmodifiableMap(this.propertyKeyToId);
    }
}

