/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.filter;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.filter.SearchRequestAdminService;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAdminManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.util.SimpleSearchRequestDisplay;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DefaultSearchRequestAdminService
implements SearchRequestAdminService {
    private final SearchRequestAdminManager searchRequestAdminManager;
    private final FavouritesManager<SearchRequest> favouritesManager;

    public DefaultSearchRequestAdminService(SearchRequestAdminManager searchRequestAdminManager, FavouritesManager<SearchRequest> favouritesManager) {
        this.searchRequestAdminManager = (SearchRequestAdminManager)Assertions.notNull((String)"searchRequestAdminManager", (Object)searchRequestAdminManager);
        this.favouritesManager = (FavouritesManager)Assertions.notNull((String)"favouritesManager", favouritesManager);
    }

    @Override
    public Collection<SimpleSearchRequestDisplay> getFiltersSharedWithGroup(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        Resolver searchRequestToDisplayObject = input -> new SimpleSearchRequestDisplay((SearchRequest)input);
        EnclosedIterable<SearchRequest> searchRequests = this.searchRequestAdminManager.getSearchRequests(group);
        List displayObjects = new EnclosedIterable.ListResolver().apply(Transformed.enclosedIterable(searchRequests, (Function)searchRequestToDisplayObject));
        return Collections.unmodifiableCollection(displayObjects);
    }

    private void deleteFilter(SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        this.favouritesManager.removeFavouritesForEntityDelete((SharedEntity)request);
        this.searchRequestAdminManager.delete(request.getId());
    }
}

