/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.changehistory.properties;

import com.atlassian.jira.bc.issue.properties.IssuePropertyHelper;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.event.entity.EntityPropertyDeletedEvent;
import com.atlassian.jira.event.entity.EntityPropertySetEvent;
import com.atlassian.jira.event.issue.changehistory.property.ChangeHistoryPropertyDeletedEvent;
import com.atlassian.jira.event.issue.changehistory.property.ChangeHistoryPropertySetEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ChangeHistoryPropertyHelper
implements EntityPropertyHelper<ChangeHistory> {
    private final IssueManager issueManager;
    private final I18nHelper i18n;
    private final EntityPropertyHelper.CheckPermissionFunction<ChangeHistory> readPermissionFunction;
    private final EntityPropertyHelper.CheckPermissionFunction<ChangeHistory> editPermissionFunction;
    private final BiFunction<ApplicationUser, EntityProperty, EntityPropertyDeletedEvent> createDeleteEventFunction;
    private final BiFunction<ApplicationUser, EntityProperty, EntityPropertySetEvent> createSetEventFunction;
    private final Function<Long, Option<ChangeHistory>> idToChangeHistoryFunction;

    public ChangeHistoryPropertyHelper(IssueManager issueManager, IssuePropertyHelper issuePropertyHelper, I18nHelper i18n, final ChangeHistoryManager changeHistoryManager) {
        this.issueManager = issueManager;
        this.i18n = i18n;
        this.editPermissionFunction = new ChangeGroupPermissionFunction((BiFunction<ApplicationUser, Issue, ErrorCollection>)issuePropertyHelper.hasEditPermissionFunction());
        this.readPermissionFunction = new ChangeGroupPermissionFunction((BiFunction<ApplicationUser, Issue, ErrorCollection>)issuePropertyHelper.hasReadPermissionFunction());
        this.createDeleteEventFunction = new BiFunction<ApplicationUser, EntityProperty, EntityPropertyDeletedEvent>(){

            @Override
            public EntityPropertyDeletedEvent apply(ApplicationUser user, EntityProperty entityProperty) {
                return new ChangeHistoryPropertyDeletedEvent(entityProperty, user);
            }
        };
        this.createSetEventFunction = new BiFunction<ApplicationUser, EntityProperty, EntityPropertySetEvent>(){

            @Override
            public EntityPropertySetEvent apply(ApplicationUser user, EntityProperty entityProperty) {
                return new ChangeHistoryPropertySetEvent(entityProperty, user);
            }
        };
        this.idToChangeHistoryFunction = new Function<Long, Option<ChangeHistory>>(){

            @Override
            public Option<ChangeHistory> apply(@Nullable Long input) {
                return Option.option((Object)changeHistoryManager.getChangeHistoryById(input));
            }
        };
    }

    public EntityPropertyHelper.CheckPermissionFunction<ChangeHistory> hasEditPermissionFunction() {
        return this.editPermissionFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<ChangeHistory> hasReadPermissionFunction() {
        return this.readPermissionFunction;
    }

    public Function<Long, Option<ChangeHistory>> getEntityByIdFunction() {
        return this.idToChangeHistoryFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertySetEvent> createSetPropertyEventBiFunction() {
        return this.createSetEventFunction;
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertyDeletedEvent> createDeletePropertyEventBiFunction() {
        return this.createDeleteEventFunction;
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.CHANGE_HISTORY_PROPERTY;
    }

    private class ChangeGroupPermissionFunction
    implements EntityPropertyHelper.CheckPermissionFunction<ChangeHistory> {
        private final BiFunction<ApplicationUser, Issue, ErrorCollection> issuePermissionFunction;

        private ChangeGroupPermissionFunction(BiFunction<ApplicationUser, Issue, ErrorCollection> issuePermissionFunction) {
            this.issuePermissionFunction = issuePermissionFunction;
        }

        private Either<ErrorCollection, Issue> getIssueFromChangeHistory(ChangeHistory changeGroup) {
            MutableIssue issueObject;
            if (changeGroup != null && changeGroup.getIssueId() != null && (issueObject = ChangeHistoryPropertyHelper.this.issueManager.getIssueObject(changeGroup.getIssueId())) != null) {
                return Either.right((Object)issueObject);
            }
            SimpleErrorCollection issueNotFound = new SimpleErrorCollection();
            issueNotFound.addErrorMessage(ChangeHistoryPropertyHelper.this.i18n.getText("issue.does.not.exist.title"), ErrorCollection.Reason.NOT_FOUND);
            return Either.left((Object)issueNotFound);
        }

        public ErrorCollection apply(ApplicationUser user, ChangeHistory changeGroup) {
            Either<ErrorCollection, Issue> issue = this.getIssueFromChangeHistory(changeGroup);
            if (issue.isLeft()) {
                return (ErrorCollection)issue.left().get();
            }
            return this.issuePermissionFunction.apply(user, (Issue)issue.right().get());
        }
    }
}

