/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.watcher;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWatcherService
implements WatcherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWatcherService.class);
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18n;
    private final PermissionManager permissionManager;
    private final WatcherManager watcherManager;
    private final UserManager userManager;

    public DefaultWatcherService(ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18n, PermissionManager permissionManager, WatcherManager watcherManager, UserManager userManager) {
        this.watcherManager = watcherManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    public ServiceOutcome<Pair<Integer, List<ApplicationUser>>> getWatchers(Issue issue, @Nullable ApplicationUser remoteUser) throws WatchingDisabledException {
        Pair<Integer, List<String>> watchers = this.getWatcherUsernames(issue, remoteUser);
        return ServiceOutcomeImpl.ok(this.convertUsers(watchers, new UserFromName()));
    }

    public ServiceOutcome<List<ApplicationUser>> addWatcher(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        Pair<Boolean, String> canWatchIssue = this.canWatchIssue(issue, remoteUser, watcher);
        if (((Boolean)canWatchIssue.first()).booleanValue()) {
            this.watcherManager.startWatching(watcher, issue);
            return ServiceOutcomeImpl.ok(this.getCurrentWatchersFor(issue));
        }
        return ServiceOutcomeImpl.error((String)canWatchIssue.second());
    }

    public WatcherService.BulkWatchResult addWatcherToAll(Collection<Issue> issues, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        return this.addWatcherToAll(issues, remoteUser, watcher, Contexts.nullContext());
    }

    public WatcherService.BulkWatchResult addWatcherToAll(Collection<Issue> issues, ApplicationUser remoteUser, ApplicationUser watcher, Context taskContext) throws WatchingDisabledException {
        ArrayList<Issue> successfulIssues = new ArrayList<Issue>();
        ArrayList<Pair> failedIssues = new ArrayList<Pair>();
        for (Issue issue : issues) {
            Pair<Boolean, String> canWatchIssue = this.canWatchIssue(issue, remoteUser, watcher);
            if (((Boolean)canWatchIssue.first()).booleanValue()) {
                successfulIssues.add(issue);
                continue;
            }
            failedIssues.add(Pair.nicePairOf((Object)issue, (Object)((String)canWatchIssue.second())));
        }
        if (!successfulIssues.isEmpty()) {
            this.watcherManager.startWatching(watcher, successfulIssues, taskContext);
        }
        return new WatcherService.BulkWatchResult(failedIssues);
    }

    public ServiceOutcome<List<ApplicationUser>> removeWatcher(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        Pair<Boolean, String> canUnwatchIssue = this.canUnwatchIssue(issue, remoteUser, watcher);
        if (((Boolean)canUnwatchIssue.first()).booleanValue()) {
            this.watcherManager.stopWatching(watcher, issue);
            return ServiceOutcomeImpl.ok(this.getCurrentWatchersFor(issue));
        }
        return ServiceOutcomeImpl.error((String)canUnwatchIssue.second());
    }

    public WatcherService.BulkWatchResult removeWatcherFromAll(Collection<Issue> issues, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        return this.removeWatcherFromAll(issues, remoteUser, watcher, Contexts.nullContext());
    }

    public WatcherService.BulkWatchResult removeWatcherFromAll(Collection<Issue> issues, ApplicationUser remoteUser, ApplicationUser watcher, Context taskContext) throws WatchingDisabledException {
        ArrayList<Issue> successfulIssues = new ArrayList<Issue>();
        ArrayList<Pair> failedIssues = new ArrayList<Pair>();
        for (Issue issue : issues) {
            Pair<Boolean, String> canUnwatchIssue = this.canUnwatchIssue(issue, remoteUser, watcher);
            if (((Boolean)canUnwatchIssue.first()).booleanValue()) {
                successfulIssues.add(issue);
                continue;
            }
            failedIssues.add(Pair.nicePairOf((Object)issue, (Object)((String)canUnwatchIssue.second())));
        }
        if (!successfulIssues.isEmpty()) {
            this.watcherManager.stopWatching(watcher, successfulIssues, taskContext);
        }
        return new WatcherService.BulkWatchResult(failedIssues);
    }

    private Pair<Boolean, String> canWatchIssue(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        try {
            if (!this.isWatchingEnabled() || issue.isArchived()) {
                throw new WatchingDisabledException();
            }
            boolean canView = this.permissionManager.hasPermission(10, issue, watcher);
            if (!canView) {
                return Pair.nicePairOf((Object)false, (Object)this.buildAddWatcherCannotViewString(issue, remoteUser, watcher));
            }
            this.checkModifyWatchersPermission(issue, remoteUser, watcher);
            return Pair.nicePairOf((Object)true, null);
        }
        catch (PermissionException e) {
            return Pair.nicePairOf((Object)false, (Object)this.buildAddWatcherNotAllowedString(issue, remoteUser));
        }
    }

    private Pair<Boolean, String> canUnwatchIssue(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        try {
            if (!this.isWatchingEnabled()) {
                throw new WatchingDisabledException();
            }
            this.checkModifyWatchersPermission(issue, remoteUser, watcher);
            return Pair.nicePairOf((Object)true, null);
        }
        catch (PermissionException e) {
            return Pair.nicePairOf((Object)false, (Object)this.buildRemoveUserNotAllowedString(issue, remoteUser));
        }
    }

    public boolean canWatchAll(Iterable<Issue> issues, ApplicationUser applicationUser) {
        if (!this.isWatchingEnabled()) {
            return false;
        }
        for (Issue issue : issues) {
            boolean canView = this.permissionManager.hasPermission(10, issue, applicationUser);
            if (canView) continue;
            return false;
        }
        return true;
    }

    public boolean canUnwatchAll(Iterable<Issue> issues, ApplicationUser remoteUser) {
        return this.isWatchingEnabled();
    }

    public boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    public boolean hasViewWatcherListPermission(Issue issue, @Nullable ApplicationUser remoteUser) {
        return this.permissionManager.hasPermission(31, issue, remoteUser) || this.canEditWatcherList(issue, remoteUser);
    }

    protected Pair<Integer, List<String>> getWatcherUsernames(Issue issue, ApplicationUser remoteUser) throws WatchingDisabledException {
        if (!this.isWatchingEnabled()) {
            throw new WatchingDisabledException();
        }
        List watcherNames = this.watcherManager.getCurrentWatcherUsernames(issue);
        int watcherCount = watcherNames.size();
        if (!this.hasViewWatcherListPermission(issue, remoteUser)) {
            if (remoteUser == null) {
                watcherNames.clear();
            } else {
                watcherNames.retainAll(Collections.singletonList(remoteUser.getName()));
            }
        }
        LOGGER.trace("Visible watchers on issue '{}': {}", (Object)issue.getKey(), (Object)watcherNames);
        return Pair.of((Object)watcherCount, (Object)watcherNames);
    }

    protected List<ApplicationUser> getCurrentWatchersFor(Issue issue) {
        List watcherNames = this.watcherManager.getCurrentWatcherUsernames(issue);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)watcherNames, (Function)new UserFromName()));
    }

    protected boolean canEditWatcherList(Issue issue, @Nullable ApplicationUser remoteUser) {
        return this.permissionManager.hasPermission(32, issue, remoteUser);
    }

    protected <T extends ApplicationUser> Pair<Integer, List<T>> convertUsers(Pair<Integer, List<String>> watchers, Function<String, T> function) {
        return Pair.of((Object)((Integer)watchers.first()), (Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)watchers.second()), function)));
    }

    protected void checkModifyWatchersPermission(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws PermissionException, WatchingDisabledException {
        boolean canManage = this.permissionManager.hasPermission(32, issue, remoteUser);
        if (!canManage && !remoteUser.equals((Object)watcher)) {
            throw new PermissionException();
        }
    }

    private String buildAddWatcherNotAllowedString(Issue issue, ApplicationUser remoteUser) {
        return this.i18n.getInstance(remoteUser).getText("watcher.service.error.add.watcher.not.allowed", remoteUser.getName(), issue.getKey());
    }

    private String buildAddWatcherCannotViewString(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) {
        return this.i18n.getInstance(remoteUser).getText("watcher.error.user.cant.see.issue", watcher.getName(), issue.getKey());
    }

    private String buildRemoveUserNotAllowedString(Issue issue, ApplicationUser remoteUser) {
        return this.i18n.getInstance(remoteUser).getText("watcher.service.error.remove.watcher.not.allowed", remoteUser.getName(), issue.getKey());
    }

    class UserFromName
    implements Function<String, ApplicationUser> {
        UserFromName() {
        }

        public ApplicationUser apply(String username) {
            return DefaultWatcherService.this.userManager.getUserByNameEvenWhenUnknown(username);
        }
    }

    static class PermissionException
    extends Exception {
        PermissionException() {
        }
    }
}

