/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.worklog;

import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.util.VisibilityValidator;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.bc.issue.visibility.VisibilityVisitors;
import com.atlassian.jira.bc.issue.worklog.DeletedWorklog;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountResult;
import com.atlassian.jira.bc.issue.worklog.WorklogChangedSincePage;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResultFactory;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.entity.PredicatedPagedList;
import com.atlassian.jira.issue.CommentSearchParameters;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogImpl2;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.Window;
import com.atlassian.jira.util.collect.PagedList;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Iterables;
import com.opensymphony.util.TextUtils;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorklogService
implements WorklogService {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorklogService.class);
    private final WorklogManager worklogManager;
    private final PermissionManager permissionManager;
    private final VisibilityValidator visibilityValidator;
    private final ProjectRoleManager projectRoleManager;
    private final IssueManager issueManager;
    private final TimeTrackingConfiguration timeTrackingConfiguration;
    private final JiraDurationUtils jiraDurationUtils;
    private final GroupManager groupManager;
    private static final String WORKLOG_I18N_PREFIX = "worklog";

    public DefaultWorklogService(WorklogManager worklogManager, PermissionManager permissionManager, VisibilityValidator visibilityValidator, ProjectRoleManager projectRoleManager, IssueManager issueManager, TimeTrackingConfiguration timeTrackingConfiguration, JiraDurationUtils jiraDurationUtils, GroupManager groupManager) {
        this.worklogManager = worklogManager;
        this.permissionManager = permissionManager;
        this.visibilityValidator = visibilityValidator;
        this.projectRoleManager = projectRoleManager;
        this.issueManager = issueManager;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.jiraDurationUtils = jiraDurationUtils;
        this.groupManager = groupManager;
    }

    public WorklogResult validateDelete(JiraServiceContext jiraServiceContext, Long worklogId) {
        Worklog originalWorklog = this.worklogManager.getById(worklogId);
        if (this.hasPermissionToDelete(jiraServiceContext, originalWorklog)) {
            return WorklogResultFactory.create((Worklog)originalWorklog);
        }
        return null;
    }

    public WorklogNewEstimateResult validateDeleteWithNewEstimate(JiraServiceContext jiraServiceContext, Long worklogId, String newEstimate) {
        WorklogResult originalWorklogResult = this.validateDelete(jiraServiceContext, worklogId);
        if (originalWorklogResult != null && this.isValidNewEstimate(jiraServiceContext, newEstimate)) {
            Long estimate = newEstimate == null ? null : Long.valueOf(this.getDurationForFormattedString(newEstimate, jiraServiceContext));
            return WorklogResultFactory.createNewEstimate((WorklogResult)originalWorklogResult, (Long)estimate);
        }
        return null;
    }

    public WorklogAdjustmentAmountResult validateDeleteWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, Long worklogId, String adjustmentAmount) {
        WorklogResult originalWorklogResult = this.validateDelete(jiraServiceContext, worklogId);
        if (originalWorklogResult != null && this.isValidAdjustmentAmount(jiraServiceContext, adjustmentAmount)) {
            return WorklogResultFactory.createAdjustmentAmount((WorklogResult)originalWorklogResult, (Long)this.getDurationForFormattedString(adjustmentAmount, jiraServiceContext));
        }
        return null;
    }

    public boolean deleteWithNewRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateResult worklogNewEstimate, boolean dispatchEvent) {
        return this.delete(jiraServiceContext, (WorklogResult)worklogNewEstimate, worklogNewEstimate.getNewEstimate(), dispatchEvent);
    }

    public boolean deleteWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, WorklogAdjustmentAmountResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return false;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        Long newEstimate = this.increaseEstimate(worklogResult.getWorklog().getIssue(), worklogResult.getAdjustmentAmount());
        return this.delete(jiraServiceContext, (WorklogResult)worklogResult, newEstimate, dispatchEvent);
    }

    public boolean deleteAndRetainRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        return this.delete(jiraServiceContext, worklogResult, null, dispatchEvent);
    }

    public boolean deleteAndAutoAdjustRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return false;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return false;
        }
        Long timeSpent = worklogResult.getWorklog().getTimeSpent();
        Long newEstimate = this.increaseEstimate(worklogResult.getWorklog().getIssue(), timeSpent);
        return this.delete(jiraServiceContext, worklogResult, newEstimate, dispatchEvent);
    }

    public WorklogResult validateUpdate(JiraServiceContext jiraServiceContext, WorklogInputParameters params) {
        Worklog updatedWorklog;
        Assertions.notNull((String)"params", (Object)params);
        Worklog originalWorklog = this.worklogManager.getById(params.getWorklogId());
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        if (this.hasPermissionToUpdate(jiraServiceContext, originalWorklog) && (updatedWorklog = this.validateParamsAndCreateWorklog(jiraServiceContext, originalWorklog.getIssue(), originalWorklog.getAuthorObject(), params.getVisibility(), params.getTimeSpent(), params.getStartDate(), params.getWorklogId(), params.getComment(), originalWorklog.getCreated(), new Date(), user, params.getErrorFieldPrefix())) != null) {
            return WorklogResultFactory.create((Worklog)updatedWorklog);
        }
        return null;
    }

    public WorklogNewEstimateResult validateUpdateWithNewEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateInputParameters params) {
        Assertions.notNull((String)"params", (Object)params);
        WorklogResult worklogResult = this.validateUpdate(jiraServiceContext, (WorklogInputParameters)params);
        if (this.isValidNewEstimate(jiraServiceContext, params.getNewEstimate(), params.getErrorFieldPrefix()) && worklogResult != null) {
            Long estimate = params.getNewEstimate() == null ? null : Long.valueOf(this.getDurationForFormattedString(params.getNewEstimate(), jiraServiceContext));
            return WorklogResultFactory.createNewEstimate((WorklogResult)worklogResult, estimate);
        }
        return null;
    }

    public Worklog updateWithNewRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateResult worklogResult, boolean dispatchEvent) {
        return this.update(jiraServiceContext, (WorklogResult)worklogResult, worklogResult.getNewEstimate(), dispatchEvent);
    }

    public Worklog updateAndRetainRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        return this.update(jiraServiceContext, worklogResult, null, dispatchEvent);
    }

    public Worklog updateAndAutoAdjustRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return null;
        }
        Worklog originalWorklog = this.worklogManager.getById(worklogResult.getWorklog().getId());
        if (originalWorklog == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.worklog.for.id", worklogResult.getWorklog().getId().toString()));
            return null;
        }
        Long originalTimeSpent = originalWorklog.getTimeSpent();
        Long newTimeSpent = worklogResult.getWorklog().getTimeSpent();
        Long newEstimate = this.getAutoAdjustNewEstimateOnUpdate(worklogResult.getWorklog().getIssue(), newTimeSpent, originalTimeSpent);
        return this.update(jiraServiceContext, worklogResult, newEstimate, dispatchEvent);
    }

    protected boolean delete(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, Long newEstimate, boolean dispatchEvent) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return false;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return false;
        }
        if (this.hasPermissionToDelete(jiraServiceContext, worklogResult.getWorklog())) {
            return this.worklogManager.delete(user, worklogResult.getWorklog(), newEstimate, dispatchEvent);
        }
        return false;
    }

    protected Worklog update(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, Long newEstimate, boolean dispatchEvent) {
        Worklog updatedWorklog = null;
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return null;
        }
        if (this.hasPermissionToUpdate(jiraServiceContext, worklogResult.getWorklog())) {
            updatedWorklog = this.worklogManager.update(user, worklogResult.getWorklog(), newEstimate, dispatchEvent);
        }
        return updatedWorklog;
    }

    public WorklogResult validateCreate(JiraServiceContext jiraServiceContext, WorklogInputParameters params) {
        Worklog worklog;
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        if (this.hasPermissionToCreate(jiraServiceContext, params.getIssue(), params.isEditableCheckRequired()) && (worklog = this.validateParamsAndCreateWorklog(jiraServiceContext, params.getIssue(), user, params.getVisibility(), params.getTimeSpent(), params.getStartDate(), null, params.getComment(), null, null, null, params.getErrorFieldPrefix())) != null) {
            return WorklogResultFactory.create((Worklog)worklog, (boolean)params.isEditableCheckRequired());
        }
        return null;
    }

    public WorklogNewEstimateResult validateCreateWithNewEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateInputParameters params) {
        WorklogResult worklogResult = this.validateCreate(jiraServiceContext, (WorklogInputParameters)params);
        if (this.isValidNewEstimate(jiraServiceContext, params.getNewEstimate(), params.getErrorFieldPrefix()) && worklogResult != null) {
            Long estimate = params.getNewEstimate() == null ? null : Long.valueOf(this.getDurationForFormattedString(params.getNewEstimate(), jiraServiceContext));
            return WorklogResultFactory.createNewEstimate((WorklogResult)worklogResult, estimate);
        }
        return null;
    }

    public WorklogAdjustmentAmountResult validateCreateWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, WorklogAdjustmentAmountInputParameters params) {
        WorklogResult worklogResult = this.validateCreate(jiraServiceContext, (WorklogInputParameters)params);
        if (this.isValidAdjustmentAmount(jiraServiceContext, params.getAdjustmentAmount(), params.getErrorFieldPrefix()) && worklogResult != null) {
            return WorklogResultFactory.createAdjustmentAmount((WorklogResult)worklogResult, (Long)this.getDurationForFormattedString(params.getAdjustmentAmount(), jiraServiceContext));
        }
        return null;
    }

    public Worklog createWithNewRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateResult worklogResult, boolean dispatchEvent) {
        return this.create(jiraServiceContext, (WorklogResult)worklogResult, worklogResult.getNewEstimate(), dispatchEvent);
    }

    public Worklog createWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, WorklogAdjustmentAmountResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        Worklog worklog = worklogResult.getWorklog();
        Long newEstimate = this.reduceEstimate(worklog.getIssue(), worklogResult.getAdjustmentAmount());
        return this.create(jiraServiceContext, (WorklogResult)worklogResult, newEstimate, dispatchEvent);
    }

    public Worklog createAndRetainRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        return this.create(jiraServiceContext, worklogResult, null, dispatchEvent);
    }

    public Worklog createAndAutoAdjustRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        Long newEstimate = this.reduceEstimate(worklogResult.getWorklog().getIssue(), worklogResult.getWorklog().getTimeSpent());
        return this.create(jiraServiceContext, worklogResult, newEstimate, dispatchEvent);
    }

    public boolean hasPermissionToCreate(JiraServiceContext jiraServiceContext, Issue issue, boolean isEditableCheckRequired) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (!this.isTimeTrackingEnabled()) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.time.tracking.not.enabed"));
            return false;
        }
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        if (isEditableCheckRequired && !this.isIssueInEditableWorkflowState(issue)) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.not.editable.workflow.state"));
            return false;
        }
        boolean hasPerm = this.permissionManager.hasPermission(ProjectPermissions.WORK_ON_ISSUES, issue, user);
        if (!hasPerm) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.permission", user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.permission.no.user"));
            }
        }
        return hasPerm;
    }

    public boolean hasPermissionToUpdate(JiraServiceContext jiraServiceContext, Worklog worklog) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.isTimeTrackingEnabled()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.time.tracking.not.enabed"));
            return false;
        }
        this.validateUpdateOrDeletePermissionCheckParams(worklog, (ErrorCollection)errorCollection, jiraServiceContext);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.hasEditAllPermission(user, worklog.getIssue()) && !this.hasEditOwnPermission(user, worklog)) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.edit.permission", user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.edit.permission.no.user"));
            }
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        boolean isValidVisibility = this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)errorCollection), WORKLOG_I18N_PREFIX, worklog.getIssue(), Visibilities.fromGroupAndRoleId((String)worklog.getGroupLevel(), (Long)worklog.getRoleLevelId()));
        if (!isValidVisibility) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public boolean hasPermissionToDelete(JiraServiceContext jiraServiceContext, Worklog worklog) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.isTimeTrackingEnabled()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.time.tracking.not.enabed"));
            return false;
        }
        this.validateUpdateOrDeletePermissionCheckParams(worklog, (ErrorCollection)errorCollection, jiraServiceContext);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.hasDeleteAllPermission(user, worklog.getIssue()) && !this.hasDeleteOwnPermission(user, worklog)) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.delete.permission", user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.delete.permission.no.user"));
            }
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        boolean isValidVisibility = this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)errorCollection), WORKLOG_I18N_PREFIX, worklog.getIssue(), Visibilities.fromGroupAndRoleId((String)worklog.getGroupLevel(), (Long)worklog.getRoleLevelId()));
        if (!isValidVisibility) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public Worklog getById(JiraServiceContext jiraServiceContext, Long id) {
        if (!this.isTimeTrackingEnabled()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(jiraServiceContext.getI18nBean().getText("worklog.service.error.time.tracking.not.enabed"));
            return null;
        }
        Worklog worklog = this.worklogManager.getById(id);
        if (worklog != null) {
            if (this.hasPermissionToView(jiraServiceContext.getLoggedInApplicationUser(), worklog)) {
                return worklog;
            }
            jiraServiceContext.getErrorCollection().addErrorMessage(jiraServiceContext.getI18nBean().getText("worklog.service.error.no.view.permission"));
            return null;
        }
        jiraServiceContext.getErrorCollection().addErrorMessage(jiraServiceContext.getI18nBean().getText("worklog.service.error.no.worklog.for.id", (Object)id));
        return null;
    }

    public List getByIssue(JiraServiceContext jiraServiceContext, Issue issue) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.null.issue"));
            return Collections.emptyList();
        }
        return this.worklogManager.getByIssue(issue);
    }

    public List<Worklog> getByIssueVisibleToUser(JiraServiceContext jiraServiceContext, Issue issue) {
        List allWorklogs = this.getByIssue(jiraServiceContext, issue);
        ArrayList<Worklog> visibleWorklogs = new ArrayList<Worklog>(allWorklogs.size());
        for (Object allWorklog : allWorklogs) {
            Worklog worklog = (Worklog)allWorklog;
            if (!this.hasPermissionToView(jiraServiceContext.getLoggedInApplicationUser(), worklog)) continue;
            visibleWorklogs.add(worklog);
        }
        return visibleWorklogs;
    }

    public Window<Worklog> getByIssueVisibleToUser(CommentSearchParameters parameters) {
        List<Worklog> allUserWorklogs = this.getByIssueVisibleToUser((JiraServiceContext)new JiraServiceContextImpl(parameters.getUser(), (ErrorCollection)new SimpleErrorCollection()), parameters.getIssue()).stream().sorted(Comparator.comparing(Worklog::getStartDate)).collect(Collectors.toList());
        Optional focusedWorklog = Optional.ofNullable(parameters.getCommentId()).flatMap(id -> DefaultWorklogService.searchWorklogInCollection(allUserWorklogs, id));
        Window<Worklog> filteredWorklogs = Window.empty();
        if (allUserWorklogs.isEmpty()) {
            return Window.empty();
        }
        if (parameters.getDate() != null) {
            if (parameters.getSearchDirection() == CommentSearchParameters.SearchDirection.OLDER) {
                return DefaultWorklogService.maybeLimitBefore(parameters.getLimit(), DefaultWorklogService.olderWorklogs(allUserWorklogs, parameters.getDate()));
            }
            return DefaultWorklogService.maybeLimitAfter(parameters.getLimit(), DefaultWorklogService.newerWorklogs(allUserWorklogs, parameters.getDate()));
        }
        if (focusedWorklog.isPresent()) {
            Integer limitPlusOne;
            Integer n = limitPlusOne = parameters.getLimit() != null ? Integer.valueOf(parameters.getLimit() + 1) : null;
            if (parameters.getSearchDirection() == CommentSearchParameters.SearchDirection.NEWER) {
                filteredWorklogs = DefaultWorklogService.maybeLimitAfter(limitPlusOne, DefaultWorklogService.newerWorklogs(allUserWorklogs, (Worklog)focusedWorklog.get()));
            } else if (parameters.getSearchDirection() == CommentSearchParameters.SearchDirection.OLDER) {
                filteredWorklogs = DefaultWorklogService.maybeLimitBefore(limitPlusOne, DefaultWorklogService.olderWorklogs(allUserWorklogs, (Worklog)focusedWorklog.get()));
            } else if (parameters.getSearchDirection() == CommentSearchParameters.SearchDirection.BOTH) {
                filteredWorklogs = DefaultWorklogService.maybeFocus(parameters.getLimit(), (Window<Worklog>)Window.of(allUserWorklogs), (Worklog)focusedWorklog.get());
            }
        } else {
            filteredWorklogs = parameters.getSearchDirection() == CommentSearchParameters.SearchDirection.OLDER ? DefaultWorklogService.maybeLimitAfter(parameters.getLimit(), (Window<Worklog>)Window.of(allUserWorklogs)) : DefaultWorklogService.maybeLimitBefore(parameters.getLimit(), (Window<Worklog>)Window.of(allUserWorklogs));
        }
        return filteredWorklogs;
    }

    private static Window<Worklog> newerWorklogs(Collection<Worklog> worklogs, Date date) {
        return Window.of(worklogs).dropUntil(c -> c.getStartDate() != null && c.getStartDate().after(date));
    }

    private static Window<Worklog> newerWorklogs(Collection<Worklog> worklogs, Worklog worklogToSearch) {
        return Window.of(worklogs).dropUntilElement((Object)worklogToSearch);
    }

    private static Window<Worklog> olderWorklogs(Collection<Worklog> worklogs, Date date) {
        return Window.of(worklogs).keepUntil(c -> c.getStartDate() != null && c.getStartDate().before(date));
    }

    private static Window<Worklog> olderWorklogs(Collection<Worklog> worklogs, Worklog worklogToSearch) {
        return Window.of(worklogs).keepUntilElement((Object)worklogToSearch);
    }

    private static Window<Worklog> maybeLimitAfter(Integer limit, Window<Worklog> worklogs) {
        if (limit == null) {
            return worklogs;
        }
        return worklogs.shrinkFromEnd(DefaultWorklogService.extendLimitForDuplicatedDates(limit, worklogs));
    }

    private static Window<Worklog> maybeLimitBefore(Integer limit, Window<Worklog> worklogs) {
        if (limit == null) {
            return worklogs;
        }
        return worklogs.shrinkFromStart(DefaultWorklogService.extendLimitForDuplicatedDates(limit, worklogs));
    }

    private static Window<Worklog> maybeFocus(Integer limit, Window<Worklog> worklogs, Worklog focused) {
        if (limit == null) {
            return worklogs;
        }
        return worklogs.focusElement((Object)focused, limit.intValue());
    }

    private static int extendLimitForDuplicatedDates(int originalLimit, Window<Worklog> worklogs) {
        int newLimit = 0;
        Date last = null;
        for (Worklog worklog : worklogs) {
            if (worklog.getStartDate().equals(last)) {
                ++newLimit;
                last = worklog.getStartDate();
                continue;
            }
            if (newLimit >= originalLimit) continue;
            ++newLimit;
            last = worklog.getStartDate();
        }
        return newLimit;
    }

    public PagedList<Worklog> getByIssueVisibleToUser(JiraServiceContext jiraServiceContext, Issue issue, int pageSize) {
        PagedList worklogs = this.worklogManager.getByIssue(issue, pageSize);
        return new PredicatedPagedList<Worklog>(worklogs, worklog -> this.hasPermissionToView(jiraServiceContext.getLoggedInApplicationUser(), (Worklog)worklog));
    }

    private boolean hasPermissionToView(ApplicationUser user, Worklog worklog) {
        String groupLevel = worklog.getGroupLevel();
        Long roleLevel = worklog.getRoleLevelId();
        boolean roleProvided = roleLevel != null;
        boolean groupProvided = StringUtils.isNotBlank((CharSequence)groupLevel);
        boolean userInRole = roleProvided && this.isUserInRole(roleLevel, user, worklog.getIssue());
        boolean userInGroup = groupProvided && this.isUserInGroup(user, groupLevel);
        boolean noLevelsProvided = !groupProvided && !roleProvided;
        boolean canView = this.hasViewPermission(user, worklog.getIssue());
        return canView && (noLevelsProvided || userInRole || userInGroup);
    }

    public boolean isTimeTrackingEnabled() {
        return this.timeTrackingConfiguration.enabled();
    }

    public boolean isIssueInEditableWorkflowState(Issue issue) {
        return this.issueManager.isEditable(issue);
    }

    public WorklogChangedSincePage<Worklog> getWorklogsUpdatedSince(ApplicationUser user, Long sinceInMilliseconds) {
        TreeSet<Worklog> result = new TreeSet<Worklog>(new Comparator<Worklog>(){

            @Override
            public int compare(Worklog o1, Worklog o2) {
                int updateDifference = Long.valueOf(o1.getUpdated().getTime()).compareTo(o2.getUpdated().getTime());
                return updateDifference == 0 ? Long.signum(o1.getId() - o2.getId()) : updateDifference;
            }
        });
        long pageStart = sinceInMilliseconds;
        do {
            List worklogsUpdatedSince = this.worklogManager.getWorklogsUpdatedSince(Long.valueOf(pageStart));
            List<Worklog> nextDbPage = this.filter(user, worklogsUpdatedSince);
            boolean allWorklogsFromDbAdded = true;
            Iterator<Worklog> dbPageIterator = nextDbPage.iterator();
            while (dbPageIterator.hasNext() && allWorklogsFromDbAdded) {
                if (result.size() < 1000) {
                    result.add(dbPageIterator.next());
                    continue;
                }
                allWorklogsFromDbAdded = false;
            }
            if (worklogsUpdatedSince.size() < 1000) {
                if (allWorklogsFromDbAdded) {
                    return this.createChangePage(sinceInMilliseconds, result, true);
                }
                return this.createChangePage(sinceInMilliseconds, result, false);
            }
            pageStart = ((Worklog)Iterables.getLast((Iterable)worklogsUpdatedSince)).getUpdated().getTime();
        } while (result.size() < 1000);
        return this.createChangePage(sinceInMilliseconds, result, false);
    }

    private List<Worklog> filter(ApplicationUser user, List<Worklog> worklogs) {
        return worklogs.stream().filter(w -> this.hasPermissionToView(user, (Worklog)w)).collect(Collectors.toList());
    }

    private WorklogChangedSincePage<Worklog> createChangePage(Long since, SortedSet<Worklog> result, boolean last) {
        Worklog lastWorklog = (Worklog)Iterables.getLast(result, null);
        long until = lastWorklog != null ? lastWorklog.getUpdated().getTime() : since.longValue();
        return new WorklogChangedSincePage(since, Long.valueOf(until), new ArrayList<Worklog>(result), last);
    }

    public WorklogChangedSincePage<DeletedWorklog> getWorklogsDeletedSince(ApplicationUser user, Long sinceInMilliseconds) {
        if (user == null) {
            return new WorklogChangedSincePage(sinceInMilliseconds, sinceInMilliseconds, Collections.emptyList(), true);
        }
        List worklogs = this.worklogManager.getWorklogsDeletedSince(sinceInMilliseconds);
        DeletedWorklog lastDeletedWorklog = (DeletedWorklog)Iterables.getLast((Iterable)worklogs, null);
        long until = lastDeletedWorklog != null ? lastDeletedWorklog.getDeletionTime().getTime() : sinceInMilliseconds.longValue();
        boolean isLastPage = worklogs.size() < 1000;
        return new WorklogChangedSincePage(sinceInMilliseconds, Long.valueOf(until), worklogs, isLastPage);
    }

    public ServiceOutcome<Set<Worklog>> getWorklogsForIds(JiraServiceContext jiraServiceContext, Set<Long> idsOfWorklogs) {
        if (idsOfWorklogs.size() > 1000) {
            return new ServiceOutcomeImpl<Set<Worklog>>(ErrorCollections.create((String)jiraServiceContext.getI18nBean().getText("worklog.service.error.too.many.ids", (Object)1000), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        Set filteredWorklogs = this.worklogManager.getWorklogsForIds(idsOfWorklogs).stream().filter(w -> this.hasPermissionToView(jiraServiceContext.getLoggedInApplicationUser(), (Worklog)w)).collect(Collectors.toSet());
        return new ServiceOutcomeImpl<Set<Worklog>>(ErrorCollections.empty(), filteredWorklogs);
    }

    void validateUpdateOrDeletePermissionCheckParams(Worklog worklog, ErrorCollection errorCollection, JiraServiceContext jiraServiceContext) {
        if (worklog == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return;
        }
        Issue issue = worklog.getIssue();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return;
        }
        if (!this.isIssueInEditableWorkflowState(issue)) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.not.editable.workflow.state"));
            return;
        }
        if (worklog.getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
        }
    }

    boolean hasEditIssuePermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, issue, user);
    }

    protected Worklog validateParamsAndCreateWorklog(JiraServiceContext jiraServiceContext, Issue issue, ApplicationUser author, Visibility visibility, String timeSpent, Date startDate, Long worklogId, String comment, Date created, Date updated, ApplicationUser updateAuthor, String errorFieldPrefix) {
        boolean defaultInputFieldsValidated;
        WorklogImpl2 worklog = null;
        if (this.visibilityValidator.isValidVisibilityData(jiraServiceContext, WORKLOG_I18N_PREFIX, issue, visibility) && (defaultInputFieldsValidated = this.isValidWorklogInputFields(jiraServiceContext, issue, timeSpent, startDate, errorFieldPrefix))) {
            String groupLevel = (String)((Option)visibility.accept(VisibilityVisitors.returningGroupLevelVisitor())).getOrNull();
            Long roleLevelId = (Long)((Option)visibility.accept(VisibilityVisitors.returningRoleLevelIdVisitor())).getOrNull();
            worklog = new WorklogImpl2(issue, worklogId, ApplicationUsers.getKeyFor(author), comment, startDate, groupLevel, roleLevelId, this.getDurationForFormattedString(timeSpent, jiraServiceContext), updateAuthor != null ? updateAuthor.getKey() : null, created, updated, roleLevelId != null ? this.projectRoleManager.getProjectRole(roleLevelId) : null);
        }
        return worklog;
    }

    protected Worklog create(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, Long newEstimate, boolean dispatchEvent) {
        Worklog newWorklog = null;
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        if (this.hasPermissionToCreate(jiraServiceContext, worklogResult.getWorklog().getIssue(), worklogResult.isEditableCheckRequired())) {
            newWorklog = this.worklogManager.create(user, worklogResult.getWorklog(), newEstimate, dispatchEvent);
        }
        return newWorklog;
    }

    protected boolean hasEditOwnPermission(ApplicationUser user, Worklog worklog) {
        return this.isSameAuthor(user, worklog) && this.permissionManager.hasPermission(ProjectPermissions.EDIT_OWN_WORKLOGS, worklog.getIssue(), user);
    }

    protected boolean hasViewPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user);
    }

    protected boolean hasEditAllPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(ProjectPermissions.EDIT_ALL_WORKLOGS, issue, user);
    }

    protected boolean hasDeleteOwnPermission(ApplicationUser user, Worklog worklog) {
        return this.isSameAuthor(user, worklog) && this.permissionManager.hasPermission(ProjectPermissions.DELETE_OWN_WORKLOGS, worklog.getIssue(), user);
    }

    protected boolean hasDeleteAllPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(ProjectPermissions.DELETE_ALL_WORKLOGS, issue, user);
    }

    protected boolean isSameAuthor(ApplicationUser user, Worklog worklog) {
        if (user != null && worklog.getAuthorObject() != null) {
            return user.equals((Object)worklog.getAuthorObject());
        }
        return user == null && worklog != null && worklog.getAuthorObject() == null;
    }

    protected Long getAutoAdjustNewEstimateOnUpdate(Issue issue, Long newTimeSpent, Long originalTimeSpent) {
        Long timeEstimate = issue.getEstimate();
        long oldTimeEstimate = timeEstimate == null ? 0L : timeEstimate;
        long newTimeEstimate = oldTimeEstimate + originalTimeSpent - newTimeSpent;
        return newTimeEstimate < 0L ? 0L : newTimeEstimate;
    }

    protected Long reduceEstimate(Issue issue, Long amount) {
        Long timeEstimate = issue.getEstimate();
        long oldTimeEstimate = timeEstimate == null ? 0L : timeEstimate;
        long newTimeEstimate = oldTimeEstimate - amount;
        return newTimeEstimate < 0L ? 0L : newTimeEstimate;
    }

    protected Long increaseEstimate(Issue issue, Long amount) {
        Long timeEstimate = issue.getEstimate();
        long oldTimeEstimate = timeEstimate == null ? 0L : timeEstimate;
        long newTimeEstimate = oldTimeEstimate + amount;
        return newTimeEstimate < 0L ? 0L : newTimeEstimate;
    }

    protected boolean isValidNewEstimate(JiraServiceContext jiraServiceContext, String newEstimate) {
        return this.isValidNewEstimate(jiraServiceContext, newEstimate, null);
    }

    protected boolean isValidNewEstimate(JiraServiceContext jiraServiceContext, String newEstimate, String errorFieldPrefix) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        Object errorField = "newEstimate";
        if (StringUtils.isNotBlank((CharSequence)errorFieldPrefix)) {
            errorField = errorFieldPrefix + (String)errorField;
        }
        if (TextUtils.stringSet((String)newEstimate)) {
            if (!this.isValidDuration(newEstimate, jiraServiceContext)) {
                errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.newestimate"));
                return false;
            }
        } else {
            errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.new.estimate.not.specified"));
            return false;
        }
        return true;
    }

    protected boolean isValidAdjustmentAmount(JiraServiceContext jiraServiceContext, String adjustmentAmount) {
        return this.isValidAdjustmentAmount(jiraServiceContext, adjustmentAmount, null);
    }

    protected boolean isValidAdjustmentAmount(JiraServiceContext jiraServiceContext, String adjustmentAmount, String errorFieldPrefix) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        Object errorField = "adjustmentAmount";
        if (StringUtils.isNotBlank((CharSequence)errorFieldPrefix)) {
            errorField = errorFieldPrefix + (String)errorField;
        }
        if (!TextUtils.stringSet((String)adjustmentAmount)) {
            errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.adjustment.amount.not.specified"));
            return false;
        }
        if (!this.isValidDuration(adjustmentAmount, jiraServiceContext)) {
            errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.adjustment.amount.invalid"));
            return false;
        }
        return true;
    }

    protected boolean isValidWorklogInputFields(JiraServiceContext jiraServiceContext, Issue issue, String timeSpent, Date startDate, String errorFieldPrefix) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Object errorField = "timeLogged";
        if (StringUtils.isNotBlank((CharSequence)errorFieldPrefix)) {
            errorField = errorFieldPrefix + (String)errorField;
        }
        if (!TextUtils.stringSet((String)timeSpent)) {
            errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.timespent.required"));
        } else if (!this.isValidDuration(timeSpent, jiraServiceContext)) {
            errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.invalid.time.duration"));
        } else if (this.getDurationForFormattedString(timeSpent, jiraServiceContext) == 0L) {
            errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.timespent.zero"));
        }
        errorField = "startDate";
        if (StringUtils.isNotBlank((CharSequence)errorFieldPrefix)) {
            errorField = errorFieldPrefix + (String)errorField;
        }
        if (startDate == null) {
            errorCollection.addError((String)errorField, this.getText(jiraServiceContext, "worklog.service.error.invalid.worklog.date"));
        }
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
        }
        return !errorCollection.hasAnyErrors();
    }

    boolean isValidDuration(String duration, JiraServiceContext jiraServiceContext) {
        if (StringUtils.isNotBlank((CharSequence)duration)) {
            try {
                this.jiraDurationUtils.parseDuration(duration, jiraServiceContext.getI18nBean().getLocale());
            }
            catch (InvalidDurationException e) {
                return false;
            }
        }
        return true;
    }

    protected long getDurationForFormattedString(String timeSpent, JiraServiceContext jiraServiceContext) {
        try {
            return this.jiraDurationUtils.parseDuration(timeSpent, jiraServiceContext.getI18nBean().getLocale());
        }
        catch (InvalidDurationException e) {
            log.error("Trying to create/update a worklog with an invalid duration, this should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean isUserInGroup(ApplicationUser user, String groupLevel) {
        return this.groupManager.isUserInGroup(user, groupLevel);
    }

    protected boolean isUserInRole(Long roleLevel, ApplicationUser user, Issue issue) {
        boolean isUserInRole = false;
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleLevel);
        if (projectRole != null) {
            isUserInRole = this.projectRoleManager.isUserInProjectRole(user, projectRole, issue.getProjectObject());
        }
        return isUserInRole;
    }

    private static Optional<Worklog> searchWorklogInCollection(Collection<Worklog> comments, long id) {
        return comments.stream().filter(c -> c.getId() != null).filter(c -> c.getId().equals(id)).findFirst();
    }

    private String getText(JiraServiceContext jiraServiceContext, String key) {
        return jiraServiceContext.getI18nBean().getText(key);
    }

    private String getText(JiraServiceContext jiraServiceContext, String key, String param) {
        return jiraServiceContext.getI18nBean().getText(key, param);
    }
}

