/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.bc.project.component.ProjectComponentMergedEvent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectComponentService
implements ProjectComponentService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectComponentService.class);
    public static final String KEY_USER_NO_PERMISSION = "admin.projects.component.usernopermission";
    public static final String KEY_USER_NO_PERMISSION_WITH_USER = "admin.projects.component.usernopermission.withuser";
    public static final String KEY_NO_SUCH_COMPONENT = "admin.projects.component.nosuchcomponent";
    public static final String KEY_NO_SUCH_COMPONENT_WITH_ID = "admin.projects.component.nosuchcomponent.withid";
    public static final String KEY_NO_SUCH_COMPONENT_TO_SWAP_WITH_ID = "admin.projects.component.nosuchcomponent.toswap.withid";
    public static final String KEY_ID_NULL = "admin.projects.component.nullId";
    public static final String KEY_PROJECT_ID_NULL = "admin.projects.component.nullprojectid";
    public static final String KEY_PROJECT_ID_NOT_FOUND = "admin.projects.component.nosuchprojectid";
    public static final String KEY_NAME_NOT_SET = "admin.projects.component.namenotset";
    public static final String KEY_NAME_NOT_UNIQUE = "admin.projects.component.namenotunique";
    public static final String KEY_USER_DOES_NOT_EXIST = "admin.projects.component.userdoesnotexist";
    public static final String KEY_ASSIGNEE_TYPE_INVALID = "admin.projects.component.assignee.type.invalid";
    public static final String FIELD_PROJECT_ID = "projectId";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_COMPONENT_LEAD = "componentLead";
    public static final String FIELD_ASSIGNEE_TYPE = "assigneeType";
    private final ProjectComponentManager projectComponentManager;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final UserManager userManager;
    private final EventPublisher eventPublisher;
    private final InternalProjectPermissionHelper projectPermissionHelper;

    public DefaultProjectComponentService(JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, ProjectComponentManager projectComponentManager, ProjectManager projectManager, IssueManager issueManager, UserManager userManager, EventPublisher eventPublisher, InternalProjectPermissionHelper projectPermissionHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.projectComponentManager = projectComponentManager;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
        this.projectPermissionHelper = projectPermissionHelper;
    }

    public ProjectComponent create(final ApplicationUser user, ErrorCollection errorCollection, final String name, final String description, final String lead, final Long projectId) {
        return (ProjectComponent)new Handler<ProjectComponent>(errorCollection, this){

            @Override
            void checkPermissions() {
                DefaultProjectComponentService.this.checkProjectAdminPermission((Handler)this, projectId, user);
            }

            @Override
            void validateData() {
                DefaultProjectComponentService.this.validateProjectId(this, projectId);
                DefaultProjectComponentService.this.validateName(this, null, name, projectId);
                DefaultProjectComponentService.this.validateLead(this, lead);
            }

            @Override
            void executeOnSuccess() {
                try {
                    this.result = DefaultProjectComponentService.this.projectComponentManager.create(name, description, lead, 0L, projectId);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Failed to create project component", (Throwable)e);
                }
            }
        }.run();
    }

    public ProjectComponent create(final ApplicationUser user, ErrorCollection errorCollection, final String name, final String description, final String lead, final Long projectId, final Long assigneeType) {
        return (ProjectComponent)new Handler<ProjectComponent>(errorCollection, this){

            @Override
            void checkPermissions() {
                DefaultProjectComponentService.this.checkProjectAdminPermission((Handler)this, projectId, user);
            }

            @Override
            void validateData() {
                DefaultProjectComponentService.this.validateProjectId(this, projectId);
                DefaultProjectComponentService.this.validateName(this, null, name, projectId);
                DefaultProjectComponentService.this.validateLead(this, lead);
                DefaultProjectComponentService.this.validateAssigneeType(this, assigneeType);
            }

            @Override
            void executeOnSuccess() {
                try {
                    Long assigneeTypeParam = assigneeType == null ? 0L : assigneeType;
                    this.result = DefaultProjectComponentService.this.projectComponentManager.create(name, description, lead, assigneeTypeParam.longValue(), projectId);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Failed to create project component", (Throwable)e);
                }
            }
        }.run();
    }

    public ProjectComponent find(final ApplicationUser user, ErrorCollection errorCollection, final Long id) {
        return (ProjectComponent)new Handler<ProjectComponent>(errorCollection, this){

            @Override
            void checkPermissions() {
                Long projectId;
                if (id == null) {
                    this.addErrorKey(DefaultProjectComponentService.KEY_ID_NULL, null, ErrorCollection.Reason.FORBIDDEN);
                    return;
                }
                try {
                    projectId = DefaultProjectComponentService.this.projectComponentManager.findProjectIdForComponent(id);
                }
                catch (EntityNotFoundException e) {
                    this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT_WITH_ID, id.toString(), ErrorCollection.Reason.FORBIDDEN);
                    return;
                }
                DefaultProjectComponentService.this.checkCanAccessComponentPermission(this, projectId, user);
            }

            @Override
            void validateData() {
                if (id == null) {
                    this.addErrorKey(DefaultProjectComponentService.KEY_ID_NULL, null, ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }

            @Override
            void executeOnSuccess() {
                try {
                    this.result = DefaultProjectComponentService.this.projectComponentManager.find(id);
                }
                catch (EntityNotFoundException e) {
                    if (id != null) {
                        this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT_WITH_ID, id.toString(), ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                    this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT, null, ErrorCollection.Reason.SERVER_ERROR);
                }
            }
        }.run();
    }

    public Collection<ProjectComponent> findAllForProject(ErrorCollection errorCollection, final Long projectId) {
        return (Collection)new Handler<Collection<ProjectComponent>>(errorCollection, this){

            @Override
            void validateData() {
                DefaultProjectComponentService.this.validateProjectId(this, projectId);
            }

            @Override
            void executeOnSuccess() {
                this.result = DefaultProjectComponentService.this.projectComponentManager.findAllForProject(projectId);
            }
        }.run();
    }

    public ProjectComponent update(final ApplicationUser user, final ErrorCollection errorCollection, final MutableProjectComponent component) {
        return (ProjectComponent)new Handler<ProjectComponent>(errorCollection, this){

            @Override
            void checkPermissions() {
                DefaultProjectComponentService.this.checkProjectAdminPermission((Handler)this, (ProjectComponent)component, user);
            }

            @Override
            void validateData() {
                DefaultProjectComponentService.this.validateLead(this, component.getLead());
                Long id = component.getId();
                try {
                    ProjectComponent oldComponent = DefaultProjectComponentService.this.projectComponentManager.find(id);
                    String oldName = oldComponent.getName();
                    if (!oldName.equalsIgnoreCase(component.getName())) {
                        DefaultProjectComponentService.this.validateName(this, oldName, component.getName(), oldComponent.getProjectId());
                    }
                }
                catch (EntityNotFoundException e) {
                    if (id != null) {
                        this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT_WITH_ID, id.toString(), ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                    this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT, null, ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }

            @Override
            void executeOnSuccess() {
                this.result = DefaultProjectComponentService.this.update(component, errorCollection);
            }
        }.run();
    }

    private ProjectComponent update(MutableProjectComponent component, ErrorCollection errorCollection) {
        try {
            return this.projectComponentManager.update(component);
        }
        catch (EntityNotFoundException e) {
            if (component.getId() != null) {
                errorCollection.addErrorMessage(this.translateKeyToMessage(KEY_NO_SUCH_COMPONENT_WITH_ID, component.getId().toString()), ErrorCollection.Reason.SERVER_ERROR);
            } else {
                errorCollection.addErrorMessage(this.translateKeyToMessage(KEY_NO_SUCH_COMPONENT, null), ErrorCollection.Reason.SERVER_ERROR);
            }
            return null;
        }
    }

    private void delete(final JiraServiceContext context, final Long componentId) {
        new Handler<Void>(context.getErrorCollection(), this){

            @Override
            void checkPermissions() {
                try {
                    ProjectComponent component = DefaultProjectComponentService.this.projectComponentManager.find(componentId);
                    DefaultProjectComponentService.this.checkProjectAdminPermission((Handler)this, component.getProjectId(), context.getLoggedInApplicationUser());
                }
                catch (EntityNotFoundException e) {
                    if (componentId != null) {
                        this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT_WITH_ID, componentId.toString(), ErrorCollection.Reason.FORBIDDEN);
                    }
                    this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT, null, ErrorCollection.Reason.FORBIDDEN);
                }
            }

            @Override
            void executeOnSuccess() {
                try {
                    DefaultProjectComponentService.this.projectComponentManager.delete(componentId);
                }
                catch (EntityNotFoundException e) {
                    if (componentId != null) {
                        this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT_WITH_ID, componentId.toString(), ErrorCollection.Reason.SERVER_ERROR);
                    }
                    this.addErrorKey(DefaultProjectComponentService.KEY_NO_SUCH_COMPONENT, null, ErrorCollection.Reason.SERVER_ERROR);
                }
            }
        }.run();
    }

    public void deleteComponentForIssues(JiraServiceContext context, Long componentId) {
        ErrorCollection errorCollection = context.getErrorCollection();
        ApplicationUser user = context.getLoggedInApplicationUser();
        ProjectComponent component = this.validateAndGetComponent(componentId, KEY_NO_SUCH_COMPONENT, KEY_NO_SUCH_COMPONENT_WITH_ID, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.checkProjectAdminPermission(errorCollection, component, user);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.flagComponentAsDeleted(errorCollection, component);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.removeComponentForAffectedIssues(context, component);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.delete(context, componentId);
    }

    public void deleteAndSwapComponentForIssues(JiraServiceContext context, Long componentId, Long swapComponentId) {
        ErrorCollection errorCollection = context.getErrorCollection();
        ApplicationUser user = context.getLoggedInApplicationUser();
        ProjectComponent swapComponent = this.validateAndGetComponent(swapComponentId, KEY_NO_SUCH_COMPONENT_TO_SWAP_WITH_ID, KEY_NO_SUCH_COMPONENT_TO_SWAP_WITH_ID, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        ProjectComponent component = this.validateAndGetComponent(componentId, KEY_NO_SUCH_COMPONENT, KEY_NO_SUCH_COMPONENT_WITH_ID, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.checkProjectAdminPermission(errorCollection, component, user);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.flagComponentAsDeleted(errorCollection, component);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.swapComponentForAffectedIssues(context, component, swapComponent);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.delete(context, componentId);
    }

    public Stream<ProjectComponent> findComponents(@Nullable ApplicationUser user, @Nonnull String substring, @Nonnull List<Long> projectIds) {
        Stream<ProjectComponent> projectComponents = this.getProjectsVisibleForUser(user, projectIds).flatMap(project -> this.projectComponentManager.findAllActiveForProject(project.getId()).stream()).distinct();
        if (StringUtils.isEmpty((CharSequence)substring)) {
            return projectComponents;
        }
        Pattern searchPattern = ConstantsManager.createIssueConstantNameSearchPattern((String)substring);
        return projectComponents.filter(component -> searchPattern.matcher(component.getName()).matches());
    }

    private Stream<Project> getProjectsVisibleForUser(ApplicationUser user, List<Long> projectIds) {
        Stream<Project> projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user).stream();
        if (projectIds.isEmpty()) {
            return projects;
        }
        return projects.filter(project -> projectIds.contains(project.getId()));
    }

    private void flagComponentAsDeleted(ErrorCollection errorCollection, ProjectComponent component) {
        MutableProjectComponent mutableComponent = MutableProjectComponent.copy((ProjectComponent)component);
        mutableComponent.setDeleted(true);
        this.update(mutableComponent, errorCollection);
    }

    private void removeComponentForAffectedIssues(JiraServiceContext context, ProjectComponent component) {
        this.swapComponentForAffectedIssues(context, component, null);
    }

    private void swapComponentForAffectedIssues(JiraServiceContext context, ProjectComponent component, ProjectComponent swapComponent) {
        Collection affectedIssues = this.projectComponentManager.getIssueIdsWithComponent(component);
        for (Long issueId : affectedIssues) {
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            Collection<ProjectComponent> newComponents = this.getNewComponents((Issue)issue, component, swapComponent);
            issue.setComponent(newComponents);
            this.issueManager.updateIssue(context.getLoggedInApplicationUser(), issue, EventDispatchOption.ISSUE_UPDATED, false);
        }
        if (!affectedIssues.isEmpty() && swapComponent != null) {
            this.eventPublisher.publish((Object)new ProjectComponentMergedEvent(swapComponent, component));
        }
    }

    private ProjectComponent validateAndGetComponent(Long componentId, String errorMsgNoId, String errorMsgNoCompWithId, ErrorCollection errorCollection) {
        if (componentId == null) {
            errorCollection.addErrorMessage(this.translateKeyToMessage(errorMsgNoId, null), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        try {
            return this.projectComponentManager.find(componentId);
        }
        catch (EntityNotFoundException e) {
            errorCollection.addErrorMessage(this.translateKeyToMessage(errorMsgNoCompWithId, componentId.toString()), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
    }

    private Collection<ProjectComponent> getNewComponents(Issue issue, ProjectComponent oldComponent, ProjectComponent swapComponent) {
        Collection newComponents = issue.getComponents();
        newComponents.removeIf(component -> component.getId().equals(oldComponent.getId()));
        if (swapComponent != null) {
            newComponents.add(swapComponent);
        }
        return newComponents;
    }

    private void checkProjectAdminPermission(Handler handler, Long projectId, ApplicationUser user) {
        boolean hasProjectAdminPermission;
        boolean bl = hasProjectAdminPermission = this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, this.projectManager.getProjectObj(projectId), user);
        if (!hasProjectAdminPermission) {
            if (user != null) {
                handler.addErrorKey(KEY_USER_NO_PERMISSION_WITH_USER, user.getName(), ErrorCollection.Reason.FORBIDDEN);
            } else {
                handler.addErrorKey(KEY_USER_NO_PERMISSION, null, ErrorCollection.Reason.NOT_LOGGED_IN);
            }
        }
    }

    private void checkProjectAdminPermission(Handler handler, ProjectComponent component, ApplicationUser user) {
        if (component == null) {
            handler.addErrorKey(KEY_NO_SUCH_COMPONENT, null, ErrorCollection.Reason.FORBIDDEN);
        } else {
            Long projectId = component.getProjectId();
            this.checkProjectAdminPermission(handler, projectId, user);
        }
    }

    private void checkProjectAdminPermission(ErrorCollection errorCollection, ProjectComponent component, ApplicationUser user) {
        if (component == null) {
            errorCollection.addErrorMessage(this.translateKeyToMessage(KEY_NO_SUCH_COMPONENT, null), ErrorCollection.Reason.FORBIDDEN);
        } else {
            Long projectId = component.getProjectId();
            this.checkProjectAdminPermission(errorCollection, projectId, user);
        }
    }

    private void checkProjectAdminPermission(ErrorCollection errorCollection, Long projectId, ApplicationUser user) {
        boolean hasProjectAdminPermission;
        boolean bl = hasProjectAdminPermission = this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, this.projectManager.getProjectObj(projectId), user);
        if (!hasProjectAdminPermission) {
            if (user != null) {
                errorCollection.addErrorMessage(this.translateKeyToMessage(KEY_USER_NO_PERMISSION_WITH_USER, user.getName()), ErrorCollection.Reason.FORBIDDEN);
            } else {
                errorCollection.addErrorMessage(this.translateKeyToMessage(KEY_USER_NO_PERMISSION, null), ErrorCollection.Reason.FORBIDDEN);
            }
        }
    }

    private void checkCanAccessComponentPermission(Handler handler, Long projectId, ApplicationUser applicationUser) {
        boolean hasPermission;
        Project project = this.projectManager.getProjectObj(projectId);
        boolean bl = hasPermission = this.projectPermissionHelper.canUserBrowseProject(project, applicationUser) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, applicationUser) || this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, applicationUser) || this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, project, applicationUser) || this.permissionManager.hasPermission(0, applicationUser);
        if (!hasPermission) {
            handler.addErrorKey(KEY_NO_SUCH_COMPONENT_WITH_ID, String.valueOf(projectId), ErrorCollection.Reason.NOT_FOUND);
        }
    }

    protected void validateProjectId(Handler handler, Long projectId) {
        if (projectId == null) {
            handler.addErrorKey(KEY_PROJECT_ID_NULL, null, ErrorCollection.Reason.VALIDATION_FAILED);
        } else {
            try {
                if (this.projectManager.getProjectObj(projectId) == null) {
                    handler.addErrorKey(KEY_PROJECT_ID_NOT_FOUND, projectId.toString(), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
            catch (DataAccessException e) {
                LOG.error("Error encountered while attempting to find project with the ID '" + projectId + "'.", (Throwable)e);
                handler.addErrorKey(KEY_PROJECT_ID_NOT_FOUND, projectId.toString(), ErrorCollection.Reason.SERVER_ERROR);
            }
        }
    }

    protected void validateName(Handler handler, String oldName, String newName, Long projectId) {
        if (StringUtils.isBlank((CharSequence)newName)) {
            handler.addErrorKey(FIELD_NAME, KEY_NAME_NOT_SET, null, ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (!newName.equalsIgnoreCase(oldName) && this.projectComponentManager.containsName(newName, projectId)) {
            handler.addErrorKey(FIELD_NAME, KEY_NAME_NOT_UNIQUE, newName, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    protected void validateLead(Handler handler, String lead) {
        if (lead != null) {
            this.verifyUserExists(handler, lead);
        }
    }

    protected void validateAssigneeType(Handler handler, Long assigneeType) {
        if (!(assigneeType == null || ComponentAssigneeTypes.isProjectDefault(assigneeType) || ComponentAssigneeTypes.isProjectLead(assigneeType) || ComponentAssigneeTypes.isComponentLead(assigneeType) || ComponentAssigneeTypes.isUnassigned(assigneeType))) {
            handler.addErrorKey(FIELD_ASSIGNEE_TYPE, KEY_ASSIGNEE_TYPE_INVALID, String.valueOf(assigneeType), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    protected void verifyUserExists(Handler handler, String user) {
        if (this.userManager.getUserByKey(user) == null) {
            handler.addErrorKey(FIELD_COMPONENT_LEAD, KEY_USER_DOES_NOT_EXIST, user, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private String translateKeyToMessage(String key, String errorValue) {
        if (errorValue == null) {
            return this.jiraAuthenticationContext.getI18nHelper().getText(key);
        }
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, errorValue);
    }

    static abstract class Handler<T> {
        private final SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        protected T result;
        private final ErrorCollection errorCollection;
        private final DefaultProjectComponentService componentService;

        public Handler(ErrorCollection errorKeys, DefaultProjectComponentService componentService) {
            this.errorCollection = errorKeys;
            this.componentService = componentService;
        }

        void checkPermissions() {
        }

        void validateData() {
        }

        abstract void executeOnSuccess();

        void addErrorKey(String key, String errorValue, ErrorCollection.Reason reason) {
            this.simpleErrorCollection.addErrorMessage(key, reason);
            if (this.errorCollection != null) {
                this.errorCollection.addErrorMessage(this.componentService.translateKeyToMessage(key, errorValue), reason);
            }
        }

        void addErrorKey(String fieldName, String key, String errorValue, ErrorCollection.Reason reason) {
            this.simpleErrorCollection.addError(fieldName, key, reason);
            if (this.errorCollection != null) {
                this.errorCollection.addError(fieldName, this.componentService.translateKeyToMessage(key, errorValue), reason);
            }
        }

        public T run() {
            this.checkPermissions();
            if (!this.simpleErrorCollection.hasAnyErrors()) {
                this.validateData();
                if (!this.simpleErrorCollection.hasAnyErrors()) {
                    this.executeOnSuccess();
                }
            }
            return this.result;
        }
    }
}

