/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.bc.project.index.ProjectIndexTaskContext;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.IssueIndexHelper;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.BackgroundIndexListener;
import com.atlassian.jira.issue.index.IndexReconciler;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.statistics.util.FieldDocumentHitCollector;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

class ReIndexProjectIndexerCommand
implements Callable<IndexCommandResult>,
ProvidesTaskProgress {
    private final Project project;
    private final OfBizDelegator delegator;
    private final boolean shouldReplicate;
    private final IssueIndexer issueIndexer;
    private final TaskManager taskManager;
    private final SearchProvider searchProvider;
    private final IssueManager issueManager;
    private final EventPublisher eventPublisher;
    private final ProjectEventHandler projectEventHandler;
    private final IndexSnapshotOperator indexSnapshotOperator;
    private static final int BATCH_SIZE_FOR_PROJECT = 100;
    private final IssueBatcherFactory issueBatcherFactory;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final ClusterManager clusterManager;
    private volatile TaskProgressSink taskProgressSink;

    public ReIndexProjectIndexerCommand(Project project, boolean shouldReplicate, OfBizDelegator delegator, IssueIndexer issueIndexer, TaskManager taskManager, SearchProvider searchProvider, IssueManager issueManager, EventPublisher eventPublisher, IssueBatcherFactory issueBatcherFactory, Logger log, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nBeanFactory, ClusterManager clusterManager, ProjectEventHandler projectEventHandler, IndexSnapshotOperator indexSnapshotOperator) {
        this.shouldReplicate = shouldReplicate;
        this.issueIndexer = issueIndexer;
        this.taskManager = taskManager;
        this.delegator = delegator;
        this.project = project;
        this.searchProvider = searchProvider;
        this.issueManager = issueManager;
        this.eventPublisher = eventPublisher;
        this.issueBatcherFactory = issueBatcherFactory;
        this.log = log;
        this.i18nHelper = i18nHelper;
        this.i18nBeanFactory = i18nBeanFactory;
        this.clusterManager = clusterManager;
        this.projectEventHandler = projectEventHandler;
        this.indexSnapshotOperator = indexSnapshotOperator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexCommandResult call() {
        String johnsonMessage = this.i18nBeanFactory.getInstance((ApplicationUser)null).getText("admin.reindex.in.progress.johnson.summary");
        Event appEvent = new Event(EventType.get((String)"reindex"), johnsonMessage, EventLevel.get((String)"warning"));
        try {
            Context context = Contexts.percentageReporter((Sized)new Sized(){

                public int size() {
                    return (int)ReIndexProjectIndexerCommand.this.delegator.getCountByAnd("Issue", (EntityCondition)ReIndexProjectIndexerCommand.this.getEntityCondition());
                }

                public boolean isEmpty() {
                    return this.size() == 0;
                }
            }, (TaskProgressSink)this.taskProgressSink, (I18nHelper)this.i18nHelper, (Logger)this.log, (Event)appEvent);
            this.log.info((Object)String.format("Re-indexing project %s (%s) started", this.project.getName(), this.project.getKey()));
            this.projectEventHandler.handleProjectReindexStarted(this.project);
            Assertions.notNull((String)"context", (Object)context);
            context.setName("Issue");
            this.log.info((Object)String.format("Reindexing issues in project %s (%s)", this.project.getName(), this.project.getKey()));
            long startTime = System.currentTimeMillis();
            if (!this.reindexAllProjectIssues(context)) {
                IndexCommandResult indexCommandResult = new IndexCommandResult(-1L);
                return indexCommandResult;
            }
            context.setName("Create index snapshot");
            this.log.info((Object)String.format("Reindexing project %s (%s) finished", this.project.getName(), this.project.getKey()));
            if (this.shouldReplicate) {
                this.log.info((Object)String.format("Requesting index snapshot after reindexing project %s (%s)", this.project.getName(), this.project.getKey()));
                this.indexSnapshotOperator.forceCreateSnapshot();
            }
            long totalTime = System.currentTimeMillis() - startTime;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reindex took : " + totalTime + "ms"));
            }
            IndexCommandResult indexCommandResult = new IndexCommandResult(totalTime);
            return indexCommandResult;
        }
        finally {
            this.log.info((Object)"Re-indexing finished");
            this.projectEventHandler.handleProjectReindexFinished(this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reindexAllProjectIssues(Context context) {
        TaskDescriptor currentTaskDescriptor = this.taskManager.getLiveTask(new ProjectIndexTaskContext(this.project, this.clusterManager.getNodeId()));
        IssueIndexHelper issueIndexHelper = new IssueIndexHelper(this.issueManager, this.issueIndexer, this.getIssueFactory());
        AccumulatingResultBuilder resultBuilder = new AccumulatingResultBuilder();
        BackgroundIndexListener backgroundIndexListener = new BackgroundIndexListener();
        this.eventPublisher.register((Object)backgroundIndexListener);
        try {
            long[] indexedIssues = this.getProjectIssuesFromLucene();
            IndexReconciler reconciler = new IndexReconciler(indexedIssues);
            try {
                EntityConditionList where = this.getEntityCondition();
                IssuesBatcher batcher = this.issueBatcherFactory.getBatcher((EntityCondition)where, reconciler, 100);
                for (IssuesIterable batchOfIssues : batcher) {
                    if (currentTaskDescriptor.isCancelled()) {
                        throw new InterruptedException();
                    }
                    IssueIndexingParams indexingParams = IssueIndexingParams.builder().setChangeHistory(true).setComments(false).setWorklogs(true).build();
                    resultBuilder.add(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batchOfIssues, context, indexingParams, true, false));
                }
                resultBuilder.toResult().await();
            }
            finally {
                this.eventPublisher.unregister((Object)backgroundIndexListener);
                issueIndexHelper.fixupConcurrentlyIndexedIssues(context, resultBuilder, backgroundIndexListener, IssueIndexingParams.INDEX_ALL);
            }
            if (currentTaskDescriptor.isCancelled()) {
                throw new InterruptedException();
            }
            issueIndexHelper.fixupIndexCorruptions(resultBuilder, reconciler);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private EntityConditionList getEntityCondition() {
        EntityExpr whereProject = new EntityExpr("project", EntityOperator.EQUALS, (Object)this.project.getId());
        EntityConditionList whereNotArchived = new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("archived", EntityOperator.EQUALS, (Object)"N"), (Object)new EntityExpr("archived", EntityOperator.EQUALS, null)), EntityOperator.OR);
        return new EntityConditionList((List)ImmutableList.of((Object)whereProject, (Object)whereNotArchived), EntityOperator.AND);
    }

    private long[] getProjectIssuesFromLucene() throws SearchException {
        ProjectIssueCollector issueCollector = new ProjectIssueCollector();
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().project(new Long[]{this.project.getId()});
        this.searchProvider.search(SearchQuery.create((Query)builder.buildQuery(), null).overrideSecurity(true), (Collector)issueCollector);
        return issueCollector.getIssueIds();
    }

    public I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    private IssueFactory getIssueFactory() {
        return (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
    }

    private static class ProjectIssueCollector
    extends FieldDocumentHitCollector {
        long[] issueIds = new long[1000];
        private int i = 0;
        private static String issueIdFieldName = SystemSearchConstants.forIssueId().getIndexField();
        private static Set<String> fieldsToLoad = ImmutableSet.of((Object)issueIdFieldName);

        private ProjectIssueCollector() {
        }

        protected Set<String> getFieldsToLoad() {
            return fieldsToLoad;
        }

        public void collect(Document doc) {
            String issueId = doc.get(issueIdFieldName);
            this.issueIds = this.ensureCapacity(this.issueIds, this.i);
            this.issueIds[this.i] = Long.parseLong(issueId);
            ++this.i;
        }

        private long[] ensureCapacity(long[] issueIds, int i) {
            if (issueIds.length <= i) {
                int newSize = Math.max(i, issueIds.length + issueIds.length / 10);
                return Arrays.copyOf(issueIds, newSize);
            }
            return issueIds;
        }

        public long[] getIssueIds() {
            return Arrays.copyOf(this.issueIds, this.i);
        }
    }
}

