/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionImpl;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VersionBuilderImpl
implements VersionBuilder {
    private Version version;
    private Long projectId;
    private Long sequence;
    private String name;
    private String description;
    private Date startDate;
    private Date releaseDate;
    private Long scheduleAfterVersion;
    private boolean released;
    private boolean archived;

    public VersionBuilderImpl() {
        this.version = null;
    }

    public VersionBuilderImpl(Version version) {
        this.version = version;
        this.projectId = version.getProjectId();
        this.sequence = version.getSequence();
        this.name = version.getName();
        this.description = version.getDescription();
        this.startDate = version.getStartDate();
        this.releaseDate = version.getReleaseDate();
        this.released = version.isReleased();
        this.archived = version.isArchived();
    }

    @Nonnull
    public VersionBuilder projectId(@Nonnull Long projectId) {
        this.projectId = projectId;
        return this;
    }

    @Nullable
    public Long getProjectId() {
        return this.projectId;
    }

    @Nonnull
    public VersionBuilder name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public VersionBuilder description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public VersionBuilder startDate(@Nullable Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    public Date getStartDate() {
        return this.startDate;
    }

    @Nonnull
    public VersionBuilder releaseDate(@Nullable Date releaseDate) {
        this.releaseDate = releaseDate;
        return this;
    }

    @Nullable
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @Nonnull
    public VersionBuilder scheduleAfterVersion(@Nonnull Long scheduleAfterVersion) {
        this.scheduleAfterVersion = scheduleAfterVersion;
        return this;
    }

    @Nullable
    public Long getScheduleAfterVersion() {
        return this.scheduleAfterVersion;
    }

    @Nonnull
    public VersionBuilder released(boolean released) {
        this.released = released;
        return this;
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isArchived() {
        return this.archived;
    }

    @Nullable
    public Long getSequence() {
        return this.sequence;
    }

    @Nonnull
    public VersionBuilder sequence(@Nonnull Long sequence) {
        this.sequence = sequence;
        return this;
    }

    @Nonnull
    public Version build() {
        return new VersionImpl(this.projectId, this.version != null ? this.version.getId() : null, this.name, this.description, this.sequence, this.archived, this.released, this.releaseDate, this.startDate);
    }

    @Nonnull
    public VersionBuilder archived(boolean archived) {
        this.archived = archived;
        return this;
    }

    @Nullable
    public Version getVersion() {
        return this.version;
    }
}

