/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.security.login;

import com.atlassian.jira.bc.security.login.CaptchaValidator;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.octo.captcha.service.image.ImageCaptchaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaValidatorImpl
implements CaptchaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaValidatorImpl.class);
    private final ImageCaptchaService imageCaptchaService;
    private final LoginService loginService;

    public CaptchaValidatorImpl(JiraCaptchaService jiraCaptchaService, LoginService loginService) {
        this.imageCaptchaService = jiraCaptchaService.getImageCaptchaService();
        this.loginService = loginService;
    }

    public boolean isRequired(String username) {
        try {
            return this.loginService.getLoginInfo(username).isElevatedSecurityCheckRequired();
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while checking for CAPTCHA challenge requirement: ", (Throwable)e);
            return false;
        }
    }

    public boolean validate(String captchaId, String captchaResponse) {
        try {
            return this.imageCaptchaService.validateResponseForID(captchaId, (Object)captchaResponse);
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while resolving a CAPTCHA challenge: ", (Throwable)e);
            return false;
        }
    }
}

