/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.security.login;

import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.bc.security.login.LoginProperties;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.seraph.auth.AuthenticationErrorType;
import com.atlassian.seraph.filter.LoginFilterRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServiceImpl
implements LoginService {
    private final LoginManager loginManager;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final JiraContactHelper contactHelper;
    private final JiraAuthenticationContext authenticationContext;

    public LoginServiceImpl(LoginManager loginManager, ApplicationProperties applicationProperties, UserManager userManager, JiraContactHelper contactHelper, JiraAuthenticationContext authenticationContext) {
        this.contactHelper = contactHelper;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.loginManager = (LoginManager)Assertions.notNull((String)"loginManager", (Object)loginManager);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
    }

    public LoginInfo getLoginInfo(String userName) {
        return this.loginManager.getLoginInfo(userName);
    }

    public boolean isElevatedSecurityCheckAlwaysShown() {
        return this.loginManager.isElevatedSecurityCheckAlwaysShown();
    }

    public void resetFailedLoginCount(ApplicationUser user) {
        this.loginManager.resetFailedLoginCount(user);
    }

    public LoginInfo updateLastLoginTime(ApplicationUser user) {
        return this.loginManager.updateLastLoginTime(user);
    }

    public LoginResult authenticate(ApplicationUser user, String password) {
        return this.loginManager.authenticate(user, password);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        this.loginManager.logout(request, response);
    }

    public LoginProperties getLoginProperties(ApplicationUser remoteUser, HttpServletRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        LoginResult lastLoginResult = (LoginResult)request.getAttribute("com.atlassian.jira.security.login.LoginManager.LoginResult");
        LoginInfo loginInfo = lastLoginResult == null ? null : lastLoginResult.getLoginInfo();
        boolean loginSucceeded = remoteUser != null;
        boolean loginError = "error".equals(LoginFilterRequest.getAuthenticationStatus((HttpServletRequest)request));
        boolean communicationError = AuthenticationErrorType.CommunicationError.equals((Object)LoginFilterRequest.getAuthenticationErrorType((HttpServletRequest)request));
        boolean captchaFailure = lastLoginResult != null && lastLoginResult.getReason() == LoginReason.AUTHENTICATION_DENIED;
        boolean loginFailedCausedByPermissions = lastLoginResult != null && lastLoginResult.getReason() == LoginReason.AUTHORISATION_FAILED;
        boolean isElevatedSecurityCheckShown = this.isElevatedSecurityCheckShown(loginInfo);
        if (LoginLoggers.LOGIN_GADGET_LOG.isDebugEnabled()) {
            LoginLoggers.LOGIN_GADGET_LOG.debug((Object)("Gadget login called with lastLoginResult : " + String.valueOf(lastLoginResult)));
        }
        return LoginProperties.builder().loginSucceeded(loginSucceeded).loginError(loginError).communicationError(communicationError).allowCookies(this.applicationProperties.getOption("jira.option.allowcookies")).externalPasswordManagement(!this.userManager.hasPasswordWritableDirectory()).externalUserManagement(this.applicationProperties.getOption("jira.option.user.externalmanagement")).isPublicMode(this.isPublicMode()).isElevatedSecurityCheckShown(isElevatedSecurityCheckShown).captchaFailure(captchaFailure).loginFailedByPermissions(loginFailedCausedByPermissions).contactAdminLink(this.getContactLink(request)).build();
    }

    private String getContactLink(HttpServletRequest request) {
        return this.contactHelper.getAdministratorContactLinkHtml(JiraUrl.constructBaseUrl((HttpServletRequest)request), this.authenticationContext.getI18nHelper());
    }

    boolean isPublicMode() {
        return JiraUtils.isPublicMode();
    }

    private boolean isElevatedSecurityCheckShown(LoginInfo loginInfo) {
        return this.isElevatedSecurityCheckAlwaysShown() || loginInfo != null && loginInfo.isElevatedSecurityCheckRequired();
    }
}

