/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.bc.user.ApplicationUserBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class ApplicationUserBuilderImpl
implements ApplicationUserBuilder {
    private final ApplicationUser user;
    private boolean active;
    private String name;
    private String emailAddress;
    private String displayName;

    public ApplicationUserBuilderImpl(ApplicationUser user) {
        this.user = user;
        this.active = user.isActive();
    }

    @Nonnull
    public ApplicationUserBuilder active(boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    public ApplicationUserBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public ApplicationUserBuilder emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nonnull
    public ApplicationUserBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nonnull
    public ApplicationUser build() {
        ImmutableUser.Builder userBuilder = ImmutableUser.newUser((User)this.user.getDirectoryUser());
        userBuilder.name((String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)this.user.getName()));
        userBuilder.emailAddress((String)StringUtils.defaultIfBlank((CharSequence)this.emailAddress, (CharSequence)this.user.getEmailAddress()));
        userBuilder.displayName((String)StringUtils.defaultIfBlank((CharSequence)this.displayName, (CharSequence)this.user.getDisplayName()));
        userBuilder.active(this.active);
        return new DelegatingApplicationUser(this.user.getId(), this.user.getKey(), (User)userBuilder.toUser());
    }
}

