/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.property;

import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.EntityWithKeyPropertyHelper;
import com.atlassian.jira.event.entity.EntityPropertyDeletedEvent;
import com.atlassian.jira.event.entity.EntityPropertySetEvent;
import com.atlassian.jira.event.user.property.UserPropertyDeletedEvent;
import com.atlassian.jira.event.user.property.UserPropertySetEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import java.util.function.Function;

public class UserPropertyHelper
implements EntityWithKeyPropertyHelper<ApplicationUser> {
    protected final GlobalPermissionManager permissionManager;
    private final UserManager userManager;
    private final I18nHelper i18n;

    public UserPropertyHelper(UserManager userManager, GlobalPermissionManager permissionManager, I18nHelper i18n) {
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
    }

    public EntityPropertyHelper.CheckPermissionFunction<ApplicationUser> hasReadPermissionFunction() {
        return (currentUser, editedUser) -> this.errorIfPermissionCheckFailed(this.hasPermissionsToReadProperties((ApplicationUser)currentUser, (ApplicationUser)editedUser), this.i18n.getText("user.properties.forbidden.read", currentUser.getUsername(), editedUser.getUsername()));
    }

    public EntityPropertyHelper.CheckPermissionFunction<ApplicationUser> hasEditPermissionFunction() {
        return (currentUser, editedUser) -> this.errorIfPermissionCheckFailed(this.hasPermissionsToEditProperties((ApplicationUser)currentUser, (ApplicationUser)editedUser), this.i18n.getText("user.properties.forbidden.edit", currentUser.getUsername(), editedUser.getUsername()));
    }

    public Function<Long, Option<ApplicationUser>> getEntityByIdFunction() {
        return id -> Option.option((Object)this.userManager.getUserById(id).orElse(null));
    }

    public Function<String, Option<ApplicationUser>> getEntityByKeyFunction() {
        return key -> Option.option((Object)this.userManager.getUserByKey(key));
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertySetEvent> createSetPropertyEventBiFunction() {
        return (currentUser, property) -> new UserPropertySetEvent(property, currentUser);
    }

    public BiFunction<ApplicationUser, EntityProperty, ? extends EntityPropertyDeletedEvent> createDeletePropertyEventBiFunction() {
        return (currentUser, property) -> new UserPropertyDeletedEvent(property, currentUser);
    }

    private ErrorCollection errorIfPermissionCheckFailed(boolean hasPermission, String errorMessage) {
        return hasPermission ? ErrorCollections.empty() : ErrorCollections.create((String)errorMessage, (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN);
    }

    private boolean hasPermissionsToReadProperties(ApplicationUser currentUser, ApplicationUser accessedUser) {
        return this.hasPermissionsToEditProperties(currentUser, accessedUser);
    }

    private boolean hasPermissionsToEditProperties(ApplicationUser currentUser, ApplicationUser accessedUser) {
        return this.isTheSameUser(currentUser, accessedUser) || this.canAdministerOtherUser(currentUser, accessedUser);
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.USER_PROPERTY;
    }

    protected final boolean canAdministerOtherUser(ApplicationUser currentUser, ApplicationUser accessedUser) {
        return this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, currentUser) || this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser) && !this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, accessedUser);
    }

    protected final boolean isTheSameUser(ApplicationUser user1, ApplicationUser user2) {
        return user1.getKey().equals(user2.getKey());
    }
}

