/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.workflow;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.bc.workflow.WorkflowTransitionService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.util.workflow.WorkflowEditorTransitionConditionUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultWorkflowTransitionService
implements WorkflowTransitionService {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowEditorTransitionConditionUtil transitionConditionUtil;
    private final WorkflowService workflowService;

    public DefaultWorkflowTransitionService(JiraAuthenticationContext jiraAuthenticationContext, WorkflowService workflowService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.transitionConditionUtil = new WorkflowEditorTransitionConditionUtil();
        this.workflowService = workflowService;
    }

    public ErrorCollection addConditionToWorkflow(@Nonnull String transitionName, @Nonnull ConditionDescriptor condition, @Nonnull JiraWorkflow workflow) {
        ErrorCollection errorCollection = this.checkArguments(transitionName, workflow, condition, "admin.workflowtransitions.service.error.null.condition");
        if (errorCollection.hasAnyErrors()) {
            return errorCollection;
        }
        Option<JiraWorkflow> getDraft = this.draftOf(errorCollection, workflow);
        if (getDraft.isEmpty()) {
            return errorCollection;
        }
        JiraWorkflow draftWorkflow = (JiraWorkflow)getDraft.get();
        Either<Collection<ActionDescriptor>, ErrorCollection> getActions = this.getActionsByName(transitionName, draftWorkflow);
        if (getActions.isRight()) {
            return (ErrorCollection)getActions.right().get();
        }
        for (ActionDescriptor action : (Collection)getActions.left().get()) {
            this.transitionConditionUtil.addCondition(action, "", condition);
        }
        this.workflowService.updateWorkflow(this.getServiceContext(errorCollection), draftWorkflow);
        return errorCollection;
    }

    public ErrorCollection addPostFunctionToWorkflow(@Nonnull String transitionName, @Nonnull FunctionDescriptor function, @Nonnull JiraWorkflow workflow) {
        ErrorCollection errorCollection = this.checkArguments(transitionName, workflow, function, "admin.workflowtransitions.service.error.null.function");
        if (errorCollection.hasAnyErrors()) {
            return errorCollection;
        }
        Option<JiraWorkflow> getDraft = this.draftOf(errorCollection, workflow);
        if (getDraft.isEmpty()) {
            return errorCollection;
        }
        JiraWorkflow draftWorkflow = (JiraWorkflow)getDraft.get();
        Either<Collection<ActionDescriptor>, ErrorCollection> getActions = this.getActionsByName(transitionName, draftWorkflow);
        if (getActions.isRight()) {
            return (ErrorCollection)getActions.right().get();
        }
        for (ActionDescriptor action : (Collection)getActions.left().get()) {
            ResultDescriptor unconditionalResult = action.getUnconditionalResult();
            List postFunctions = unconditionalResult.getPostFunctions();
            postFunctions.add(0, function);
        }
        this.workflowService.updateWorkflow(this.getServiceContext(errorCollection), draftWorkflow);
        return errorCollection;
    }

    public ErrorCollection setScreen(@Nonnull String transitionName, @Nullable FieldScreen screen, @Nonnull JiraWorkflow workflow) {
        ErrorCollection errorCollection = this.checkArguments(transitionName, workflow);
        if (errorCollection.hasAnyErrors()) {
            return errorCollection;
        }
        Option<JiraWorkflow> getDraft = this.draftOf(errorCollection, workflow);
        if (getDraft.isEmpty()) {
            return errorCollection;
        }
        JiraWorkflow draftWorkflow = (JiraWorkflow)getDraft.get();
        Either<Collection<ActionDescriptor>, ErrorCollection> getActions = this.getActionsByName(transitionName, draftWorkflow);
        if (getActions.isRight()) {
            return (ErrorCollection)getActions.right().get();
        }
        for (ActionDescriptor action : (Collection)getActions.left().get()) {
            WorkflowUtil.setActionScreen((ActionDescriptor)action, (FieldScreen)screen);
        }
        this.workflowService.updateWorkflow(this.getServiceContext(errorCollection), draftWorkflow);
        return errorCollection;
    }

    private ErrorCollection checkArguments(String transitionName, JiraWorkflow jiraWorkflow) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        this.checkActionAndWorkflow(transitionName, jiraWorkflow, (ErrorCollection)errorCollection, i18n);
        return errorCollection;
    }

    private ErrorCollection checkArguments(String transitionName, JiraWorkflow jiraWorkflow, Object object, String i18nKeyForObject) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        this.checkActionAndWorkflow(transitionName, jiraWorkflow, (ErrorCollection)errorCollection, i18n);
        if (object == null) {
            errorCollection.addErrorMessage(i18n.getText(i18nKeyForObject));
        }
        return errorCollection;
    }

    private void checkActionAndWorkflow(String transitionName, JiraWorkflow jiraWorkflow, ErrorCollection errorCollection, I18nHelper i18n) {
        if (transitionName == null) {
            errorCollection.addErrorMessage(i18n.getText("admin.workflowtransitions.service.error.null.action.name"));
        }
        if (jiraWorkflow == null) {
            errorCollection.addErrorMessage(i18n.getText("admin.workflowtransitions.service.error.null.workflow"));
        }
    }

    @VisibleForTesting
    Option<JiraWorkflow> draftOf(ErrorCollection errorCollection, JiraWorkflow jiraWorkflow) {
        JiraServiceContext jiraServiceContext = this.getServiceContext(errorCollection);
        JiraWorkflow existingDraftWorkflow = this.workflowService.getDraftWorkflow(jiraServiceContext, jiraWorkflow.getName());
        return existingDraftWorkflow == null ? Option.option((Object)this.workflowService.createDraftWorkflow(jiraServiceContext, jiraWorkflow.getName())) : Option.some((Object)existingDraftWorkflow);
    }

    private Either<Collection<ActionDescriptor>, ErrorCollection> getActionsByName(String transitionName, JiraWorkflow draftWorkflow) {
        Collection actions = draftWorkflow.getActionsByName(transitionName);
        if (actions.isEmpty()) {
            I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(i18n.getText("admin.workflowtransitions.service.error.no.action", transitionName));
            return Either.right((Object)errorCollection);
        }
        return Either.left((Object)actions);
    }

    private JiraServiceContext getServiceContext(ErrorCollection errorCollection) {
        return new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser(), errorCollection);
    }
}

