/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.event.issue.IssuesPreArchiveEvent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.ArchiveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.archiving.ArchivedIssueService;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkArchiveOperation
implements ProgressAwareBulkOperation {
    private static final Logger log = LoggerFactory.getLogger(BulkArchiveOperation.class);
    public static final String NAME = "BulkArchive";
    public static final String NAME_KEY = "bulk.archive.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.archive.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.archive.cannotperform";
    private EventPublisher eventPublisher;
    private ArchivedIssueService archivedIssueService;
    private IssueManager issueManager;
    private I18nHelper.BeanFactory i18nHelper;

    public BulkArchiveOperation(EventPublisher eventPublisher, ArchivedIssueService archivedIssueService, IssueManager issueManager, I18nHelper.BeanFactory i18nHelper) {
        this.eventPublisher = eventPublisher;
        this.archivedIssueService = archivedIssueService;
        this.issueManager = issueManager;
        this.i18nHelper = i18nHelper;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        return bulkEditBean.getSelectedIssues().stream().allMatch(issue -> {
            ArchivedIssueService.ValidationResult validationResult = this.archivedIssueService.validateArchiveIssue(remoteUser, issue.getKey(), bulkEditBean.isSendBulkNotification());
            return validationResult.isValid() || this.isSendNotificationErrorReason(validationResult, remoteUser);
        });
    }

    public void perform(BulkEditBean bulkEditBean, ApplicationUser applicationUser, Context taskContext) throws BulkOperationException {
        List selectedIssues = bulkEditBean.getSelectedIssues().stream().filter(i -> !i.isSubTask()).collect(Collectors.toList());
        boolean sendMail = bulkEditBean.isSendBulkNotification();
        List<Long> issueIds = selectedIssues.stream().map(Issue::getId).collect(Collectors.toList());
        this.eventPublisher.publish((Object)new IssuesPreArchiveEvent(issueIds));
        for (Issue issue : selectedIssues) {
            Context.Task task = taskContext.start((Object)issue);
            if (this.issueManager.getIssueObject(issue.getId()) != null) {
                try {
                    this.issueManager.archiveIssue(applicationUser, issue, EventDispatchOption.ISSUE_ARCHIVED, sendMail);
                }
                catch (ArchiveException e) {
                    throw new BulkOperationException((Throwable)e);
                }
            } else {
                log.debug("Not archiving issue with id '" + issue.getId() + "' and key '" + issue.getKey() + "' as it does not exist in the database.");
            }
            task.complete();
        }
    }

    public int getNumberOfTasks(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().size();
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BulkArchiveOperation;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }

    private boolean isSendNotificationErrorReason(ArchivedIssueService.ValidationResult validationResult, ApplicationUser user) {
        String error = this.i18nHelper.getInstance(user).getText("update.issue.resource.not.enough.permissions.for.discarding.user.notification");
        return validationResult.getErrorCollection().getErrorMessages().contains(error);
    }
}

