/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOption;
import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.bulkedit.operation.BulkEditActionImpl;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.bulkedit.operation.UnavailableBulkEditAction;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.IssueFieldsCharacterLimitExceededException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.LongIdsValueHolder;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditMultiSelectFieldBean;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BulkEditOperation
implements ProgressAwareBulkOperation {
    public static final String NAME_KEY = "bulk.edit.operation.name";
    public static final String NAME = "BulkEdit";
    private static final String DESCRIPTION_KEY = "bulk.edit.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.edit.cannotperform";
    private static final List<String> ALL_SYSTEM_FIELDS = ImmutableList.of((Object)"issuetype", (Object)"security", (Object)"priority", (Object)"fixVersions", (Object)"versions", (Object)"components", (Object)"assignee", (Object)"reporter", (Object)"description", (Object)"environment", (Object)"duedate", (Object)"comment", (Object[])new String[]{"labels", "timetracking"});
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FeatureManager featureManager;

    public BulkEditOperation(IssueManager issueManager, PermissionManager permissionManager, ProjectManager projectManager, FieldManager fieldManager, JiraAuthenticationContext authenticationContext, FeatureManager featureManager) {
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (issue.isEditable()) continue;
            return false;
        }
        Collection<BulkEditAction> actions = this.getActions(bulkEditBean, remoteUser).values();
        for (BulkEditAction action : actions) {
            BulkEditAction bulkEditAction = action;
            if (!bulkEditAction.isAvailable(bulkEditBean)) continue;
            return true;
        }
        return false;
    }

    public Map<String, BulkEditAction> getActions(BulkEditBean bulkEditBean, ApplicationUser applicationUser) {
        LinkedHashMap<String, BulkEditAction> actions = new LinkedHashMap<String, BulkEditAction>();
        for (String actionName : ALL_SYSTEM_FIELDS) {
            if (actionName.equals("description") && !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ALLOW_DESCRIPTION_BULK_EDIT)) continue;
            actions.put(actionName, this.buildBulkEditAction(actionName));
        }
        actions.putAll(this.getCustomFieldActions(bulkEditBean, applicationUser));
        return actions;
    }

    private BulkEditAction buildBulkEditAction(String fieldId) {
        return new BulkEditActionImpl(fieldId, this.fieldManager, this.authenticationContext);
    }

    public Map<String, BulkEditAction> getCustomFieldActions(BulkEditBean bulkEditBean, ApplicationUser applicationUser) {
        SearchContextImpl searchContext = new SearchContextImpl(null, new ArrayList<Long>(bulkEditBean.getProjectIds()), new ArrayList<String>(bulkEditBean.getIssueTypes()));
        List customFields = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects((SearchContext)searchContext);
        ArrayList availableCustomFields = Lists.newArrayListWithCapacity((int)customFields.size());
        for (CustomField customField : customFields) {
            for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
                if (fieldLayout.isFieldHidden(customField.getId())) continue;
                availableCustomFields.add(customField);
            }
        }
        if (!availableCustomFields.isEmpty()) {
            for (Long projectId : bulkEditBean.getProjectIds()) {
                if (this.hasPermission(ProjectPermissions.EDIT_ISSUES, this.projectManager.getProjectObj(projectId), applicationUser)) continue;
                return ImmutableMap.of((Object)"", (Object)new UnavailableBulkEditAction("common.concepts.customfields", "bulk.edit.unavailable.customfields", this.authenticationContext));
            }
            LinkedHashMap<String, BulkEditAction> bulkEditActions = new LinkedHashMap<String, BulkEditAction>();
            for (CustomField customField : availableCustomFields) {
                bulkEditActions.put(customField.getId(), this.buildBulkEditAction(customField.getId()));
            }
            return bulkEditActions;
        }
        return ImmutableMap.of((Object)"", (Object)new UnavailableBulkEditAction("common.concepts.customfields", "bulk.edit.unavailable.customfields", this.authenticationContext));
    }

    private boolean hasPermission(ProjectPermissionKey permission, Project project, ApplicationUser remoteUser) {
        return this.permissionManager.hasPermission(permission, project, remoteUser);
    }

    public void perform(BulkEditBean bulkEditBean, ApplicationUser applicationUser, Context taskContext) throws BulkOperationException {
        boolean sendMail = bulkEditBean.isSendBulkNotification();
        BulkEditMultiSelectFieldBean bulkEditMultiSelectFieldBean = bulkEditBean.getBulkEditMultiSelectFieldBean();
        for (Issue issue1 : bulkEditBean.getSelectedIssues()) {
            Context.Task task = taskContext.start((Object)issue1);
            MutableIssue issue = (MutableIssue)issue1;
            for (BulkEditAction bulkEditAction : bulkEditBean.getActions().values()) {
                OrderableField field = bulkEditAction.getField();
                FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue.getProjectObject(), issue.getIssueTypeId()).getFieldLayoutItem(field);
                if (bulkEditMultiSelectFieldBean.isChangeModeSelectionAllowed(field)) {
                    Option changeMode = bulkEditMultiSelectFieldBean.getChangeModeForField(field);
                    if (!changeMode.isDefined()) {
                        throw new RuntimeException("Change mode not set for MultiSelect System Field: " + field.getId());
                    }
                    Map valuesHolder = ((BulkEditMultiSelectFieldOption)changeMode.get()).getFieldValuesMap((Issue)issue, field, bulkEditBean.getFieldValuesHolder());
                    Object initialFieldValues = valuesHolder.get(field.getId());
                    field.updateIssue(fieldLayoutItem, issue, valuesHolder);
                    if (valuesHolder.get(field.getId()).toString().equals(initialFieldValues.toString()) || !(initialFieldValues instanceof Collection)) continue;
                    Collection fieldValuesAfterOperation = (Collection)valuesHolder.get(field.getId());
                    Collection<Object> recentlyAddedFieldValues = this.subtractValues(fieldValuesAfterOperation, (Collection)initialFieldValues);
                    this.updateFieldValuesHolder(field, recentlyAddedFieldValues, bulkEditBean.getFieldValuesHolder(), true);
                    continue;
                }
                field.updateIssue(fieldLayoutItem, issue, bulkEditBean.getFieldValuesHolder());
            }
            try {
                this.issueManager.updateIssue(applicationUser, issue, EventDispatchOption.ISSUE_UPDATED, sendMail);
            }
            catch (IssueFieldsCharacterLimitExceededException ex) {
                throw new BulkOperationException("Character limit exceeded, limit: " + ex.getMaxNumberOfCharacters() + ", fields: " + ex.getInvalidFieldIds(), (Throwable)ex);
            }
            task.complete();
        }
    }

    @VisibleForTesting
    Collection<Object> subtractValues(Collection<?> fieldValues, Collection<?> fieldValuesToRemove) {
        Set fieldValuesToRemoveSet = fieldValuesToRemove.stream().map(Object::toString).collect(Collectors.toSet());
        return fieldValues.stream().filter(fieldValue -> !fieldValuesToRemoveSet.contains(fieldValue.toString())).collect(Collectors.toCollection(fieldValues instanceof Set ? HashSet::new : ArrayList::new));
    }

    @VisibleForTesting
    void updateFieldValuesHolder(OrderableField<?> field, Collection<?> fieldValuesToAdd, Map<String, Object> fieldValuesHolder, Boolean clearValuesToAdd) {
        if (fieldValuesHolder.get(field.getId()) instanceof LongIdsValueHolder) {
            LongIdsValueHolder newFieldValues = new LongIdsValueHolder((List<Long>)new ArrayList<Long>(fieldValuesToAdd));
            LongIdsValueHolder fieldValues = LongIdsValueHolder.fromFieldValuesHolder(field.getId(), fieldValuesHolder);
            fieldValues.addAll(newFieldValues);
            if (clearValuesToAdd.booleanValue()) {
                fieldValues.setValuesToAdd(Collections.emptySet());
            }
            fieldValuesHolder.put(field.getId(), fieldValues);
        }
    }

    public int getNumberOfTasks(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().size();
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public boolean equals(Object o) {
        return o instanceof BulkEditOperation;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }
}

