/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.instrumentation.ExternalCounter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GoogleCacheInstruments {
    private static final Logger log = LoggerFactory.getLogger(GoogleCacheInstruments.class);
    private final String name;
    private final ConcurrentMap<Cache, Cache> caches = Maps.newConcurrentMap();
    private final ImmutableList<Instrument> instruments;

    public GoogleCacheInstruments(String name) {
        this.name = name;
        this.instruments = ImmutableList.of((Object)new ExternalGauge(String.format("cache.%s.size", name), (ExternalValue)new Size()), (Object)new ExternalCounter(String.format("cache.%s.hitCount", name), (ExternalValue)new HitCount()), (Object)new ExternalCounter(String.format("cache.%s.missCount", name), (ExternalValue)new MissCount()), (Object)new ExternalCounter(String.format("cache.%s.loadSuccessCount", name), (ExternalValue)new LoadSuccessCount()), (Object)new ExternalCounter(String.format("cache.%s.loadExceptionCount", name), (ExternalValue)new LoadExceptionCount()), (Object)new ExternalCounter(String.format("cache.%s.totalLoadTime", name), (ExternalValue)new TotalLoadTime()), (Object)new ExternalCounter(String.format("cache.%s.evictionCount", name), (ExternalValue)new EvictionCount()));
    }

    public String getName() {
        return this.name;
    }

    public GoogleCacheInstruments addCache(Cache cache) {
        this.caches.put(cache, cache);
        return this;
    }

    public GoogleCacheInstruments removeCache(Cache cache) {
        this.caches.remove(cache);
        return this;
    }

    public GoogleCacheInstruments install() {
        for (Instrument instrument : this.instruments) {
            Instrumentation.putInstrument(instrument);
        }
        log.debug("Installed google cache instrumentation for: {}", (Object)this.getName());
        return this;
    }

    public GoogleCacheInstruments uninstall() {
        log.debug("NOOP: Uninstall google cache instrumentation for: {}", (Object)this.getName());
        return this;
    }

    private class Size
    extends SumOfCacheStats {
        private Size() {
        }

        @Override
        protected long get(Cache cache) {
            return cache.size();
        }
    }

    private class HitCount
    extends SumOfCacheStats {
        private HitCount() {
        }

        @Override
        protected long get(Cache cache) {
            return cache.stats().hitCount();
        }
    }

    private class MissCount
    extends SumOfCacheStats {
        private MissCount() {
        }

        @Override
        protected long get(Cache cache) {
            return cache.stats().missCount();
        }
    }

    private class LoadSuccessCount
    extends SumOfCacheStats {
        private LoadSuccessCount() {
        }

        @Override
        protected long get(Cache cache) {
            return cache.stats().loadSuccessCount();
        }
    }

    private class LoadExceptionCount
    extends SumOfCacheStats {
        private LoadExceptionCount() {
        }

        @Override
        protected long get(Cache cache) {
            return cache.stats().loadExceptionCount();
        }
    }

    private class TotalLoadTime
    extends SumOfCacheStats {
        private TotalLoadTime() {
        }

        @Override
        protected long get(Cache cache) {
            return TimeUnit.MILLISECONDS.convert(cache.stats().totalLoadTime(), TimeUnit.NANOSECONDS);
        }
    }

    private class EvictionCount
    extends SumOfCacheStats {
        private EvictionCount() {
        }

        @Override
        protected long get(Cache cache) {
            return cache.stats().evictionCount();
        }
    }

    private abstract class SumOfCacheStats
    implements ExternalValue {
        private SumOfCacheStats() {
        }

        public long getValue() {
            long value = 0L;
            for (Cache cache : GoogleCacheInstruments.this.caches.keySet()) {
                value += this.get(cache);
            }
            return value;
        }

        protected abstract long get(Cache var1);
    }
}

