/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.CacheFactory;
import com.atlassian.jira.cache.JiraVCacheRequestContextSupplier;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.vcache.ChangeRate;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.JvmCacheSettingsBuilder;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.DefaultVCacheCreationHandler;
import com.atlassian.vcache.internal.core.metrics.DefaultMetricsCollector;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.metrics.NoopMetricsCollector;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.atlassian.vcache.internal.legacy.LegacyServiceSettingsBuilder;
import com.atlassian.vcache.internal.legacy.LegacyVCacheService;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheService;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettingsBuilder;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.atlassian.fugue.Pair;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraVCacheServiceCreator {
    private static final Logger log = LoggerFactory.getLogger(JiraVCacheServiceCreator.class);
    private static final String VCACHE_PREFIX = "com.atlassian.vcache.";
    static final String PROPERTY_MAX_TTL_IN_SEC = "com.atlassian.vcache.max_ttl_secs";
    static final String PROPERTY_MAX_ENTRIES = "com.atlassian.vcache.max_entries";
    static final String PROPERTY_FORCE_VCACHE_TYPE = "com.atlassian.vcache.force_vcache_backend";
    static final String PROPERTY_MEMCACHED_HOST = "com.atlassian.vcache.memchached.host";
    static final String PROPERTY_MEMCACHED_PORT = "com.atlassian.vcache.memchached.port";
    private static final int DEFAULT_MEMCACHED_PORT = 11211;
    private static final String PROPERTY_WARN_NO_CONTEXT = "com.atlassian.vcache.warn_no_context";
    private static final int DEFAULT_MAX_ENTRIES = Integer.MAX_VALUE;
    private static final long DEFAULT_MAX_TTL = Duration.ofHours(24L).getSeconds();
    private static final Duration DEFAULT_TTL_EXTERNAL_CACHE = Duration.ofHours(1L);
    private static final Duration DEFAULT_TTL_JVM_CACHE = Duration.ofHours(24L);
    private static final String PRODUCT_IDENTIFIER = "JIRA";
    private final JiraProperties jiraProperties;
    private final Optional<CacheFactory> cacheFactory;
    private final boolean avoidCasOps;

    public JiraVCacheServiceCreator(JiraProperties jiraProperties, Optional<CacheFactory> cacheFactory, boolean avoidCasOps) {
        this.jiraProperties = jiraProperties;
        this.cacheFactory = cacheFactory;
        this.avoidCasOps = avoidCasOps;
    }

    @Nonnull
    public Pair<JiraVCacheRequestContextSupplier, AbstractVCacheService> createVCacheService() {
        Boolean warnNoContext = this.jiraProperties.getBoolean(PROPERTY_WARN_NO_CONTEXT);
        JiraVCacheRequestContextSupplier contextSupplier = new JiraVCacheRequestContextSupplier(warnNoContext == null ? false : warnNoContext);
        CacheType cacheType = this.determineCacheType();
        switch (cacheType) {
            case LEGACY: {
                return Pair.pair((Object)contextSupplier, (Object)this.createLegacyService(contextSupplier));
            }
            case MEMCACHED: {
                return Pair.pair((Object)contextSupplier, (Object)this.createMemcachedService(contextSupplier));
            }
        }
        throw new UnsupportedOperationException("Unsupported cache type: " + cacheType);
    }

    private AbstractVCacheService createMemcachedService(java.util.function.Supplier<RequestContext> contextSupplier) {
        String host = this.jiraProperties.getProperty(PROPERTY_MEMCACHED_HOST);
        Integer port = this.jiraProperties.getInteger(PROPERTY_MEMCACHED_PORT, Integer.valueOf(11211));
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new IllegalStateException("Cannot initialise VCache - memcached host is not defined");
        }
        Supplier lazySupplier = Suppliers.memoize(() -> this.createMemcachedClient(host, port));
        MemcachedVCacheServiceSettingsBuilder builder = new MemcachedVCacheServiceSettingsBuilder().productIdentifier(PRODUCT_IDENTIFIER).clientSupplier((java.util.function.Supplier)lazySupplier).threadLocalContextSupplier(contextSupplier).workContextContextSupplier(contextSupplier).defaultsProvider((VCacheSettingsDefaultsProvider)new JiraVCacheDefaultsProvider()).creationHandler(this.createVCacheCreationHandler()).metricsCollector(this.createMetricsCollector(contextSupplier));
        return new MemcachedVCacheService(builder.build());
    }

    private MemcachedClientIF createMemcachedClient(String host, int port) {
        try {
            return new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress(host, port)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AbstractVCacheService createLegacyService(java.util.function.Supplier<RequestContext> contextSupplier) {
        if (!this.cacheFactory.isPresent()) {
            throw new IllegalStateException("Cannot instantiate LegacyVCacheService - cache factory was not provided.");
        }
        LegacyServiceSettingsBuilder settingsBuilder = new LegacyServiceSettingsBuilder();
        if (this.avoidCasOps) {
            settingsBuilder.enableAvoidCasOperations();
        }
        return new LegacyVCacheService(PRODUCT_IDENTIFIER, contextSupplier, contextSupplier, (VCacheSettingsDefaultsProvider)new JiraVCacheDefaultsProvider(), this.createVCacheCreationHandler(), this.createMetricsCollector(contextSupplier), this.cacheFactory::get, settingsBuilder.build(), requestContext -> {});
    }

    private CacheType determineCacheType() {
        String forcedType = this.jiraProperties.getProperty(PROPERTY_FORCE_VCACHE_TYPE);
        if (forcedType != null) {
            CacheType cacheType = (CacheType)EnumUtils.getEnum(CacheType.class, (String)forcedType.toUpperCase());
            if (cacheType != null) {
                return cacheType;
            }
            log.warn("Cannot force usage of provided cache type: '{}' - unsupported backend type.");
        }
        return CacheType.LEGACY;
    }

    private MetricsCollector createMetricsCollector(java.util.function.Supplier<RequestContext> contextSupplier) {
        Boolean collectMetrics = this.jiraProperties.getBoolean("jira.instrumentation.cache");
        return collectMetrics != false ? new DefaultMetricsCollector(contextSupplier) : new NoopMetricsCollector();
    }

    private VCacheCreationHandler createVCacheCreationHandler() {
        Integer maxEntries = this.jiraProperties.getInteger(PROPERTY_MAX_ENTRIES, Integer.valueOf(Integer.MAX_VALUE));
        return new DefaultVCacheCreationHandler(maxEntries.intValue(), Duration.ofSeconds(this.jiraProperties.getInteger(PROPERTY_MAX_TTL_IN_SEC, Integer.valueOf((int)DEFAULT_MAX_TTL)).intValue()), maxEntries.intValue(), ChangeRate.HIGH_CHANGE, ChangeRate.HIGH_CHANGE);
    }

    private static enum CacheType {
        LEGACY,
        REDIS,
        MEMCACHED;

    }

    private class JiraVCacheDefaultsProvider
    implements VCacheSettingsDefaultsProvider {
        private JiraVCacheDefaultsProvider() {
        }

        @Nonnull
        public ExternalCacheSettings getExternalDefaults(String name) {
            return new ExternalCacheSettingsBuilder().defaultTtl(DEFAULT_TTL_EXTERNAL_CACHE).dataChangeRateHint(ChangeRate.LOW_CHANGE).entryGrowthRateHint(ChangeRate.LOW_CHANGE).build();
        }

        @Nonnull
        public JvmCacheSettings getJvmDefaults(String name) {
            return new JvmCacheSettingsBuilder().defaultTtl(DEFAULT_TTL_JVM_CACHE).build();
        }
    }
}

