/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.serialcheck;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.serialcheck.SerializationCheckedCache;
import com.atlassian.jira.cache.serialcheck.SerializationCheckedCachedReference;
import com.atlassian.jira.cache.serialcheck.SerializationChecker;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SerializationCheckedCacheManager
implements CacheManager {
    private final CacheManager delegate;
    private final SerializationChecker checker;

    public SerializationCheckedCacheManager(CacheManager delegate, SerializationChecker checker) {
        this.delegate = delegate;
        this.checker = checker;
    }

    @Deprecated
    @Nonnull
    public Collection<Cache<?, ?>> getCaches() {
        return this.delegate.getCaches();
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        return this.delegate.getManagedCaches();
    }

    public void flushCaches() {
        this.delegate.flushCaches();
    }

    @Nullable
    public ManagedCache getManagedCache(@Nonnull String name) {
        return this.delegate.getManagedCache(name);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.delegate.getCachedReference(name, supplier);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        CachedReference ref = this.delegate.getCachedReference(name, supplier, cacheSettings);
        return SerializationCheckedCacheManager.isCheckRequired(cacheSettings) ? this.wrap(name, ref) : ref;
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier) {
        return this.delegate.getCachedReference(owningClass, name, supplier);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        CachedReference ref = this.delegate.getCachedReference(owningClass, name, supplier, cacheSettings);
        return SerializationCheckedCacheManager.isCheckRequired(cacheSettings) ? this.wrap(name, ref) : ref;
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name) {
        return this.delegate.getCache(name);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(Class<?> owningClass, String name) {
        return this.delegate.getCache(owningClass, name);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader) {
        return this.delegate.getCache(name, cacheLoader);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader, CacheSettings cacheSettings) {
        Cache<K, V> cache = this.delegate.getCache(name, cacheLoader, cacheSettings);
        return SerializationCheckedCacheManager.isCheckRequired(cacheSettings) ? this.wrap(cache) : cache;
    }

    @Deprecated
    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.delegate.getCache(name, keyClass, valueClass);
    }

    private <T> CachedReference<T> wrap(String name, CachedReference<T> delegate) {
        return new SerializationCheckedCachedReference<T>(this.checker, name, delegate);
    }

    private <K, V> Cache<K, V> wrap(Cache<K, V> delegate) {
        return new SerializationCheckedCache<K, V>(this.checker, delegate);
    }

    private static boolean isCheckRequired(CacheSettings settings) {
        if (Boolean.TRUE.equals(settings.getLocal())) {
            return false;
        }
        return Boolean.TRUE.equals(settings.getReplicateViaCopy());
    }
}

