/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.stats;

import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.TopNSerializableStatsWithFrequencies;
import com.atlassian.jira.util.stats.jira.NodeIdStats;
import java.util.concurrent.atomic.AtomicLong;

public interface CacheStats
extends ManagedStats {
    public void incrementClearCacheUsage(String var1);

    public static class MutableCacheStats
    implements CacheStats {
        private final NodeIdStats nodeId = new NodeIdStats();
        private final AtomicLong clearedCachesCount = new AtomicLong();
        private final TopNSerializableStatsWithFrequencies<String> topNClearedCaches = new TopNSerializableStatsWithFrequencies(200, 50, 128);

        public String getStatsName() {
            return "CacheStats";
        }

        @Override
        public void incrementClearCacheUsage(String cacheName) {
            this.topNClearedCaches.store((Object)cacheName);
            this.clearedCachesCount.incrementAndGet();
        }
    }
}

