/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.StackedBarChartGenerator;
import com.atlassian.jira.charts.jfreechart.TimePeriodUtils;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.charts.util.LuceneDateUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.DatePeriodStatisticsMapper;
import com.atlassian.jira.issue.statistics.util.FieldDocumentHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;

class RecentlyCreatedChart {
    private final SearchProvider searchProvider;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final TimeZoneManager timeZoneManager;

    public RecentlyCreatedChart(SearchProvider searchProvider, SearchService searchService, ApplicationProperties applicationProperties, TimeZoneManager timeZoneManager) {
        this.searchProvider = searchProvider;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.timeZoneManager = timeZoneManager;
    }

    public Chart generateChart(final ApplicationUser remoteUser, final SearchRequest searchRequest, int days, final ChartFactory.PeriodName periodName, int width, int height, boolean inline) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        days = DataUtils.normalizeDaysValue((int)days, (ChartFactory.PeriodName)periodName);
        try {
            final TimeZone userTimeZone = this.timeZoneManager.getLoggedInUserTimeZone();
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
            JqlClauseBuilder whereClauseBuilder = queryBuilder.where().defaultAnd();
            whereClauseBuilder.createdAfter("-" + days + "d");
            TreeMap<RegularTimePeriod, Number> createdResolved = new TreeMap<RegularTimePeriod, Number>();
            TreeMap<RegularTimePeriod, Number> createdUnresolved = new TreeMap<RegularTimePeriod, Number>();
            Class timePeriodClass = ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName);
            ResolutionSplittingCreatedIssuesHitCollector hitCollector = new ResolutionSplittingCreatedIssuesHitCollector(createdResolved, createdUnresolved, timePeriodClass, userTimeZone);
            this.searchProvider.search(SearchQuery.create((Query)whereClauseBuilder.buildQuery(), (ApplicationUser)remoteUser), (Collector)hitCollector);
            DataUtils.normaliseDateRangeCount(createdResolved, (int)(days - 1), (Class)timePeriodClass, (TimeZone)userTimeZone);
            DataUtils.normaliseMapKeys(createdResolved, createdUnresolved);
            final I18nBean i18nBean = new I18nBean(remoteUser);
            final Series createdUnresolvedSeries = new Series(i18nBean.getText("datacollector.createdunresolved"), createdUnresolved);
            final Series createdResolvedSeries = new Series(i18nBean.getText("datacollector.createdresolved"), createdResolved);
            CategoryDataset dataset = DataUtils.getCategoryDataset((List)Lists.newArrayList((Object[])new Map[]{createdUnresolvedSeries.data, createdResolvedSeries.data}), (String[])new String[]{createdUnresolvedSeries.name, createdResolvedSeries.name});
            ChartHelper helper = new StackedBarChartGenerator(dataset, i18nBean.getText("common.concepts.issues"), i18nBean).generateChart();
            JFreeChart chart = helper.getChart();
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
            renderer.setToolTipGenerator(new CategoryToolTipGenerator(){

                public String generateToolTip(CategoryDataset categoryDataset, int row, int col) {
                    String periodAsString = (String)((Object)categoryDataset.getColumnKey(col));
                    int resolved = (Integer)createdResolvedSeries.getValue(periodAsString);
                    int unresolved = (Integer)createdUnresolvedSeries.getValue(periodAsString);
                    int total = resolved + unresolved;
                    if (row == 0) {
                        return periodAsString + ": " + unresolved + " / " + total + " " + i18nBean.getText("datacollector.issuesunresolved") + ".";
                    }
                    if (row == 1) {
                        return periodAsString + ": " + resolved + " / " + total + " " + i18nBean.getText("datacollector.issuesresolved") + ".";
                    }
                    return "";
                }
            });
            final VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            CategoryURLGenerator urlGenerator = new CategoryURLGenerator(){

                public String generateURL(CategoryDataset categoryDataset, int row, int col) {
                    QueryImpl query;
                    String periodAsString = (String)((Object)categoryDataset.getColumnKey(col));
                    DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName), "created", userTimeZone);
                    SearchRequest searchUrlSuffix = createdMapper.getSearchUrlSuffix((Object)createdResolvedSeries.getTimePeriod(periodAsString), searchRequest);
                    if (row == 0) {
                        queryBuilder = JqlQueryBuilder.newBuilder((Query)searchUrlSuffix.getQuery());
                        queryBuilder.where().and().unresolved();
                        query = queryBuilder.buildQuery();
                    } else if (row == 1) {
                        queryBuilder = JqlQueryBuilder.newBuilder((Query)searchUrlSuffix.getQuery());
                        queryBuilder.where().and().not().unresolved();
                        query = queryBuilder.buildQuery();
                    } else {
                        query = searchUrlSuffix == null ? new QueryImpl() : searchUrlSuffix.getQuery();
                    }
                    RedundantClausesQueryOptimizer optimizer = new RedundantClausesQueryOptimizer();
                    query = optimizer.optimizeQuery((Query)query);
                    return velocityRequestContext.getCanonicalBaseUrl() + RecentlyCreatedChart.this.searchService.getIssueSearchPath(remoteUser, SearchService.IssueSearchParameters.builder().query((Query)query).build());
                }
            };
            renderer.setItemURLGenerator(urlGenerator);
            plot.setRenderer((CategoryItemRenderer)renderer);
            if (inline) {
                helper.generateInline(width, height);
            } else {
                helper.generate(width, height);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", dataset);
            params.put("completeDataset", dataset);
            params.put("completeDatasetUrlGenerator", urlGenerator);
            params.put("numIssues", DataUtils.getTotalNumber(createdResolved) + DataUtils.getTotalNumber(createdUnresolved));
            params.put("period", periodName.toString());
            params.put("imagemap", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            params.put("daysPrevious", days);
            params.put("width", width);
            params.put("height", height);
            if (inline) {
                String base64Image = ((ChartUtils)ComponentAccessor.getComponent(ChartUtils.class)).renderBase64Chart(helper.getImage(), "Recently Created Chart");
                params.put("base64Image", base64Image);
            }
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    static class ResolutionSplittingCreatedIssuesHitCollector
    extends FieldDocumentHitCollector {
        private final Map<RegularTimePeriod, Number> resolvedMap;
        private final Map<RegularTimePeriod, Number> unresolvedMap;
        private final Class timePeriodClass;
        private final TimeZone timeZone;
        private static final Set<String> fieldsToLoad = ImmutableSet.of((Object)"created", (Object)"resolution");

        public ResolutionSplittingCreatedIssuesHitCollector(Map<RegularTimePeriod, Number> resolvedMap, Map<RegularTimePeriod, Number> unresolvedMap, Class timePeriodClass, TimeZone timeZone) {
            this.resolvedMap = resolvedMap;
            this.unresolvedMap = unresolvedMap;
            this.timePeriodClass = timePeriodClass;
            this.timeZone = timeZone;
        }

        protected Set<String> getFieldsToLoad() {
            return fieldsToLoad;
        }

        public void collect(Document d) {
            boolean unresolved;
            Date creationDate = LuceneDateUtils.indexableFieldToDate(d.getField("created"));
            RegularTimePeriod period = RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)creationDate, (TimeZone)this.timeZone);
            String resolution = d.get("resolution");
            boolean bl = unresolved = resolution == null || "-1".equals(resolution);
            if (unresolved) {
                this.incrementMap(this.unresolvedMap, period);
            } else {
                this.incrementMap(this.resolvedMap, period);
            }
        }

        private void incrementMap(Map<RegularTimePeriod, Number> map, RegularTimePeriod key) {
            Number count = map.get(key);
            if (count == null) {
                count = 0;
            }
            map.put(key, count.intValue() + 1);
        }
    }

    class Series {
        final Map<String, Number> data;
        final Map<String, RegularTimePeriod> columnKeyToTimePeriod;
        final String name;

        Series(String name, Map<RegularTimePeriod, Number> data) {
            this.name = name;
            this.data = this.convertDomainAxisValues(data);
            this.columnKeyToTimePeriod = this.mapByAxisValue(data);
        }

        ImmutableMap<String, Number> convertDomainAxisValues(Map<RegularTimePeriod, Number> data) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Map.Entry<RegularTimePeriod, Number> entry : data.entrySet()) {
                result.put((Object)new TimePeriodUtils(RecentlyCreatedChart.this.timeZoneManager).prettyPrint((TimePeriod)entry.getKey()), (Object)entry.getValue());
            }
            return result.build();
        }

        ImmutableMap<String, RegularTimePeriod> mapByAxisValue(Map<RegularTimePeriod, Number> data) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Map.Entry<RegularTimePeriod, Number> entry : data.entrySet()) {
                result.put((Object)new TimePeriodUtils(RecentlyCreatedChart.this.timeZoneManager).prettyPrint((TimePeriod)entry.getKey()), (Object)entry.getKey());
            }
            return result.build();
        }

        public RegularTimePeriod getTimePeriod(String columnKey) {
            return this.columnKeyToTimePeriod.get(columnKey);
        }

        public Number getValue(String columnKey) {
            return this.data.get(columnKey);
        }
    }
}

