/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.io.SessionTempFile;
import com.atlassian.jira.io.TempFileFactory;
import com.atlassian.jira.util.PathTraversalException;
import com.atlassian.jira.util.PathUtils;
import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.servlet.DisplayChart;
import org.jfree.chart.servlet.ServletUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class DisplayChartServlet
implements Servlet {
    public static final Logger log = LoggerFactory.getLogger(DisplayChartServlet.class);
    private final Servlet displayChart = new DisplayChart();

    public void init(ServletConfig config) throws ServletException {
        this.displayChart.init(config);
    }

    public void destroy() {
        this.displayChart.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String filename = request.getParameter("filename");
        ChartUtils chartUtils = (ChartUtils)ComponentAccessor.getComponent(ChartUtils.class);
        File tmpDir = chartUtils.getChartDirectory();
        try {
            this.validateFileName(filename);
            File path = new File(tmpDir, filename);
            PathUtils.ensurePathInSecureDir((String)tmpDir.getAbsolutePath(), (String)path.getAbsolutePath());
            if (path.exists()) {
                try {
                    ServletUtilities.sendTempFile((File)path, (HttpServletResponse)((HttpServletResponse)response));
                    return;
                }
                finally {
                    FileUtils.deleteQuietly((File)path);
                    if (((HttpServletRequest)request).getSession(false) != null) {
                        this.unmarkAsTemporaryFile(filename);
                    }
                }
            }
            log.warn("File not found, returning 404 (filename='{}').", (Object)filename);
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage() + ", returning 404 (filename='{}').", (Object)filename);
        }
        catch (PathTraversalException e) {
            log.warn("Possible path traversal attempt, returning 404 (filename='{}').", (Object)filename);
        }
        catch (IOException e) {
            log.error("Error checking path, returning 404 (filename='{}').", (Object)filename);
        }
        ((HttpServletResponse)response).sendError(404);
    }

    private void validateFileName(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            throw new IllegalArgumentException("The file name is of the wrong format");
        }
        if (!filename.startsWith(ServletUtilities.getTempOneTimeFilePrefix())) {
            throw new IllegalArgumentException("The file name does not start with '" + ServletUtilities.getTempOneTimeFilePrefix() + "'");
        }
    }

    public ServletConfig getServletConfig() {
        return this.displayChart.getServletConfig();
    }

    public String getServletInfo() {
        return this.displayChart.getServletInfo();
    }

    private void unmarkAsTemporaryFile(String filename) {
        TempFileFactory tempFileFactory = (TempFileFactory)ComponentAccessor.getComponent(TempFileFactory.class);
        if (tempFileFactory == null) {
            return;
        }
        SessionTempFile sessionTempFile = tempFileFactory.getSessionTempFile(filename);
        if (sessionTempFile != null && !sessionTempFile.getFile().exists()) {
            sessionTempFile.unbind();
        }
    }
}

