/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.event.ClearCacheEvent;
import com.google.common.collect.Maps;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class ClusterNodePropertiesImpl
implements ClusterNodeProperties {
    private static final Logger log = LoggerFactory.getLogger(ClusterNodePropertiesImpl.class);
    public static final String JIRA_CLUSTER_CONFIG_PROPERTIES = "cluster.properties";
    public static final String JIRA_SHARED_HOME = "jira.shared.home";
    public static final String JIRA_NODE_ID = "jira.node.id";
    private final JiraHome jiraHome;
    @ClusterSafe(value="This is a reference to the holder for the local cluster.properties")
    private final ResettableLazyReference<Map<String, String>> clusterPropertiesRef = new ResettableLazyReference<Map<String, String>>(){

        protected Map<String, String> create() {
            return Maps.fromProperties((Properties)this.loadProperties());
        }

        private Properties loadProperties() {
            Properties properties = new Properties();
            File clusterPropertiesFile = ClusterNodePropertiesImpl.this.getClusterPropertiesFile();
            if (clusterPropertiesFile.exists()) {
                try (InputStream in = Files.newInputStream(clusterPropertiesFile.toPath(), new OpenOption[0]);){
                    properties.load(in);
                }
                catch (IOException e) {
                    log.warn("Could not load config properties from '{}'.", (Object)clusterPropertiesFile);
                }
            }
            return properties;
        }
    };

    public ClusterNodePropertiesImpl(JiraHome jiraHome) {
        this.jiraHome = Objects.requireNonNull(jiraHome);
    }

    private File getClusterPropertiesFile() {
        return new File(this.jiraHome.getLocalHomePath(), JIRA_CLUSTER_CONFIG_PROPERTIES);
    }

    @Override
    @Nullable
    public String getProperty(String property) {
        return (String)((Map)this.clusterPropertiesRef.get()).get(property);
    }

    @Override
    public Optional<String> getPropertySafely(String key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    @Override
    public String getSharedHome() {
        return this.getProperty(JIRA_SHARED_HOME);
    }

    @Override
    public String getNodeId() {
        return this.getProperty(JIRA_NODE_ID);
    }

    @Override
    public void refresh() {
        this.clusterPropertiesRef.reset();
    }

    @Override
    public boolean propertyFileExists() {
        return this.getClusterPropertiesFile().exists();
    }

    @Override
    public boolean isValid() {
        return this.propertyFileExists() && this.allRequiredPropertiesExist();
    }

    private boolean allRequiredPropertiesExist() {
        Map properties = (Map)this.clusterPropertiesRef.get();
        return StringUtils.isNotBlank((CharSequence)((CharSequence)properties.get(JIRA_SHARED_HOME))) && StringUtils.isNotBlank((CharSequence)((CharSequence)properties.get(JIRA_NODE_ID)));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }
}

