/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.CuttingOffExecutor;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.analytics.JiraCacheReplicationResumedAnalyticsEvent;
import com.atlassian.jira.cluster.analytics.JiraCacheReplicationStoppedAnalyticsEvent;
import com.atlassian.jira.event.cluster.CacheReplicationResumedEvent;
import com.atlassian.jira.event.cluster.CacheReplicationStoppedEvent;
import com.google.common.base.Stopwatch;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CuttingOffExecutorImpl
implements CuttingOffExecutor {
    private static final int FIVE_MINUTES = 300000;
    private static final Logger log = LoggerFactory.getLogger(CuttingOffExecutorImpl.class);
    private volatile int failures = 0;
    private volatile long lastFailureTime = 0L;
    private volatile boolean isRetrying = false;
    private final Object lock = new Object();
    private final Clock clock;
    private final Node node;
    private final EventPublisher eventPublisher;
    private final ClusterManager clusterManager;
    private final Stopwatch stopwatch;

    public CuttingOffExecutorImpl(Clock clock, Node node, EventPublisher eventPublisher, ClusterManager clusterManager) {
        this.clock = clock;
        this.node = node;
        this.eventPublisher = eventPublisher;
        this.clusterManager = clusterManager;
        this.stopwatch = Stopwatch.createUnstarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <T> Optional<T> invokeOrCutOff(@Nonnull CuttingOffExecutor.Invoke<T> invoke) {
        int currentNumberOfFailures;
        boolean shouldRetry;
        if (this.failures == 0) {
            log.debug("Replicating to node {}.", (Object)this.node.getNodeId());
            return Optional.of(invoke.invoke(new CuttingOffExecutor.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void registerFailure() {
                    boolean cutOffNode = false;
                    if (CuttingOffExecutorImpl.this.failures == 0) {
                        Object object = CuttingOffExecutorImpl.this.lock;
                        synchronized (object) {
                            if (CuttingOffExecutorImpl.this.failures == 0) {
                                cutOffNode = true;
                                ++CuttingOffExecutorImpl.this.failures;
                                CuttingOffExecutorImpl.this.lastFailureTime = CuttingOffExecutorImpl.this.clock.millis();
                                CuttingOffExecutorImpl.this.stopwatch.reset().start();
                            }
                        }
                    }
                    CuttingOffExecutorImpl.this.handleNodeCutOff(cutOffNode);
                }

                @Override
                public void registerSuccess() {
                    log.debug("Ignoring success and doing nothing as we are not retrying");
                }
            }));
        }
        if (!this.shouldRetry()) {
            this.handleNodeCutOff();
            return Optional.empty();
        }
        Optional<T> optional = this.lock;
        synchronized (optional) {
            shouldRetry = this.shouldRetry();
            if (shouldRetry) {
                this.isRetrying = true;
                currentNumberOfFailures = this.failures;
            } else {
                currentNumberOfFailures = -1;
            }
        }
        if (shouldRetry) {
            try {
                log.info("Retrying replication to node " + this.node.getNodeId() + ". This is " + this.failures + " attempt.");
                optional = Optional.of(invoke.invoke(new CuttingOffExecutor.Callback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void registerFailure() {
                        boolean ignore;
                        Object object = CuttingOffExecutorImpl.this.lock;
                        synchronized (object) {
                            if (currentNumberOfFailures == CuttingOffExecutorImpl.this.failures) {
                                ++CuttingOffExecutorImpl.this.failures;
                                CuttingOffExecutorImpl.this.lastFailureTime = CuttingOffExecutorImpl.this.clock.millis();
                                ignore = false;
                            } else {
                                ignore = true;
                            }
                        }
                        if (ignore) {
                            log.debug("Ignoring result of duplicated " + currentNumberOfFailures + " attempt.");
                        } else {
                            CuttingOffExecutorImpl.this.handleNodeStillOffline(currentNumberOfFailures);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void registerSuccess() {
                        boolean ignore;
                        long cutOffDuration = -1L;
                        Object object = CuttingOffExecutorImpl.this.lock;
                        synchronized (object) {
                            if (currentNumberOfFailures == CuttingOffExecutorImpl.this.failures) {
                                CuttingOffExecutorImpl.this.failures = 0;
                                ignore = false;
                                cutOffDuration = CuttingOffExecutorImpl.this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
                                CuttingOffExecutorImpl.this.stopwatch.reset();
                            } else {
                                ignore = true;
                            }
                        }
                        if (ignore) {
                            log.debug("Ignoring result of duplicated " + currentNumberOfFailures + " attempt.");
                        } else {
                            CuttingOffExecutorImpl.this.handleNodeBackOnline(currentNumberOfFailures, cutOffDuration);
                        }
                    }
                }));
                return optional;
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.isRetrying = false;
                }
            }
        }
        this.handleNodeCutOff();
        return Optional.empty();
    }

    private void handleNodeCutOff() {
        log.debug("Node {} is currently being cut off because of {} failed communication attempt(s).", (Object)this.node.getNodeId(), (Object)this.failures);
    }

    private void handleNodeStillOffline(int attemptNumber) {
        log.warn("Retry replication to node " + this.node.getNodeId() + " failed, node still unreachable. This was " + attemptNumber + " attempt. Backing off for " + this.computeBackoffPeriod(attemptNumber + 1) + " milliseconds.");
    }

    private void handleNodeBackOnline(int numberOfRetries, long cutOffDuration) {
        String sourceNodeId = this.clusterManager.getNodeId();
        String destinationNodeId = this.node.getNodeId();
        log.info("Restoring cache replication to node " + destinationNodeId + ". Node back online after " + numberOfRetries + " retries, time elapsed in cutOff mode:." + cutOffDuration + " milliseconds.");
        this.publishReplicationResumedEvents(sourceNodeId, destinationNodeId, cutOffDuration);
    }

    private void handleNodeCutOff(boolean cutOffNode) {
        String sourceNodeId = this.clusterManager.getNodeId();
        String destinationNodeId = this.node.getNodeId();
        if (cutOffNode) {
            log.warn("Stopping cache replication to node " + destinationNodeId + ". Node is unreachable. Will retry after " + this.computeBackoffPeriod(1) + " milliseconds.");
            this.publishReplicationStoppedEvents(sourceNodeId, destinationNodeId);
        } else {
            log.debug("Ignoring failure as node is already cut off and we were not doing retry.");
        }
    }

    private boolean shouldRetry() {
        long timeSinceLastFailure = this.clock.millis() - this.lastFailureTime;
        return timeSinceLastFailure >= this.computeBackoffPeriod(this.failures) && !this.isRetrying;
    }

    private long computeBackoffPeriod(int attempts) {
        return (long)Math.min(Math.pow(2.0, attempts) * 1000.0, 300000.0);
    }

    private void publishReplicationResumedEvents(String sourceNodeId, String destinationNodeId, long cutOffDuration) {
        this.eventPublisher.publish((Object)new CacheReplicationResumedEvent(destinationNodeId));
        this.eventPublisher.publish((Object)new JiraCacheReplicationResumedAnalyticsEvent(sourceNodeId, destinationNodeId, cutOffDuration));
    }

    private void publishReplicationStoppedEvents(String sourceNodeId, String destinationNodeId) {
        this.eventPublisher.publish((Object)new CacheReplicationStoppedEvent(destinationNodeId));
        this.eventPublisher.publish((Object)new JiraCacheReplicationStoppedAnalyticsEvent(sourceNodeId, destinationNodeId));
    }
}

