/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStartIndexStats;
import com.atlassian.jira.cluster.NodeStatus;
import com.atlassian.jira.cluster.cache.NodeCutOffManager;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartbeatService;
import com.atlassian.jira.cluster.service.NodeTimeHelper;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.health.DefaultHealthCheckExecutor;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.index.IndexFetcher;
import com.atlassian.jira.index.ha.DefaultIndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexSnapshotCreationResult;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.index.IndexConsistencyUtils;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.upgrade.tasks.AbstractReindexUpgradeTask;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.stats.ForcePrintUtil;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.atlassian.upgrade.spi.UpgradeTaskFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterManager
implements ClusterManager,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterManager.class);
    @VisibleForTesting
    static final String REBUILD_LOCAL_INDEX_SYSTEM_PROPERTY = "com.atlassian.jira.startup.rebuild.local.index";
    private static final boolean REBUILD_LOCAL_INDEX_DEFAULT_VALUE = true;
    @VisibleForTesting
    static final String PICK_SNAPSHOT_FROM_SHARED_SYSTEM_PROPERTY = "com.atlassian.jira.startup.pick.indexsnapshot.from.shared";
    private static final boolean PICK_SNAPSHOT_FROM_SHARED_DEFAULT_VALUE = true;
    @VisibleForTesting
    static final String REQUEST_INDEX_SNAPSHOT_FROM_ANOTHER_NODE_SYSTEM_PROPERTY = "com.atlassian.jira.startup.request.indexsnapshot.from.another.node";
    private static final boolean REQUEST_INDEX_SNAPSHOT_FROM_ANOTHER_NODE_DEFAULT_VALUE = false;
    @VisibleForTesting
    static final String ALLOW_FULL_REINDEX_SYSTEM_PROPERTY = "com.atlassian.jira.startup.allow.full.reindex";
    private static final boolean ALLOW_FULL_REINDEX_DEFAULT_VALUE = true;
    @VisibleForTesting
    static final String ENSURE_SNAPSHOT_EXIST_PROPERTY = "com.atlassian.jira.startup.ensure.snapshot.exist";
    private static final boolean ENSURE_SNAPSHOT_EXIST_DEFAULT_VALUE = true;
    private final ClusterNodes clusterNodes;
    private final EventPublisher eventPublisher;
    private final MessageHandlerService messageHandlerService;
    private final NodeCutOffManager nodeCutOffManager;
    private final JiraProperties jiraProperties;
    private final UpgradeTaskFactory upgradeTaskFactory;
    private final BuildUtilsInfo buildUtilsInfo;
    private volatile Collection<Node> liveNodes;
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<ClusterNodeHeartbeatService> heartbeatServiceRef = ComponentAccessor.getComponentReference(ClusterNodeHeartbeatService.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<NodeReindexService> nodeReindexServiceRef = ComponentAccessor.getComponentReference(NodeReindexService.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<IndexFetcher> indexFetcher = ComponentAccessor.getComponentReference(IndexFetcher.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<ReindexRequestManager> reindexRequestManagerRef = ComponentAccessor.getComponentReference(ReindexRequestManager.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<IndexSnapshotOperator> indexSnapshotOperatorRef = ComponentAccessor.getComponentReference(IndexSnapshotOperator.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<IndexRecoveryManager> indexRecoveryManager = ComponentAccessor.getComponentReference(IndexRecoveryManager.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<IssueIndexManager> indexManager = ComponentAccessor.getComponentReference(IssueIndexManager.class);
    private final NodeStartIndexStats nodeStartStats;

    public DefaultClusterManager(ClusterNodes clusterNodes, EventPublisher eventPublisher, MessageHandlerService messageHandlerService, NodeCutOffManager nodeCutOffManager, JiraProperties jiraProperties, UpgradeTaskFactory upgradeTaskFactory, BuildUtilsInfo buildUtilsInfo) {
        this.clusterNodes = clusterNodes;
        this.eventPublisher = eventPublisher;
        this.messageHandlerService = messageHandlerService;
        this.nodeCutOffManager = nodeCutOffManager;
        this.jiraProperties = jiraProperties;
        this.nodeStartStats = (NodeStartIndexStats)JiraStats.create(NodeStartIndexStats.class, NodeStartIndexStats::create, (boolean)true);
        this.upgradeTaskFactory = upgradeTaskFactory;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public void start() {
        this.eventPublisher.register((Object)this);
    }

    @Nullable
    public String getNodeId() {
        return this.clusterNodes.current().getNodeId();
    }

    public boolean isClustered() {
        return this.clusterNodes.current().isClustered();
    }

    @Override
    public Set<Node> getAllNodes() {
        return this.isClustered() ? this.clusterNodes.all() : ImmutableSet.of();
    }

    @Override
    public Set<NodeStatus> getAllNodeStatuses() {
        this.refreshLiveNodes();
        return this.getAllNodes().stream().map(node -> new NodeStatus(node.getNodeId(), node.getState(), this.scanIsNodeAlive((Node)node), ((ClusterNodeHeartbeatService)this.heartbeatServiceRef.get()).getLastHeartbeatTime(node.getNodeId()))).collect(Collectors.toSet());
    }

    @Override
    public boolean isActive() {
        return this.clusterNodes.current().getState().equals((Object)Node.NodeState.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIndexOnStart() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            boolean indexReadyByLocalRebuildOrIndexSnapshot;
            this.nodeStartStats.indexOnStartConfiguration(this.systemPropertyAllowsToRebuildLocalIndex(false), this.systemPropertyAllowsToPickSnapshotFromSharedHome(false), this.systemPropertyAllowsToRequestIndexSnapshotFromAnotherNode(false), this.systemPropertyAllowsToTriggerFullReindex(false), this.systemPropertyAllowsToEnsureSnapshotExist(false));
            if (this.skipBecausePendingUpgradeReindex()) {
                return;
            }
            boolean bl = indexReadyByLocalRebuildOrIndexSnapshot = this.systemPropertyAllowsToRebuildLocalIndex(true) && this.rebuildLocalIndex() || this.systemPropertyAllowsToPickSnapshotFromSharedHome(true) && this.pickIndexSnapshotFromSharedHome();
            boolean indexReadyByRequestingFromOtherNode = !indexReadyByLocalRebuildOrIndexSnapshot ? this.systemPropertyAllowsToRequestIndexSnapshotFromAnotherNode(true) && this.requestIndexSnapshotFromAnotherNode() : false;
            boolean indexReadyByFullReindex = !indexReadyByLocalRebuildOrIndexSnapshot && !indexReadyByRequestingFromOtherNode ? this.systemPropertyAllowsToTriggerFullReindex(true) && this.performFullForegroundReindex() : false;
            if (indexReadyByLocalRebuildOrIndexSnapshot || indexReadyByFullReindex) {
                log.info("Local index is healthy. Jira can proceed with the start procedure.");
                ((NodeReindexService)this.nodeReindexServiceRef.get()).start();
                if (this.systemPropertyAllowsToEnsureSnapshotExist(true)) {
                    this.ensureFreshIndexSnapshot();
                }
            } else if (indexReadyByRequestingFromOtherNode) {
                log.info("Local index has been requested asynchronously from another node.");
            } else {
                log.error("Failed to prepare local index. Jira is in an unhealthy state.");
                this.nodeStartStats.checkIndexOnStart(false, stopwatch.elapsed(TimeUnit.SECONDS));
                ((NodeReindexService)this.nodeReindexServiceRef.get()).pause();
                this.handleFailedGettingIndexOnStart();
            }
            if (indexReadyByLocalRebuildOrIndexSnapshot || indexReadyByRequestingFromOtherNode || indexReadyByFullReindex) {
                this.nodeStartStats.checkIndexOnStart(true, stopwatch.elapsed(TimeUnit.SECONDS));
            }
        }
        finally {
            log.info("Done checkIndexOnStart in: {}", (Object)stopwatch.elapsed());
            ForcePrintUtil.forcePrintAndResetInCurrentThread((ManagedStats)this.nodeStartStats);
        }
    }

    private boolean skipBecausePendingUpgradeReindex() {
        Collection<UpgradeTask> upgradeTaskTriggeringFullReindex = this.upgradeTasksTriggeringFullReindex();
        if (!upgradeTaskTriggeringFullReindex.isEmpty()) {
            log.info("Current node: {}. Not performing index startup flow because there are upgrade tasks triggering full reindex: {}. Current list of other nodes: {}.", new Object[]{this.getCurrentNode(), upgradeTaskTriggeringFullReindex.stream().map(task -> task.getClass().getSimpleName()).collect(Collectors.toList()), this.getAllOtherNodes(this.getCurrentNode())});
            return true;
        }
        return false;
    }

    private Collection<UpgradeTask> upgradeTasksTriggeringFullReindex() {
        return this.upgradeTaskFactory.getAllUpgradeTasks().stream().filter(this::isPending).filter(this::isUpgradeTriggeringFullReindex).collect(Collectors.toList());
    }

    private boolean isPending(UpgradeTask upgradeTask) {
        return upgradeTask.getBuildNumber() > this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    private boolean isUpgradeTriggeringFullReindex(UpgradeTask task) {
        if (task instanceof AbstractReindexUpgradeTask) {
            AbstractReindexUpgradeTask abstractReindexUpgradeTask = (AbstractReindexUpgradeTask)task;
            return abstractReindexUpgradeTask.triggersFullReindex();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFreshIndexSnapshot() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean snapshotExists = false;
        boolean snapshotCreated = false;
        try {
            log.info("Current node: {}. Ensuring that a fresh enough index snapshot exists. ", (Object)this.getCurrentNode());
            if (((IndexFetcher)this.indexFetcher.get()).indexSnapshotExistsAndIsFreshEnough()) {
                snapshotExists = true;
                log.info("Current node: {}. A fresh snapshot already exists. ", (Object)this.getCurrentNode());
            } else {
                snapshotCreated = this.tryToCreateSnapshot();
            }
        }
        catch (IndexException e) {
            log.error("Current node: {}. Error while checking index snapshot. ", (Object)this.getCurrentNode(), (Object)e);
        }
        finally {
            this.nodeStartStats.ensureFreshIndexSnapshot(snapshotExists, snapshotCreated, stopwatch.elapsed(TimeUnit.SECONDS));
        }
    }

    private boolean tryToCreateSnapshot() throws IndexException {
        log.info("Current node: {}. An index snapshot does not exist, or is not fresh. Creating a fresh index snapshot. ", (Object)this.getCurrentNode());
        IndexSnapshotCreationResult indexSnapshotResult = ((IndexSnapshotOperator)this.indexSnapshotOperatorRef.get()).tryCreateSnapshot();
        if (indexSnapshotResult.getStatus() == IndexSnapshotCreationResult.Status.SUCCESS) {
            log.info("Current node: {}. Created index snapshot at {}. ", (Object)this.getCurrentNode(), (Object)indexSnapshotResult.getSnapshotName());
        } else if (indexSnapshotResult.getStatus() == IndexSnapshotCreationResult.Status.ERROR) {
            log.error("Current node: {}. Failed creating an index snapshot. ", (Object)this.getCurrentNode());
        } else if (indexSnapshotResult.getStatus() == IndexSnapshotCreationResult.Status.BLOCKED) {
            log.info("Current node: {}. No need to create snapshot. Snapshot created by another node.", (Object)this.getCurrentNode());
        } else {
            log.error("Current node: {}. Unexpected snapshot creation status: {}.", (Object)this.getCurrentNode(), (Object)indexSnapshotResult.getStatus());
            throw new IndexException("Snapshot creation at startup ended in an unexpected state: " + indexSnapshotResult.getStatus());
        }
        return indexSnapshotResult.getStatus() == IndexSnapshotCreationResult.Status.SUCCESS;
    }

    private void handleFailedGettingIndexOnStart() {
        URL kbUrl;
        log.info("Failed to get index on this node. Blocking the start of this instance.");
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("Jira needs to have a valid search index after starting. "), HealthCheckMessageFormatter.string("During the node startup, all of the following steps failed to pass: "));
        messageFormatter.appendList(HealthCheckMessageFormatter.string("Re-index missing data if a local issue index is less than " + IndexConsistencyUtils.getIndexConsistencyTolerancePercentage() + "% behind the database."), HealthCheckMessageFormatter.string("Check if Jira shared-home directory contains a recent index snapshot."), HealthCheckMessageFormatter.string("Trigger a full re-index."));
        messageFormatter.append(HealthCheckMessageFormatter.tag("B", HealthCheckMessageFormatter.string("You need to fix this issue manually. Do not start other nodes until the indexing problem is resolved. ")));
        Event event = new Event(JohnsonEventType.NO_INDEX.eventType(), "We could not find a valid search index on the current node", messageFormatter.toHtml(), EventLevels.warning());
        event.addAttribute((Object)"dismissible", (Object)true);
        event.addAttribute((Object)"blocking-start", (Object)true);
        try {
            kbUrl = new URL("https://confluence.atlassian.com/jirakb/failed-getting-index-on-start-1141970837.html");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        DefaultHealthCheckExecutor.addEventAttributes(event, JohnsonEventType.NO_INDEX.eventType().getType(), JohnsonEventType.NO_INDEX.eventType().getType(), Optional.of(kbUrl));
        JohnsonProvider johnsonProvider = (JohnsonProvider)ComponentAccessor.getComponent(JohnsonProvider.class);
        johnsonProvider.getContainer().addEvent(event);
    }

    private String getCurrentNode() {
        return this.clusterNodes.current().getNodeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rebuildLocalIndex() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean indexSuccessfullyRebuilt = false;
        try {
            if (((NodeReindexService)this.nodeReindexServiceRef.get()).hasPendingReindexOperations()) {
                log.info("Current node: {}. Rebuilding local index will be skipped, because replicated index operation table contains a pending full reindex end or project reindex operation.", (Object)this.getNodeId());
                if (!((IndexFetcher)this.indexFetcher.get()).indexSnapshotExistsAndIsFreshEnough()) {
                    log.error("Current node: {}. Cluster is not in a healthy state. Attempt to pick an index snapshot from shared home will fail as there are no snapshots or they aren't fresh enough. A fresh snapshot is required after full reindex operation. Verify why there is no fresh snapshot in shared home and ensure there is one. Otherwise each new node will fall back to full reindex at startup.", (Object)this.getNodeId());
                }
                boolean bl = false;
                return bl;
            }
            if (!((NodeReindexService)this.nodeReindexServiceRef.get()).canIndexBeRebuilt()) {
                log.info("Current node: {}. Rebuilding local index will be skipped, because replicated index operation is missing necessary data. This is likely to happen after system restore.", (Object)this.getNodeId());
                boolean bl = false;
                return bl;
            }
            if (!((IssueIndexManager)this.indexManager.get()).isIndexConsistent()) {
                log.info("Current node: {}. Rebuilding local index will be skipped, because it is missing more than {}% of issues.", (Object)this.getNodeId(), (Object)IndexConsistencyUtils.getIndexConsistencyTolerancePercentage());
                boolean bl = false;
                return bl;
            }
            Instant latestIndexDate = ((IssueIndexManager)this.indexManager.get()).getLatestIndexDate();
            if (latestIndexDate != null) {
                Duration periodToReindex = Duration.between(latestIndexDate, Instant.now()).plusDays(1L);
                log.info("Current node: {}. Re-indexing issues updated in the last {}. (Note: it's an intentionally wider range)", (Object)this.getNodeId(), (Object)DefaultIndexRecoveryManager.readableDuration(periodToReindex));
                ((NodeReindexService)this.nodeReindexServiceRef.get()).resetIndexCount();
                ((IndexRecoveryManager)this.indexRecoveryManager.get()).reindexWithVersionCheckEntitiesUpdatedInTheLast(periodToReindex, (taskProgress, currentSubTask, message) -> log.info("[INDEX-FIXER] {}", (Object)message));
                indexSuccessfullyRebuilt = true;
                log.info("Current node: {}. Finished rebuilding the local index using database.", (Object)this.getNodeId());
            } else {
                log.error("Current node: {}. Unable to get latest issue index update time.", (Object)this.getNodeId());
            }
        }
        catch (Exception exception) {
            log.error("Current node: {}. There was an error while trying to rebuild local index.", (Object)this.getNodeId(), (Object)exception);
        }
        finally {
            this.nodeStartStats.getIndexByRebuildLocalIndex(indexSuccessfullyRebuilt, stopwatch.elapsed(TimeUnit.SECONDS));
        }
        return indexSuccessfullyRebuilt;
    }

    private boolean pickIndexSnapshotFromSharedHome() {
        Preconditions.checkState((boolean)((NodeReindexService)this.nodeReindexServiceRef.get()).isPaused(), (String)"%s should not have started yet", (Object)NodeReindexService.class.getSimpleName());
        Stopwatch stopwatch = Stopwatch.createStarted();
        String currentNodeId = this.getCurrentNode();
        Set<String> allOtherNodeIds = this.getAllOtherNodes(currentNodeId);
        try {
            if (((IndexFetcher)this.indexFetcher.get()).indexSnapshotExistsAndIsFreshEnough()) {
                log.info("Current node: {}. Attempting to fetch an index snapshot from shared home.", (Object)currentNodeId);
                ((NodeReindexService)this.nodeReindexServiceRef.get()).resetIndexCount();
                String snaphotName = ((IndexFetcher)this.indexFetcher.get()).recoverIndexFromMostRecentSnapshot();
                log.info("Current node: {}. Done recovering indexes from the snapshot found in shared home.", (Object)currentNodeId);
                this.nodeStartStats.getIndexByPickIndexSnapshotFromSharedHome(snaphotName, stopwatch.elapsed(TimeUnit.SECONDS));
                return true;
            }
            log.info("Current node: {}. We couldn't find any snapshots or they weren't fresh enough. Current list of other nodes: {}", (Object)currentNodeId, allOtherNodeIds);
        }
        catch (Exception e) {
            log.error("Current node: {}. Couldn't recover index even though it had been found in shared. Current list of other nodes: {}", new Object[]{currentNodeId, allOtherNodeIds, e});
        }
        this.nodeStartStats.getIndexByPickIndexSnapshotFromSharedHome(null, stopwatch.elapsed(TimeUnit.SECONDS));
        return false;
    }

    private Set<String> getAllOtherNodes(String currentNode) {
        return this.clusterNodes.all().stream().filter(Node::isClustered).map(Node::getNodeId).filter(Objects::nonNull).filter(nodeId -> !nodeId.equals(currentNode)).collect(Collectors.toSet());
    }

    private boolean systemPropertyAllowsToRebuildLocalIndex(boolean shouldLog) {
        boolean canLocalIndexBeRebuilt;
        String canLocalIndexBeRebuiltProperty = this.jiraProperties.getProperty(REBUILD_LOCAL_INDEX_SYSTEM_PROPERTY);
        if (canLocalIndexBeRebuiltProperty == null) {
            canLocalIndexBeRebuilt = true;
            if (shouldLog) {
                log.info("Current node: {}. {} attempt to rebuild its local index using conditional catch up. System property {} is not defined, and it will default to {}. You can {} rebuilding the local index by setting this property to \"{}\".", new Object[]{this.getNodeId(), canLocalIndexBeRebuilt ? "Will" : "Will not", REBUILD_LOCAL_INDEX_SYSTEM_PROPERTY, true, canLocalIndexBeRebuilt ? "disable" : "enable", false});
            }
        } else {
            canLocalIndexBeRebuilt = Boolean.parseBoolean(canLocalIndexBeRebuiltProperty);
            if (shouldLog) {
                log.info("Current node: {}. {} attempt to rebuild its local index using conditional catch up, because system property {} is set to {}.", new Object[]{this.getNodeId(), canLocalIndexBeRebuilt ? "Will" : "Will not", REBUILD_LOCAL_INDEX_SYSTEM_PROPERTY, canLocalIndexBeRebuilt});
            }
        }
        return canLocalIndexBeRebuilt;
    }

    private boolean systemPropertyAllowsToRequestIndexSnapshotFromAnotherNode(boolean shouldLog) {
        boolean canRequestIndexSnapshotFromAnotherNode;
        String canRequestIndexSnapshotFromAnotherNodeProperty = this.jiraProperties.getProperty(REQUEST_INDEX_SNAPSHOT_FROM_ANOTHER_NODE_SYSTEM_PROPERTY);
        if (canRequestIndexSnapshotFromAnotherNodeProperty == null) {
            canRequestIndexSnapshotFromAnotherNode = false;
        } else {
            canRequestIndexSnapshotFromAnotherNode = Boolean.parseBoolean(canRequestIndexSnapshotFromAnotherNodeProperty);
            if (shouldLog && canRequestIndexSnapshotFromAnotherNode) {
                log.warn("Current node: {}. Will request an index snapshot from another node, because system property {} is set to true.", (Object)this.getNodeId(), (Object)REQUEST_INDEX_SNAPSHOT_FROM_ANOTHER_NODE_SYSTEM_PROPERTY);
            }
        }
        return canRequestIndexSnapshotFromAnotherNode;
    }

    private boolean systemPropertyAllowsToPickSnapshotFromSharedHome(boolean shouldLog) {
        boolean canPickSnapshotFromShared;
        String canPickSnapshotFromSharedProperty = this.jiraProperties.getProperty(PICK_SNAPSHOT_FROM_SHARED_SYSTEM_PROPERTY);
        if (canPickSnapshotFromSharedProperty == null) {
            canPickSnapshotFromShared = true;
            if (shouldLog) {
                log.info("Current node: {}. {} attempt to pick an index snapshot from shared home. System property {} is not defined, and it will default to {}. You can {} searching for index snapshot in shared home by setting this property to \"{}\".", new Object[]{this.getNodeId(), canPickSnapshotFromShared ? "Will" : "Will not", PICK_SNAPSHOT_FROM_SHARED_SYSTEM_PROPERTY, true, canPickSnapshotFromShared ? "disable" : "enable", false});
            }
        } else {
            canPickSnapshotFromShared = Boolean.parseBoolean(canPickSnapshotFromSharedProperty);
            if (shouldLog) {
                log.info("Current node: {}. {} attempt to pick an index snapshot from shared home, because system property {} is set to {}.", new Object[]{this.getNodeId(), canPickSnapshotFromShared ? "Will" : "Will not", PICK_SNAPSHOT_FROM_SHARED_SYSTEM_PROPERTY, canPickSnapshotFromShared});
            }
        }
        return canPickSnapshotFromShared;
    }

    private boolean systemPropertyAllowsToTriggerFullReindex(boolean shouldLog) {
        boolean canTriggerFullReindex;
        String canTriggerFullReindexProperty = this.jiraProperties.getProperty(ALLOW_FULL_REINDEX_SYSTEM_PROPERTY);
        if (canTriggerFullReindexProperty == null) {
            canTriggerFullReindex = true;
            if (shouldLog) {
                log.info("Current node: {}. {} trigger full foreground reindex. System property {} is not defined, and it will default to {}. You can {} triggering full foreground reindex by setting this property to \"{}\".", new Object[]{this.getNodeId(), canTriggerFullReindex ? "Will" : "Will not", ALLOW_FULL_REINDEX_SYSTEM_PROPERTY, true, canTriggerFullReindex ? "disable" : "enable", false});
            }
        } else {
            canTriggerFullReindex = Boolean.parseBoolean(canTriggerFullReindexProperty);
            if (shouldLog) {
                log.info("Current node: {}. {} trigger full foreground reindex, because system property {} is set to {}.", new Object[]{this.getNodeId(), canTriggerFullReindex ? "Will" : "Will not", ALLOW_FULL_REINDEX_SYSTEM_PROPERTY, canTriggerFullReindex});
            }
        }
        return canTriggerFullReindex;
    }

    private boolean systemPropertyAllowsToEnsureSnapshotExist(boolean shouldLog) {
        boolean shouldEnsureSnapshotExist;
        String shouldEnsureSnapshotExistProperty = this.jiraProperties.getProperty(ENSURE_SNAPSHOT_EXIST_PROPERTY);
        if (shouldEnsureSnapshotExistProperty == null) {
            shouldEnsureSnapshotExist = true;
            if (shouldLog) {
                log.info("Current node: {}. {} ensure fresh index snapshot exist. System property {} is not defined, and it will be default to {}. You can {} ensuring index snapshot exist by setting this property to {}.", new Object[]{this.getNodeId(), shouldEnsureSnapshotExist ? "Will" : "Will not", ENSURE_SNAPSHOT_EXIST_PROPERTY, true, shouldEnsureSnapshotExist ? "disable" : "enable", false});
            }
        } else {
            shouldEnsureSnapshotExist = Boolean.parseBoolean(shouldEnsureSnapshotExistProperty);
            if (shouldLog) {
                log.info("Current node: {}. {} ensure fresh index snapshot exist, because system property {} is set to {}.", new Object[]{this.getNodeId(), shouldEnsureSnapshotExist ? "Will" : "Will not", ENSURE_SNAPSHOT_EXIST_PROPERTY, shouldEnsureSnapshotExist});
            }
        }
        return shouldEnsureSnapshotExist;
    }

    private boolean requestIndexSnapshotFromAnotherNode() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            String currentNode = this.getCurrentNode();
            Set<String> allOtherNodes = this.getAllOtherNodes(currentNode);
            log.info("Current node: {}. Requesting an index from a random node. Current list of other nodes: {}", (Object)currentNode, allOtherNodes);
            this.requestCurrentIndexFromNode("ANY");
            this.nodeStartStats.getIndexByRequestIndexSnapshotFromAnotherNode(true, stopwatch.elapsed(TimeUnit.SECONDS));
            return true;
        }
        catch (Throwable t) {
            this.nodeStartStats.getIndexByRequestIndexSnapshotFromAnotherNode(false, stopwatch.elapsed(TimeUnit.SECONDS));
            throw t;
        }
    }

    private boolean performFullForegroundReindex() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            String currentNode = this.getCurrentNode();
            Set<String> allOtherNodes = this.getAllOtherNodes(currentNode);
            log.info("Current node: {}. Triggering full-reindex. Current list of other nodes: {}", (Object)currentNode, allOtherNodes);
            Stream.concat(Stream.of(currentNode), allOtherNodes.stream()).forEach(arg_0 -> ((ReindexRequestManager)((ReindexRequestManager)this.reindexRequestManagerRef.get())).failRunningRequestsFromNode(arg_0));
            ((ReindexRequestManager)this.reindexRequestManagerRef.get()).clearAll();
            ReindexRequest request = ((ReindexRequestManager)this.reindexRequestManagerRef.get()).requestReindex(ReindexRequestType.IMMEDIATE, EnumSet.of(AffectedIndex.ISSUE, AffectedIndex.COMMENT, AffectedIndex.CHANGEHISTORY, AffectedIndex.WORKLOG), EnumSet.noneOf(SharedEntityType.class));
            log.info("Current node: {}. Triggered full-reindex, requestId: {}. Waiting for reindex to finish...", (Object)currentNode, (Object)request.getId());
            Set reindexRequests = ((ReindexRequestManager)this.reindexRequestManagerRef.get()).processPendingRequests(true, (Set)ImmutableSet.of((Object)ReindexRequestType.IMMEDIATE), false);
            log.info("Current node: {}. Full reindex done. Reindex requests processed: {}. List of index snapshots available now: {}. Current list of other nodes: {}", new Object[]{currentNode, reindexRequests.size(), this.getSnapshotFileNames(), allOtherNodes});
            this.nodeStartStats.getIndexByPerformFullForegroundReindex(true, stopwatch.elapsed(TimeUnit.SECONDS));
            return true;
        }
        catch (Throwable t) {
            this.nodeStartStats.getIndexByPerformFullForegroundReindex(false, stopwatch.elapsed(TimeUnit.SECONDS));
            log.error("Full reindex on this node has failed with error: {}.", (Object)t.getMessage());
            return false;
        }
    }

    @Nonnull
    private List<String> getSnapshotFileNames() {
        return ((IndexSnapshotOperator)this.indexSnapshotOperatorRef.get()).listIndexSnapshotFiles().stream().map(File::toPath).map(Path::getFileName).map(Objects::toString).collect(Collectors.toList());
    }

    void validateNodeIsActive(String node) throws IllegalArgumentException {
        if (!this.isNodeActive(node)) {
            Set activeNodes = this.getAllNodes().stream().filter(n -> n.getState() == Node.NodeState.ACTIVE).map(Node::getNodeId).collect(Collectors.toSet());
            throw new IllegalArgumentException(String.format("Node: %s in not in state: %s. Index snapshot requests are only allowed to %s nodes. Currently following nodes are %s: %s", new Object[]{node, Node.NodeState.ACTIVE, Node.NodeState.ACTIVE, Node.NodeState.ACTIVE, activeNodes}));
        }
    }

    void validateNotCurrentNode(String otherNode) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)otherNode);
        String currentNode = this.getNodeId();
        Preconditions.checkArgument((!otherNode.equals(currentNode) ? 1 : 0) != 0, (Object)"Cannot request index snapshot from itself");
    }

    boolean isSpecialNode(String node) {
        return "ANY".equals(node) || "ALL".equals(node);
    }

    @Override
    public void requestCurrentIndexFromNode(String destinationNode) {
        if (!this.isSpecialNode(destinationNode)) {
            this.validateNodeIsActive(destinationNode);
            this.validateNotCurrentNode(destinationNode);
        }
        ((NodeReindexService)this.nodeReindexServiceRef.get()).pause();
        ((NodeReindexService)this.nodeReindexServiceRef.get()).resetIndexCount();
        log.info("Sending message: \"{}\" - request to create index snapshot from node: {} on current node: {}", new Object[]{"Backup Index", destinationNode, this.getNodeId()});
        this.messageHandlerService.sendMessage(destinationNode, new Message("Backup Index", null));
    }

    @Override
    public Collection<Node> findLiveNodes() {
        if (this.liveNodes == null) {
            this.refreshLiveNodes();
        }
        return this.liveNodes;
    }

    @Override
    public void refreshLiveNodes() {
        Collection<String> heartbeatLiveNodesIds = ((ClusterNodeHeartbeatService)this.heartbeatServiceRef.get()).findLiveNodes();
        this.liveNodes = (Collection)this.getAllNodes().stream().filter(Objects::nonNull).filter(node -> node.getState().equals((Object)Node.NodeState.ACTIVE)).filter(node -> heartbeatLiveNodesIds.contains(node.getNodeId())).collect(ImmutableSet.toImmutableSet());
        this.nodeCutOffManager.removeStaleCutOffExecutors(this.liveNodes);
    }

    @EventListener
    public void onIndexesRestoredEvent(IndexesRestoredEvent ev) {
        if (((NodeReindexService)this.nodeReindexServiceRef.get()).isPaused()) {
            ((NodeReindexService)this.nodeReindexServiceRef.get()).start();
        }
    }

    @Override
    public boolean isClusterLicensed() {
        return true;
    }

    @Override
    public void removeIfOffline(@NotNull String nodeId) throws ClusterStateException {
        this.clusterNodes.removeIfOffline(nodeId);
    }

    @Override
    public List<String> removeOfflineNodesIfOlderThan(@NotNull Duration retentionPeriod) {
        Preconditions.checkNotNull((Object)retentionPeriod);
        ArrayList<String> nodesRemoved = new ArrayList<String>();
        List<String> nodeIdsToRemove = this.getNodesToRemove(retentionPeriod);
        for (String nodeId : nodeIdsToRemove) {
            try {
                this.clusterNodes.removeIfOffline(nodeId);
                nodesRemoved.add(nodeId);
            }
            catch (ClusterStateException e) {
                log.error("{} The node {} wasn't removed because {}", new Object[]{"[CLUSTER-STATE]", nodeId, e.getMessage()});
            }
        }
        return Collections.unmodifiableList(nodesRemoved);
    }

    private List<String> getNodesToRemove(Duration retentionPeriod) {
        return this.getAllNodes().stream().map(Node::getNodeId).filter(nodeId -> this.isNodeOffline((String)nodeId)).filter(nodeId -> this.isNodeTimestampBefore((String)nodeId, retentionPeriod)).collect(Collectors.toList());
    }

    @Override
    public void moveToOffline(@NotNull String nodeId) throws ClusterStateException {
        this.refreshLiveNodes();
        Node node = this.clusterNodes.node(nodeId);
        if (node != null && (this.scanIsNodeAlive(node) || node.getState() != Node.NodeState.ACTIVE)) {
            throw new ClusterStateException("You can only change state of non alive and active node");
        }
        this.clusterNodes.moveToOffline(nodeId);
    }

    @Override
    public List<String> moveNodesToOfflineIfOlderThan(@NotNull Duration retentionPeriod) {
        Preconditions.checkNotNull((Object)retentionPeriod);
        ArrayList<String> nodesMovedToOffline = new ArrayList<String>();
        this.refreshLiveNodes();
        List<String> nodeIdsToMoveOffline = this.getNodesToMoveToOffline(retentionPeriod);
        for (String nodeId : nodeIdsToMoveOffline) {
            try {
                this.clusterNodes.moveToOffline(nodeId);
                nodesMovedToOffline.add(nodeId);
            }
            catch (ClusterStateException e) {
                log.error("{} The node {} wasn't moved to OFFLINE state because {}", new Object[]{"[CLUSTER-STATE]", nodeId, e.getMessage()});
            }
        }
        this.refreshLiveNodes();
        return Collections.unmodifiableList(nodesMovedToOffline);
    }

    private List<String> getNodesToMoveToOffline(Duration retentionPeriod) {
        return this.getAllNodes().stream().map(Node::getNodeId).filter(nodeId -> this.isNodeActive((String)nodeId)).filter(nodeId -> this.isNodeNonAliveLongerThan((String)nodeId, retentionPeriod)).collect(Collectors.toList());
    }

    private boolean isNodeNonAliveLongerThan(String nodeId, Duration retentionPeriod) {
        if (this.checkIfNodeHasValidHeartbeat(nodeId)) {
            return ((ClusterNodeHeartbeatService)this.heartbeatServiceRef.get()).findLiveNodes(retentionPeriod.toMillis()).stream().noneMatch(aliveNodeId -> aliveNodeId.equals(nodeId));
        }
        log.debug("{} Node {} does not have heartbeat so his absence in cluster is calculated based on the timestamp", (Object)"[CLUSTER-STATE]", (Object)nodeId);
        return this.isNodeTimestampBefore(nodeId, retentionPeriod);
    }

    private boolean isNodeTimestampBefore(String nodeId, Duration retentionPeriod) {
        Node node = this.clusterNodes.node(nodeId);
        Instant nodeTimestamp = Instant.ofEpochMilli(node.getTimestamp());
        Instant threshold = Instant.now().minusMillis(retentionPeriod.toMillis());
        return nodeTimestamp.isBefore(threshold);
    }

    private boolean checkIfNodeHasValidHeartbeat(String nodeId) {
        Node node = this.clusterNodes.node(nodeId);
        return new NodeTimeHelper((ClusterNodeHeartbeatService)this.heartbeatServiceRef.get()).isNodeHeartbeatValid(node);
    }

    @Override
    public boolean isNodeAlive(@NotNull String nodeId) {
        this.refreshLiveNodes();
        Node node = this.clusterNodes.node(nodeId);
        return node != null && this.scanIsNodeAlive(node);
    }

    private boolean scanIsNodeAlive(@NotNull Node node) {
        return this.liveNodes.stream().anyMatch(n -> n.getNodeId().equals(node.getNodeId()));
    }

    @Override
    public boolean isNodePresent(@NotNull String nodeId) {
        Node node = this.clusterNodes.node(nodeId);
        return node != null;
    }

    @Override
    public boolean isNodeOffline(@NotNull String nodeId) {
        return this.isNodeInState(nodeId, Node.NodeState.OFFLINE);
    }

    @Override
    public boolean isNodeActive(@NotNull String nodeId) {
        return this.isNodeInState(nodeId, Node.NodeState.ACTIVE);
    }

    private boolean isNodeInState(String nodeId, Node.NodeState nodeState) {
        Node node = this.clusterNodes.node(nodeId);
        return node != null && nodeState != null && node.getState() == nodeState;
    }

    @Override
    public List<Node> findActiveAndNotAliveNodes() {
        this.refreshLiveNodes();
        return ImmutableList.copyOf((Collection)this.getAllNodes().stream().filter(node -> this.isNodeActive(node.getNodeId())).filter(node -> !this.isNodeAlive(node.getNodeId())).collect(Collectors.toList()));
    }

    @Override
    public List<Node> findOfflineNodes() {
        return ImmutableList.copyOf((Collection)this.getAllNodes().stream().filter(node -> this.isNodeOffline(node.getNodeId())).collect(Collectors.toList()));
    }
}

