/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.cluster.ClusterSettings;
import com.atlassian.jira.cluster.ClusterTaskCleanupService;
import com.atlassian.jira.cluster.ClusterWatchdogService;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.lock.HeartbeatScheduledExecutorFactory;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusWriter;
import com.atlassian.jira.cluster.service.ClusterStateCheckerJob;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.cluster.ClusterMessageCleaningService;
import com.atlassian.jira.service.services.cluster.NodeStateCheckerService;
import com.atlassian.jira.service.services.index.ReplicatedIndexCleaningService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.versioning.VersioningCleanupService;
import java.time.Duration;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterServicesManager
implements ClusterServicesManager,
Startable {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterServicesManager.class);
    private final MessageHandlerService messageHandlerService;
    private final ClusterManager clusterManager;
    private final NodeReindexService nodeReindexService;
    private final ServiceManager serviceManager;
    private final I18nHelper i18nHelper;
    private final NodeStateManager nodeStateManager;
    private final ClusterNodeHeartBeatDao heartBeatDao;
    private final SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter;
    private final HeartbeatScheduledExecutorFactory heartbeatScheduledExecutorFactory;
    private final ClusterWatchdogService clusterWatchdogService;
    private final ClusterTaskCleanupService clusterTaskCleanupService;
    private final VersioningCleanupService versioningCleanupService;
    private final ClusterStateCheckerJob clusterStateCheckerService;

    public DefaultClusterServicesManager(ClusterManager clusterManager, ServiceManager serviceManager, NodeReindexService nodeReindexService, I18nHelper i18nHelper, NodeStateManager nodeStateManager, ClusterNodeHeartBeatDao heartBeatDao, SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter, MessageHandlerService messageHandlerService, HeartbeatScheduledExecutorFactory heartbeatScheduledExecutorFactory, ClusterWatchdogService clusterWatchdogService, ClusterTaskCleanupService clusterTaskCleanupService, VersioningCleanupService versioningCleanupService, ClusterStateCheckerJob clusterStateCheckerService) {
        this.clusterManager = clusterManager;
        this.serviceManager = serviceManager;
        this.i18nHelper = i18nHelper;
        this.messageHandlerService = messageHandlerService;
        this.nodeReindexService = nodeReindexService;
        this.nodeStateManager = nodeStateManager;
        this.heartBeatDao = heartBeatDao;
        this.sharedHomeNodeStatusWriter = sharedHomeNodeStatusWriter;
        this.heartbeatScheduledExecutorFactory = heartbeatScheduledExecutorFactory;
        this.clusterWatchdogService = clusterWatchdogService;
        this.clusterTaskCleanupService = clusterTaskCleanupService;
        this.versioningCleanupService = versioningCleanupService;
        this.clusterStateCheckerService = clusterStateCheckerService;
    }

    @Override
    public void startServices() {
        if (this.clusterManager.isClustered()) {
            this.messageHandlerService.start();
            this.clusterTaskCleanupService.start();
            this.clusterStateCheckerService.start();
            new IndexCleaningServiceHelper().createIndexCleaningServiceIfNeeded(this.i18nHelper);
            new ClusterMessageCleaningServiceHelper().createClusterMessageCleaningServiceIfNeeded(this.i18nHelper);
            new NodeCheckerServiceHelper().createNodeCheckerServiceIfNeeded(this.i18nHelper);
        }
    }

    @Override
    public void stopServices() {
        this.nodeReindexService.shutDown();
        this.messageHandlerService.stop();
        this.clusterTaskCleanupService.stop();
        this.versioningCleanupService.stop();
        this.clusterStateCheckerService.stop();
        this.nodeStateManager.shutdownNode();
        this.heartbeatScheduledExecutorFactory.stop();
        this.clusterWatchdogService.stop();
        this.heartBeatDao.writeHeartBeat(0L);
        this.sharedHomeNodeStatusWriter.removeNodeStatus(this.heartBeatDao.getNodeId());
    }

    public void start() throws Exception {
        this.startServices();
    }

    public final class IndexCleaningServiceHelper {
        private static final String SERVICE_NAME_KEY = "admin.services.indexcleaner.service";
        private final long DELAY = DateUtils.HOUR_MILLIS * 12L;

        public void createIndexCleaningServiceIfNeeded(I18nHelper i18n) {
            try {
                Duration retentionPeriod = ClusterSettings.getClusterRetentionPeriod();
                String serviceName = i18n.getText(SERVICE_NAME_KEY);
                String parsedRetentionPeriod = retentionPeriod.toMinutes() + "m";
                if (DefaultClusterServicesManager.this.serviceManager.getServiceWithName(serviceName) == null) {
                    HashMap<String, String[]> params = new HashMap<String, String[]>(2);
                    params.put("RETENTION_PERIOD", new String[]{parsedRetentionPeriod});
                    DefaultClusterServicesManager.this.serviceManager.addService(serviceName, ReplicatedIndexCleaningService.class.getName(), this.DELAY, params);
                }
            }
            catch (Exception e) {
                LOG.error(DefaultClusterServicesManager.this.i18nHelper.getText("admin.errors.setup.error.adding.service", e.toString()));
            }
        }
    }

    private final class ClusterMessageCleaningServiceHelper {
        private static final String SERVICE_NAME_KEY = "admin.services.cluster.message.cleaner";
        private final long DELAY = DateUtils.HOUR_MILLIS * 12L;

        private ClusterMessageCleaningServiceHelper() {
        }

        public void createClusterMessageCleaningServiceIfNeeded(I18nHelper i18n) {
            try {
                Duration retentionPeriod = ClusterSettings.getClusterRetentionPeriod();
                String serviceName = i18n.getText(SERVICE_NAME_KEY);
                String parsedRetentionPeriod = retentionPeriod.toMinutes() + "m";
                if (DefaultClusterServicesManager.this.serviceManager.getServiceWithName(serviceName) == null) {
                    HashMap<String, String[]> params = new HashMap<String, String[]>(2);
                    params.put("RETENTION_PERIOD", new String[]{parsedRetentionPeriod});
                    DefaultClusterServicesManager.this.serviceManager.addService(serviceName, ClusterMessageCleaningService.class.getName(), this.DELAY, params);
                }
            }
            catch (Exception e) {
                LOG.error(DefaultClusterServicesManager.this.i18nHelper.getText("admin.errors.setup.error.adding.service", e.toString()));
            }
        }
    }

    private final class NodeCheckerServiceHelper {
        private static final String SERVICE_NAME_KEY = "admin.services.nodechecker.service";
        private final long DELAY = DateUtils.MINUTE_MILLIS * 1L;

        private NodeCheckerServiceHelper() {
        }

        public void createNodeCheckerServiceIfNeeded(I18nHelper i18n) {
            try {
                String serviceName = i18n.getText(SERVICE_NAME_KEY);
                if (DefaultClusterServicesManager.this.serviceManager.getServiceWithName(serviceName) == null) {
                    HashMap params = new HashMap(0);
                    DefaultClusterServicesManager.this.serviceManager.addService(serviceName, NodeStateCheckerService.class.getName(), this.DELAY, params);
                }
            }
            catch (Exception e) {
                LOG.error(DefaultClusterServicesManager.this.i18nHelper.getText("admin.errors.setup.error.adding.service", e.toString()));
            }
        }
    }
}

