/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr;

import com.atlassian.jira.cluster.dbr.DBRMessageDataSerialized;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class DBRMessage<T>
implements Serializable {
    private static final long serialVersionUID = 6108174582796114208L;
    final IndexDirectoryFactory.Name index;
    final Operation operation;
    final String entityId;
    final Long entityVersion;
    final DBRMessageDataSerialized<T> dbrMessageDataSerialized;
    final String sourceNode;
    final long cost;
    final long createdLocalTimestamp;

    DBRMessage(IndexDirectoryFactory.Name index, Operation operation, String entityId, Long entityVersion, DBRMessageDataSerialized<T> dbrMessageDataSerialized, String sourceNode, long cost) {
        this.operation = (Operation)((Object)Preconditions.checkNotNull((Object)((Object)operation), (Object)"operation can't be null"));
        this.entityId = (String)Preconditions.checkNotNull((Object)entityId, (Object)"entity ID can't be null");
        this.entityVersion = (Long)Preconditions.checkNotNull((Object)entityVersion, (Object)"entity version can't be null");
        this.dbrMessageDataSerialized = (DBRMessageDataSerialized)Preconditions.checkNotNull(dbrMessageDataSerialized, (Object)"serialized message data can't be null");
        this.index = (IndexDirectoryFactory.Name)((Object)Preconditions.checkNotNull((Object)((Object)index), (Object)"index can't be null"));
        this.sourceNode = (String)Preconditions.checkNotNull((Object)sourceNode, (Object)"sourceNode can't be null");
        this.cost = cost;
        this.createdLocalTimestamp = System.currentTimeMillis();
    }

    public IndexDirectoryFactory.Name getIndex() {
        return this.index;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Long getEntityVersion() {
        return this.entityVersion;
    }

    public DBRMessageDataSerialized<T> getDbrMessageDataSerialized() {
        return this.dbrMessageDataSerialized;
    }

    public int messageSize() {
        return this.dbrMessageDataSerialized.getData().length;
    }

    public String getSourceNode() {
        return this.sourceNode;
    }

    public long getCreatedLocalTimestamp() {
        return this.createdLocalTimestamp;
    }

    public long getCost() {
        return this.cost;
    }

    public String toString() {
        return "DBRMessage{index=" + this.index + ", operation=" + this.operation + ", entityId='" + this.entityId + "', entityVersion=" + this.entityVersion + ", dbrMessageDataSerialized=" + this.dbrMessageDataSerialized + ", sourceNode='" + this.sourceNode + "', cost=" + this.cost + ", createdLocalTimestamp=" + this.createdLocalTimestamp + "}";
    }

    static enum Operation {
        UPDATE,
        UPDATE_WITH_RELATED;

    }
}

