/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.dbr;

import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;

public class JiraDocumentUtil {
    public static String documentToShortString(IndexDirectoryFactory.Name index, Document document) {
        StringBuilder sb = new StringBuilder("{");
        sb.append("indexName=").append(index.name());
        sb.append(", issueId=").append(document.get("issue_id"));
        switch (index) {
            case ISSUE: {
                break;
            }
            case COMMENT: {
                sb.append(", commentId=").append(document.get("id"));
                break;
            }
            case WORKLOG: {
                sb.append(", worklogId=").append(document.get("worklog_id"));
                break;
            }
            case CHANGE_HISTORY: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported index: " + index);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public static String documentsToShortString(DefaultIssueIndexer.Documents documents) {
        return "{issueId=" + documents.getIssue().get("issue_id") + ", comments=[" + documents.getComments().stream().map(document -> document.get("id")).collect(Collectors.joining(", ")) + "], worklogs=[" + documents.getWorklogs().stream().map(document -> document.get("worklog_id")).collect(Collectors.joining(", ")) + "], changes.size=" + documents.getChanges().size() + "}";
    }
}

