/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.jira.cluster.disasterrecovery.JiraHomeReplicatorService;
import java.io.File;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JiraHomeChangeEvent {
    private final Action action;
    private final File[] files;
    private final FileType fileType;

    public JiraHomeChangeEvent(Action action, FileType fileType, File ... files) {
        this.action = action;
        this.files = (File[])files.clone();
        this.fileType = fileType;
    }

    @Nonnull
    public Action getAction() {
        return this.action;
    }

    @Nonnull
    public File[] getFiles() {
        return this.files;
    }

    @Nonnull
    public FileType getFileType() {
        return this.fileType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JiraHomeChangeEvent)) {
            return false;
        }
        JiraHomeChangeEvent that = (JiraHomeChangeEvent)o;
        if (this.action != that.action) {
            return false;
        }
        if (this.fileType != that.fileType) {
            return false;
        }
        return Arrays.equals(this.files, that.files);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.fileType.hashCode();
        return result;
    }

    public static enum Action {
        FILE_ADD,
        FILE_DELETED;

    }

    public static enum FileType {
        ATTACHMENT("jira.secondary.store.attachments.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicateAttachments();
            }
        }
        ,
        INDEX_SNAPSHOT("jira.secondary.store.index.snapshots.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicateIndexSnapshots();
            }
        }
        ,
        AVATAR("jira.secondary.store.avatars.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicateAvatars();
            }
        }
        ,
        PLUGIN("jira.secondary.store.plugins.enabled"){

            @Override
            JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService jiraHomeReplicatorService) {
                return jiraHomeReplicatorService.replicatePlugins();
            }
        };

        private final String key;

        private FileType(String key) {
            this.key = key;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        abstract JiraHomeReplicatorService.ReplicationResult replicate(JiraHomeReplicatorService var1);
    }
}

