/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.CuttingOffExecutor;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.cache.NodeCutOffManager;
import com.atlassian.jira.cluster.distribution.ClassLoaderSwitchingSupplier;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.util.log.RateLimitingLogger;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;

public class JiraCacheManagerPeerProvider
extends RMICacheManagerPeerProvider {
    private static final RateLimitingLogger log = new RateLimitingLogger(JiraCacheManagerPeerProvider.class);
    private final ExecutorService executorService;
    private final RMIClientSocketFactory rmiClientSocketFactory;
    private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);
    private final ComponentReference<NodeCutOffManager> nodeCutOffManagerRef = ComponentAccessor.getComponentReference(NodeCutOffManager.class);

    public JiraCacheManagerPeerProvider(CacheManager cacheManager, ExecutorService executorService, RMIClientSocketFactory rmiClientSocketFactory) {
        super(cacheManager);
        this.executorService = executorService;
        this.rmiClientSocketFactory = rmiClientSocketFactory;
    }

    public void init() {
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public final void registerPeer(String rmiUrl) {
    }

    public List<CachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        ClusterManager clusterManager = this.getClusterManager();
        String currentNodeId = clusterManager.getNodeId();
        Collection<Node> liveNodes = clusterManager.findLiveNodes();
        return this.waitForAll(liveNodes.stream().filter(node -> node != null && !currentNodeId.equals(node.getNodeId())).map(node -> this.getCachePeerAsync(cache, (Node)node)).collect(Collectors.toList()));
    }

    private CompletableFuture<Optional<CachePeer>> getCachePeerAsync(Ehcache cache, Node node) {
        NodeCutOffManager nodeCutOffManager = this.getNodeCutOffManager();
        return nodeCutOffManager.getCutOffExecutorForNode(node).invokeOrCutOff(callback -> this.getOptionalCompletableFuture(cache, node, callback)).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Nonnull
    private CompletableFuture<Optional<CachePeer>> getOptionalCompletableFuture(Ehcache cache, Node node, CuttingOffExecutor.Callback callback) {
        return CompletableFuture.supplyAsync(new ClassLoaderSwitchingSupplier<Optional>(() -> {
            try {
                return Optional.of(this.wrapCachePeer(this.lookupRemoteCachePeer(node, cache.getName()), callback));
            }
            catch (RemoteException e) {
                log.warn("Looking up rmiUrl " + this.buildBaseUrl(node, cache.getName()) + " threw a connection exception. This could mean that a node has gone offline  or it may indicate network connectivity difficulties. Details: " + e.getMessage());
                callback.registerFailure();
            }
            catch (NotBoundException e) {
                log.debug("Looking up rmiUrl " + this.buildBaseUrl(node, cache.getName()) + " threw a connection exception. This may be normal if a node has gone offline. Or it may indicate network connectivity difficulties. Details : " + e.getMessage());
            }
            return Optional.empty();
        }), this.executorService);
    }

    private CachePeer wrapCachePeer(CachePeer cachePeer, CuttingOffExecutor.Callback callback) {
        return (CachePeer)Proxy.newProxyInstance(CachePeer.class.getClassLoader(), new Class[]{CachePeer.class}, (proxy, method, args) -> {
            try {
                Object invoke = method.invoke((Object)cachePeer, args);
                callback.registerSuccess();
                return invoke;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                callback.registerFailure();
                throw throwable;
            }
        });
    }

    @VisibleForTesting
    protected CachePeer lookupRemoteCachePeer(Node node, String cacheName) throws NotBoundException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug("Lookup URL " + this.buildBaseUrl(node, cacheName));
        }
        Registry registry = LocateRegistry.getRegistry(node.getIp(), node.getCacheListenerPort().intValue(), this.rmiClientSocketFactory);
        return (CachePeer)registry.lookup(cacheName);
    }

    private <T> List<T> waitForAll(List<CompletableFuture<Optional<T>>> stages) {
        return stages.stream().map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected boolean stale(Date date) {
        return false;
    }

    private String buildBaseUrl(Node node, String cacheName) {
        return "//" + node.getIp() + ":" + node.getCacheListenerPort() + "/" + cacheName;
    }

    private ClusterManager getClusterManager() {
        return (ClusterManager)this.clusterManagerRef.get();
    }

    private NodeCutOffManager getNodeCutOffManager() {
        return (NodeCutOffManager)this.nodeCutOffManagerRef.get();
    }
}

