/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpQueueWithStats;
import com.atlassian.jira.cluster.distribution.localq.LogPrefix;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class LocalQStatsUtil {
    static void logStats(Logger logger, Set<LocalQCacheOpQueueWithStats> queuesWithStats, boolean replicatePutsViaCopy) {
        Map<String, List<LocalQCacheOpQueueWithStats.QueueStats>> snapshotStatsByNodeId = queuesWithStats.stream().filter(op -> op.id().replicatePutsViaCopy == replicatePutsViaCopy).map(LocalQCacheOpQueueWithStats::statsSnapshot).collect(Collectors.groupingBy(queueStats -> queueStats.nodeId));
        Map<String, List<LocalQCacheOpQueueWithStats.QueueStats>> totalStatsByNodeId = queuesWithStats.stream().filter(op -> op.id().replicatePutsViaCopy == replicatePutsViaCopy).map(LocalQCacheOpQueueWithStats::statsTotal).collect(Collectors.groupingBy(queueStats -> queueStats.nodeId));
        queuesWithStats.stream().map(queueWithStats -> queueWithStats.id().nodeId).sorted().distinct().forEach(nodeId -> LocalQStatsUtil.logStatsForEachQueuePerNode(logger, nodeId, snapshotStatsByNodeId.getOrDefault(nodeId, Collections.emptyList()), totalStatsByNodeId.getOrDefault(nodeId, Collections.emptyList()), replicatePutsViaCopy));
    }

    private static void logStatsForEachQueuePerNode(Logger logger, String nodeId, List<LocalQCacheOpQueueWithStats.QueueStats> nodeSnapshotStats, List<LocalQCacheOpQueueWithStats.QueueStats> nodeTotalStats, boolean replicatePutsViaCopy) {
        Gson gson = new Gson();
        LocalQCacheOpQueueWithStats.QueueStats nodeSnapshotStatsMerged = LocalQCacheOpQueueWithStats.QueueStats.merge(nodeId, nodeSnapshotStats);
        LocalQCacheOpQueueWithStats.QueueStats nodeTotalStatsMerged = LocalQCacheOpQueueWithStats.QueueStats.merge(nodeId, nodeTotalStats);
        String putQueuePrefix = replicatePutsViaCopy ? "replicatePutsViaCopy-" : "";
        logger.info("[JIRA-STATS] " + LogPrefix.prefix(replicatePutsViaCopy) + "Cache replication {}queue stats per node: {} snapshot stats: {}", new Object[]{putQueuePrefix, nodeId, gson.toJson((Object)nodeSnapshotStatsMerged)});
        logger.info("[JIRA-STATS] " + LogPrefix.prefix(replicatePutsViaCopy) + "Cache replication {}queue stats per node: {} total stats: {}", new Object[]{putQueuePrefix, nodeId, gson.toJson((Object)nodeTotalStatsMerged)});
        if (logger.isDebugEnabled()) {
            LocalQStatsUtil.logPerQueue(logger, nodeSnapshotStats, nodeTotalStats, replicatePutsViaCopy);
        }
    }

    private static void logPerQueue(Logger logger, List<LocalQCacheOpQueueWithStats.QueueStats> nodeSnapshotStats, List<LocalQCacheOpQueueWithStats.QueueStats> nodeTotalStats, boolean replicatePutsViaCopy) {
        Gson gson = new Gson();
        nodeSnapshotStats.forEach(queueStats -> logger.debug("[JIRA-STATS] " + LogPrefix.prefix(replicatePutsViaCopy) + "Cache replication queue stats per queue, node: {}, nodeQueueNumber: {}, snapshot stats: {}", new Object[]{queueStats.nodeId, queueStats.nodeQueueNumber, gson.toJson(queueStats)}));
        nodeTotalStats.forEach(queueStats -> logger.debug("[JIRA-STATS] " + LogPrefix.prefix(replicatePutsViaCopy) + "Cache replication queue stats per queue, node: {}, nodeQueueNumber: {}, total stats: {}", new Object[]{queueStats.nodeId, queueStats.nodeQueueNumber, gson.toJson(queueStats)}));
    }
}

