/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.distribution.localq.LogPrefix;
import com.atlassian.jira.cluster.distribution.localq.rmi.RMICachePeerManager;
import com.atlassian.jira.cluster.distribution.localq.rmi.RMICachePeerProvider;
import com.google.common.base.Preconditions;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.sf.ehcache.distribution.CachePeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingRMICachePeerManager
implements RMICachePeerManager {
    private static final Logger LOG = LoggerFactory.getLogger(CachingRMICachePeerManager.class);
    private ConcurrentHashMap<Key, Value> cachePeers = new ConcurrentHashMap();
    private RMICachePeerProvider rmiCachePeerProvider;

    public CachingRMICachePeerManager(RMICachePeerProvider rmiCachePeerProvider) {
        this.rmiCachePeerProvider = rmiCachePeerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachePeer getCachePeerFor(Node node, String cacheName) throws NotBoundException, RemoteException {
        Key key = Key.create(node.getNodeId(), cacheName);
        Value value = this.cachePeers.computeIfAbsent(key, k -> Value.create(node));
        Preconditions.checkNotNull((Object)value.node);
        Preconditions.checkArgument((boolean)Objects.equals(key.nodeId, node.getNodeId()));
        Preconditions.checkArgument((boolean)Objects.equals(node.getNodeId(), value.node.getNodeId()));
        Value value2 = value;
        synchronized (value2) {
            if (CachingRMICachePeerManager.hasNodeDefinitionChanged(value.node, node) || value.cachePeer == null) {
                if (value.cachePeer != null) {
                    LOG.info(LogPrefix.prefix() + "Re-creating cache peer for node: {} and cacheName: {}, old-node: {}, new-node: {}", new Object[]{node.getNodeId(), cacheName, value.node, node});
                } else {
                    LOG.debug(LogPrefix.prefix() + "Creating cache peer for node: {} and cacheName: {}, node: {}", new Object[]{node.getNodeId(), cacheName, node});
                }
                value.node(node);
                try {
                    value.cachePeer(this.rmiCachePeerProvider.create(node, cacheName));
                }
                catch (NotBoundException | RemoteException e) {
                    LOG.trace(LogPrefix.prefix() + "Error when creating cache peer for node: {} and cacheName: {}", new Object[]{node, cacheName, e});
                    throw e;
                }
            }
            return value.cachePeer;
        }
    }

    private static boolean hasNodeDefinitionChanged(Node previousNode, Node currentNode) {
        return !previousNode.equals(currentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCachePeer(Node node, String cacheName, CachePeer cachePeer) {
        Value value;
        if (node == null || node.getNodeId() == null || cacheName == null || cachePeer == null) {
            return;
        }
        Key key = Key.create(node.getNodeId(), cacheName);
        Value value2 = value = this.cachePeers.get(key);
        synchronized (value2) {
            if (value.cachePeer != null && value.cachePeer == cachePeer) {
                value.cachePeer = null;
            }
        }
    }

    @Override
    public void withCachePeer(Node node, String cacheName, RMICachePeerManager.CachePeerCallable cachePeerCallable) throws NotBoundException, RemoteException {
        CachePeer cachePeer = null;
        try {
            cachePeer = this.getCachePeerFor(node, cacheName);
            cachePeerCallable.with(cachePeer);
        }
        catch (NotBoundException | RemoteException e) {
            this.invalidateCachePeer(node, cacheName, cachePeer);
            throw e;
        }
    }

    private static class Key {
        private final String nodeId;
        private final String cacheName;

        static Key create(String nodeId, String cacheName) {
            return new Key(nodeId, cacheName);
        }

        private Key(String nodeId, String cacheName) {
            this.nodeId = nodeId;
            this.cacheName = cacheName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.cacheName);
        }
    }

    private static class Value {
        private Node node;
        @Nullable
        private CachePeer cachePeer;

        static Value create(Node node) {
            return new Value(node);
        }

        Value(Node node) {
            Preconditions.checkNotNull((Object)node);
            this.node = node;
        }

        Value node(Node node) {
            Preconditions.checkNotNull((Object)node);
            this.node = node;
            return this;
        }

        Value cachePeer(CachePeer cachePeer) {
            this.cachePeer = cachePeer;
            return this;
        }
    }
}

