/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthService;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthStatsManager;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.DefaultClusterAuthSharedKeySupplier;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.NoOpClusterAuthService;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.SharedSecretClusterAuthService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.security.properties.SecurityPropertiesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ClusterAuthServiceFactory.class);
    public static final String SYSTEM_PROPERTY_RMI_AUTH_DISABLED = "com.atlassian.jira.cluster.distribution.localq.rmi.auth.disabled";
    private final ClusterAuthService clusterAuthServiceInstance;

    public static ClusterAuthServiceFactory getClusterAuthServiceFactory() {
        return (ClusterAuthServiceFactory)ComponentAccessor.getComponent(ClusterAuthServiceFactory.class);
    }

    public ClusterAuthServiceFactory(SecurityPropertiesService securityPropertiesService, EventPublisher eventPublisher) {
        if (JiraSystemProperties.getInstance().getBoolean(SYSTEM_PROPERTY_RMI_AUTH_DISABLED).booleanValue()) {
            log.info("RMI Auth disable via system property: {}", (Object)SYSTEM_PROPERTY_RMI_AUTH_DISABLED);
            this.clusterAuthServiceInstance = new NoOpClusterAuthService();
        } else {
            log.info("RMI Auth enabled by default. Note this can be disabled via system property: {}", (Object)SYSTEM_PROPERTY_RMI_AUTH_DISABLED);
            ClusterAuthStatsManager clusterAuthStatsManager = new ClusterAuthStatsManager(eventPublisher);
            clusterAuthStatsManager.start();
            this.clusterAuthServiceInstance = new SharedSecretClusterAuthService(new DefaultClusterAuthSharedKeySupplier(securityPropertiesService), clusterAuthStatsManager);
        }
    }

    public ClusterAuthService getClusterAuthServiceInstance() {
        return this.clusterAuthServiceInstance;
    }
}

