/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthenticationResult;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthStatsManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterAuthStatsManager.class);
    static final long[] MILLIS_DISTRIBUTION = new long[]{0L, 1L, 5L, 10L, 50L, 100L, 500L, 1000L, 5000L};
    private final EventPublisher eventPublisher;
    private final MutableStats serverStatsTotal = new MutableStats();
    private final MutableStats clientStatsTotal = new MutableStats();
    private final MutableStats serverStatsSnapshot = new MutableStats();
    private final MutableStats clientStatsSnapshot = new MutableStats();
    private final ScheduledExecutorService executorStats = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("cluster-auth-stats-%d").build());

    public ClusterAuthStatsManager(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private void init() {
        this.eventPublisher.register((Object)this);
        long statsLoggingIntervalSeconds = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.SECONDS);
        LOG.info(ClusterAuthStatsManager.prefix() + "stats will be running every: {} seconds", (Object)statsLoggingIntervalSeconds);
        this.executorStats.scheduleAtFixedRate(() -> this.logStats("scheduled"), statsLoggingIntervalSeconds, statsLoggingIntervalSeconds, TimeUnit.SECONDS);
    }

    private void destroy() {
        this.eventPublisher.unregister((Object)this);
        this.executorStats.shutdownNow();
        try {
            this.executorStats.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void start() {
        LOG.info(ClusterAuthStatsManager.prefix() + "Starting {}...", (Object)ClusterAuthStatsManager.class.getSimpleName());
        this.init();
        LOG.info(ClusterAuthStatsManager.prefix() + "Done starting {}.", (Object)ClusterAuthStatsManager.class.getSimpleName());
        this.logStats("onStart");
    }

    private void stop() {
        this.logStats("onStop");
        LOG.info(ClusterAuthStatsManager.prefix() + "Stopping {}...", (Object)ClusterAuthStatsManager.class.getSimpleName());
        this.destroy();
        LOG.info(ClusterAuthStatsManager.prefix() + "Done stopping {}.", (Object)ClusterAuthStatsManager.class.getSimpleName());
    }

    private void logStats(String context) {
        try {
            LOG.info(ClusterAuthStatsManager.prefix() + "[{}] Running cluster authentication stats...", (Object)context);
            Gson gson = new Gson();
            LOG.info("[JIRA-STATS] " + ClusterAuthStatsManager.prefix() + "Cluster authentication server snapshot stats: {}", (Object)gson.toJson((Object)this.statsSnapshot(this.serverStatsSnapshot, true)));
            LOG.info("[JIRA-STATS] " + ClusterAuthStatsManager.prefix() + "Cluster authentication client snapshot stats: {}", (Object)gson.toJson((Object)this.statsSnapshot(this.clientStatsSnapshot, true)));
            LOG.info("[JIRA-STATS] " + ClusterAuthStatsManager.prefix() + "Cluster authentication server total stats: {}", (Object)gson.toJson((Object)this.statsTotal(this.serverStatsTotal)));
            LOG.info("[JIRA-STATS] " + ClusterAuthStatsManager.prefix() + "Cluster authentication client total stats: {}", (Object)gson.toJson((Object)this.statsTotal(this.clientStatsTotal)));
            LOG.info(ClusterAuthStatsManager.prefix() + "[{}] ... done running cluster authentication stats", (Object)context);
        }
        catch (Throwable t) {
            LOG.error(ClusterAuthStatsManager.prefix() + "Error occurred in cluster authentication stats job: {}, error: {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
        }
    }

    private static String prefix() {
        return "[JIRA-RMI-AUTH] ";
    }

    private void updateStats(boolean isServer, Consumer<MutableStats> updater) {
        updater.accept(isServer ? this.serverStatsTotal : this.clientStatsTotal);
        updater.accept(isServer ? this.serverStatsSnapshot : this.clientStatsSnapshot);
    }

    public void notifyAuthenticationSkipped(boolean isServer) {
        this.updateStats(isServer, stats -> {
            stats.authsTotal.incrementAndGet();
            stats.authsSkippedNoSecret.incrementAndGet();
        });
    }

    public void notifyAuthenticationFinished(boolean isServer, long duration, ClusterAuthenticationResult result) {
        this.updateStats(isServer, stats -> {
            stats.authsTotal.incrementAndGet();
            if (result == null) {
                stats.authsFailed.incrementAndGet();
            } else if (result.isSuccessful()) {
                stats.authsSuccess.incrementAndGet();
            } else if (result.isTimeout()) {
                stats.authsFailedByTimeout.incrementAndGet();
            } else {
                stats.authsFailed.incrementAndGet();
            }
            stats.timeToAuthMillis.accept(duration);
        });
    }

    private synchronized Stats statsSnapshot(MutableStats mutableStats, boolean reset) {
        Stats stats = new Stats(mutableStats);
        if (reset) {
            mutableStats.reset();
        }
        return stats;
    }

    private Stats statsTotal(MutableStats mutableStats) {
        return new Stats(mutableStats);
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        this.stop();
    }

    private static class MutableStats {
        final AtomicLong startTimestampMillis;
        final AtomicLong authsTotal = new AtomicLong(0L);
        final AtomicLong authsSkippedNoSecret = new AtomicLong(0L);
        final AtomicLong authsFailed = new AtomicLong(0L);
        final AtomicLong authsFailedByTimeout = new AtomicLong(0L);
        final AtomicLong authsSuccess = new AtomicLong(0L);
        final MutableLongStats timeToAuthMillis = new MutableLongStats(MILLIS_DISTRIBUTION);

        MutableStats(long startTimestampMillis) {
            this.startTimestampMillis = new AtomicLong(startTimestampMillis);
        }

        MutableStats() {
            this(MutableStats.nowInMillis());
        }

        static long nowInMillis() {
            return System.currentTimeMillis();
        }

        void reset() {
            this.startTimestampMillis.set(MutableStats.nowInMillis());
            this.authsTotal.set(0L);
            this.authsSkippedNoSecret.set(0L);
            this.authsFailed.set(0L);
            this.authsFailedByTimeout.set(0L);
            this.authsSuccess.set(0L);
            this.timeToAuthMillis.reset();
        }
    }

    private static class Stats {
        final long startTimestampMillis;
        final long authsTotal;
        final long authsSkippedNoSecret;
        final long authsFailed;
        final long authsFailedByTimeout;
        final long authsSuccess;
        final LongStats timeToAuthMillis;

        Stats(MutableStats stats) {
            this.startTimestampMillis = stats.startTimestampMillis.get();
            this.authsTotal = stats.authsTotal.get();
            this.authsSkippedNoSecret = stats.authsSkippedNoSecret.get();
            this.authsFailed = stats.authsFailed.get();
            this.authsFailedByTimeout = stats.authsFailedByTimeout.get();
            this.authsSuccess = stats.authsSuccess.get();
            this.timeToAuthMillis = stats.timeToAuthMillis.get();
        }
    }
}

