/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import aQute.lib.hex.Hex;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthService;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthSharedKeySupplier;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthStatsManager;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthenticationResult;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterJoinRequest;
import com.atlassian.security.random.SecureRandomFactory;
import com.atlassian.security.utils.ConstantTimeComparison;
import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedSecretClusterAuthService
implements ClusterAuthService {
    private static final int NONCE_BYTES = 16;
    private static final int RESPONSE_BYTES = 32;
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final SecureRandom secureRandom = SecureRandomFactory.newInstance();
    private static final Logger log = LoggerFactory.getLogger(SharedSecretClusterAuthService.class);
    private final ClusterAuthSharedKeySupplier clusterAuthSharedKeySupplier;
    private final ClusterAuthStatsManager clusterAuthStatsManager;

    public SharedSecretClusterAuthService(ClusterAuthSharedKeySupplier clusterAuthSharedKeySupplier, ClusterAuthStatsManager clusterAuthStatsManager) {
        this.clusterAuthSharedKeySupplier = clusterAuthSharedKeySupplier;
        this.clusterAuthStatsManager = clusterAuthStatsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterAuthenticationResult authenticate(ClusterJoinRequest clusterJoinRequest) {
        if (!((Optional)this.clusterAuthSharedKeySupplier.get()).isPresent()) {
            log.debug("{}authentication skipped", (Object)SharedSecretClusterAuthService.prefix(clusterJoinRequest.isServer()));
            this.clusterAuthStatsManager.notifyAuthenticationSkipped(clusterJoinRequest.isServer());
            return new ClusterAuthenticationResult(true, "Cluster authentication skipped");
        }
        log.debug("{}authentication started at {}millis", (Object)SharedSecretClusterAuthService.prefix(clusterJoinRequest.isServer()), (Object)0);
        Stopwatch stopwatch = Stopwatch.createStarted();
        ClusterAuthenticationResult result = null;
        try {
            result = this.runMutualChallengeResponse((byte[])((Optional)this.clusterAuthSharedKeySupplier.get()).get(), clusterJoinRequest, stopwatch);
            if (!result.isSuccessful()) {
                this.clusterAuthSharedKeySupplier.refresh();
            }
            ClusterAuthenticationResult clusterAuthenticationResult = result;
            return clusterAuthenticationResult;
        }
        finally {
            Duration duration = stopwatch.elapsed();
            this.clusterAuthStatsManager.notifyAuthenticationFinished(clusterJoinRequest.isServer(), duration.toMillis(), result);
            log.debug("{}authentication finished at {}millis", (Object)SharedSecretClusterAuthService.prefix(clusterJoinRequest.isServer()), (Object)duration);
        }
    }

    private ClusterAuthenticationResult runMutualChallengeResponse(byte[] key, ClusterJoinRequest request, Stopwatch stopwatch) {
        try {
            String remoteResponse;
            String remoteNonce;
            boolean isServer = request.isServer();
            DataOutputStream out = new DataOutputStream(request.out());
            DataInputStream in = new DataInputStream(request.in());
            String localNonce = this.generateNewNonce();
            log.trace("{}generated: {} at {}millis", new Object[]{SharedSecretClusterAuthService.prefix(isServer), localNonce, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            if (request.isServer()) {
                this.writeNonce(out, localNonce, isServer, stopwatch);
                remoteNonce = this.readNonce(in, isServer, stopwatch);
                this.writeResponse(out, this.createResponse(key, localNonce, remoteNonce, isServer, stopwatch), isServer, stopwatch);
                remoteResponse = this.readResponse(in, isServer, stopwatch);
            } else {
                remoteNonce = this.readNonce(in, isServer, stopwatch);
                this.writeNonce(out, localNonce, isServer, stopwatch);
                remoteResponse = this.readResponse(in, isServer, stopwatch);
                this.writeResponse(out, this.createResponse(key, localNonce, remoteNonce, isServer, stopwatch), isServer, stopwatch);
            }
            ClusterAuthenticationResult result = this.verifyResponse(key, remoteResponse, localNonce, remoteNonce, request.isServer());
            log.trace("{}response verified at {}millis", (Object)SharedSecretClusterAuthService.prefix(isServer), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return result;
        }
        catch (IOException e) {
            log.debug("IOException during cluster auth challenge-response", (Throwable)e);
            return new ClusterAuthenticationResult(false, "Exception:" + e.toString(), e);
        }
    }

    private void writeNonce(DataOutputStream out, String localNonce, boolean isServer, Stopwatch stopwatch) throws IOException {
        out.writeUTF(localNonce);
        log.trace("{}local nonce {} send at {}millis", new Object[]{SharedSecretClusterAuthService.prefix(isServer), localNonce, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
    }

    private String readNonce(DataInputStream in, boolean isServer, Stopwatch stopwatch) throws IOException {
        String nonce = in.readUTF();
        if (nonce.length() != 32) {
            throw new IOException("remote nonce size mismatch");
        }
        log.trace("{}remote nonce {} received at {}millis", new Object[]{SharedSecretClusterAuthService.prefix(isServer), nonce, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return nonce;
    }

    private void writeResponse(DataOutputStream out, String response, boolean isServer, Stopwatch stopwatch) throws IOException {
        out.writeUTF(response);
        log.trace("{}local response {} send at {}millis", new Object[]{SharedSecretClusterAuthService.prefix(isServer), response, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
    }

    private String readResponse(DataInputStream in, boolean isServer, Stopwatch stopwatch) throws IOException {
        String response = in.readUTF();
        if (response.length() != 64) {
            throw new IOException("remote response size mismatch");
        }
        log.trace("{}remote response {} received at {}millis", new Object[]{SharedSecretClusterAuthService.prefix(isServer), response, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return response;
    }

    private String createResponse(byte[] sharedKey, String localNonce, String remoteNonce, boolean isServer, Stopwatch stopwatch) throws IOException {
        log.trace("{}create response generateSalt from: {} / {} / {} at {}millis", new Object[]{SharedSecretClusterAuthService.prefix(isServer), localNonce, remoteNonce, isServer, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        byte[] salt = this.generateSalt(localNonce.getBytes(StandardCharsets.UTF_8), remoteNonce.getBytes(StandardCharsets.UTF_8), isServer);
        log.trace("{}create response generateSalt at {}millis", (Object)SharedSecretClusterAuthService.prefix(isServer), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        String key = this.generateKey(sharedKey, salt);
        if (log.isTraceEnabled()) {
            log.trace("{}create response generateKey: {} -> {} at {}millis", new Object[]{SharedSecretClusterAuthService.prefix(isServer), Hex.toHexString((byte[])salt), key, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        }
        return key;
    }

    private ClusterAuthenticationResult verifyResponse(byte[] sharedKey, String message, String localNonce, String remoteNonce, boolean isServer) throws IOException {
        log.trace("{}verify response generateSalt: {} / {} / {}", new Object[]{SharedSecretClusterAuthService.prefix(isServer), remoteNonce, localNonce, !isServer});
        byte[] salt = this.generateSalt(remoteNonce.getBytes(StandardCharsets.UTF_8), localNonce.getBytes(StandardCharsets.UTF_8), !isServer);
        String key = this.generateKey(sharedKey, salt);
        if (log.isTraceEnabled()) {
            log.trace("{}verify response generateKey: {} -> {}", new Object[]{SharedSecretClusterAuthService.prefix(isServer), Hex.toHexString((byte[])salt), key});
            log.trace("{}check: {} vs {}", new Object[]{SharedSecretClusterAuthService.prefix(isServer), message, key});
        }
        if (!ConstantTimeComparison.isEqual((String)key, (String)message)) {
            return new ClusterAuthenticationResult(false, "Key mismatch");
        }
        return new ClusterAuthenticationResult(true, "Cluster authentication successful");
    }

    private String generateKey(byte[] sharedKey, byte[] salt) {
        try {
            Mac hmac = Mac.getInstance(HMAC_ALGORITHM);
            hmac.init(new SecretKeySpec(sharedKey, HMAC_ALGORITHM));
            return Hex.toHexString((byte[])hmac.doFinal(salt));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String generateNewNonce() {
        byte[] nonce = new byte[16];
        secureRandom.nextBytes(nonce);
        return Hex.toHexString((byte[])nonce);
    }

    private byte[] generateSalt(byte[] firstNonce, byte[] secondNonce, boolean isServer) throws IOException {
        try (ByteArrayOutputStream salt = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream data = new DataOutputStream(salt);){
                data.write(firstNonce);
                data.write(secondNonce);
                data.writeBoolean(isServer);
                byArray = salt.toByteArray();
            }
            return byArray;
        }
    }

    private static String prefix(boolean isServer) {
        return isServer ? "[JIRA-RMI-AUTH] [SERVER] " : "[JIRA-RMI-AUTH] [CLIENT] ";
    }
}

