/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.events;

import com.atlassian.jira.cluster.events.EventSerializer;
import com.atlassian.jira.cluster.events.SerializedEvent;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoEventSerializer
implements EventSerializer {
    private static final Logger log = LoggerFactory.getLogger(KryoEventSerializer.class);
    static final String SYSTEM_PROPERTY_OBJECT_MAX_SIZE = "com.atlassian.jira.cluster.events.serialization.max.size.bytes";
    static final int OBJECT_MIN_SIZE = 4096;
    static final int OBJECT_MAX_SIZE_DEFAULT = 0x4000000;
    static final int KRYO_POOL_SIZE = 50;
    private final Pool<Kryo> kryoPool = new Pool<Kryo>(true, false, 50){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };
    private final int objectMaxSize = KryoEventSerializer.getObjectMaxSize();

    private static int getObjectMaxSize() {
        int maxSize = Math.max(4096, JiraSystemProperties.getInstance().getInteger(SYSTEM_PROPERTY_OBJECT_MAX_SIZE, Integer.valueOf(0x4000000)));
        if (maxSize != 0x4000000) {
            log.info("REPLICATED-EVENT object max size: " + maxSize + ", object min size: 4096, system property: com.atlassian.jira.cluster.events.serialization.max.size.bytes overrides object max size with: " + JiraSystemProperties.getInstance().getInteger(SYSTEM_PROPERTY_OBJECT_MAX_SIZE));
        }
        return maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SerializedEvent serialize(Object event) {
        Output output = new Output(4096, this.objectMaxSize);
        Kryo kryo = (Kryo)this.kryoPool.obtain();
        try {
            kryo.writeObject(output, event);
        }
        finally {
            this.kryoPool.free((Object)kryo);
        }
        output.flush();
        return new SerializedEvent(event.getClass(), output.toBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(SerializedEvent serializedEvent) {
        Input input = new Input(serializedEvent.getData());
        Kryo kryo = (Kryo)this.kryoPool.obtain();
        try {
            Object object = kryo.readObject(input, serializedEvent.getDataType());
            return object;
        }
        finally {
            this.kryoPool.free((Object)kryo);
        }
    }
}

