/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.lock.HeartbeatJob;
import com.atlassian.jira.cluster.lock.NodeSharedHomeStatus;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusWriter;
import com.atlassian.jira.cluster.service.NodeAutoShutdownIfOfflineService;
import com.atlassian.jira.event.cluster.HeartbeatEvent;
import java.time.Clock;

public class ClusterHeartbeatJob
implements HeartbeatJob {
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;
    private final SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter;
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final NodeAutoShutdownIfOfflineService nodeAutoShutdownIfOfflineService;

    public ClusterHeartbeatJob(ClusterNodeHeartBeatDao clusterNodeHeartBeatDao, SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter, Clock clock, EventPublisher eventPublisher, NodeAutoShutdownIfOfflineService nodeAutoShutdownIfOfflineService) {
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
        this.sharedHomeNodeStatusWriter = sharedHomeNodeStatusWriter;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.nodeAutoShutdownIfOfflineService = nodeAutoShutdownIfOfflineService;
    }

    @Override
    public void run() {
        this.nodeAutoShutdownIfOfflineService.checkCurrentNodeState();
        this.updateClusterNodeHeartbeat();
        this.updateSharedHomeNodeStatus();
        this.publishEvent();
    }

    private void updateClusterNodeHeartbeat() {
        this.clusterNodeHeartBeatDao.writeHeartBeat(this.clock.millis());
    }

    private void updateSharedHomeNodeStatus() {
        this.sharedHomeNodeStatusWriter.writeNodeStatus(new NodeSharedHomeStatus(this.getNodeId(), this.clock.millis()));
    }

    private void publishEvent() {
        this.eventPublisher.publish((Object)HeartbeatEvent.INSTANCE);
    }

    private String getNodeId() {
        return this.clusterNodeHeartBeatDao.getNodeId();
    }
}

