/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.beehive.db.LockExpiryConfiguration;
import com.atlassian.beehive.db.spi.ClusterLockDao;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.lock.ClusterLockCleanupDao;
import com.atlassian.jira.database.DatabaseSystemTimeReader;
import com.atlassian.jira.database.DatabaseSystemTimeReaderFactory;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.ClusterLockStatusDTO;
import com.atlassian.jira.model.querydsl.QClusterLockStatus;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClusterLockQueryDSLDao
implements ClusterLockDao,
ClusterLockCleanupDao {
    private final QueryDslAccessor queryDslAccessor;
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;
    private final DatabaseSystemTimeReader databaseSystemTimeReader;
    public static final long LEASE_EXPIRY_TIME_MS = LockExpiryConfiguration.getExpiryPeriodDurationSeconds() * 1000L;
    private static final Logger log = LoggerFactory.getLogger(JiraClusterLockQueryDSLDao.class);

    public JiraClusterLockQueryDSLDao(QueryDslAccessor queryDslAccessor, ClusterNodeHeartBeatDao clusterNodeHeartBeatDao, DatabaseSystemTimeReaderFactory databaseSystemTimeReaderFactory) {
        this.queryDslAccessor = queryDslAccessor;
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
        this.databaseSystemTimeReader = databaseSystemTimeReaderFactory.getReader();
    }

    private <T> T executeSelect(@Nonnull QueryCallback<T> callback) {
        return this.queryDslAccessor.executeQuery(callback);
    }

    private <T> T executeUpdateOrInsert(@Nonnull QueryCallback<T> callback) {
        return this.queryDslAccessor.withNewConnection().executeQuery(callback);
    }

    @Nonnull
    public List<ClusterLockStatus> getAllHeldClusterLocks() {
        log.trace("Reading all cluster locks held by any node");
        long dbTime = this.getDatabaseTime();
        List clusterLockStatusDTOS = this.executeSelect(dbConnection -> this.getHeldClusterLocksQuery(dbConnection, dbTime).fetch());
        return clusterLockStatusDTOS.stream().map(x -> new ClusterLockStatus(x.getLockName(), x.getLockedByNode(), x.getUpdateTime().longValue())).collect(Collectors.toList());
    }

    @Nullable
    public ClusterLockStatus getClusterLockStatusByName(@Nonnull String lockName) {
        log.trace("Reading cluster lock status by name: '{}'", (Object)lockName);
        ClusterLockStatusDTO clusterLockStatusDTO = this.executeSelect(dbConnection -> (ClusterLockStatusDTO)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS).from((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS)).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockName.eq((Object)lockName))).fetchOne());
        if (clusterLockStatusDTO != null) {
            log.trace("Read cluster lock status - name: {}, held by: {}, updated: {}", new Object[]{clusterLockStatusDTO.getLockName(), clusterLockStatusDTO.getLockedByNode(), clusterLockStatusDTO.getUpdateTime()});
            return new ClusterLockStatus(clusterLockStatusDTO.getLockName(), clusterLockStatusDTO.getLockedByNode(), clusterLockStatusDTO.getUpdateTime().longValue());
        }
        return null;
    }

    public boolean tryAcquireLock(@Nonnull String lockName) {
        String nodeId = this.clusterNodeHeartBeatDao.getNodeId();
        log.trace("Acquiring cluster lock '{}' by node: {}", (Object)lockName, (Object)nodeId);
        long dbTime = this.getDatabaseTime();
        long rows = this.executeUpdateOrInsert(dbConnection -> {
            SQLUpdateClause query = this.getAcquireLockQuery(dbConnection, lockName, dbTime);
            return query.execute();
        });
        if (rows == 0L) {
            log.debug("Node {} tried to obtain cluster lock '{}' but it was already held by another node", (Object)nodeId, (Object)lockName);
            return false;
        }
        if (rows == 1L) {
            log.debug("Acquired cluster lock '{}' by node: {}", (Object)lockName, (Object)nodeId);
            return true;
        }
        throw new IllegalStateException("Too many rows updated in JiraClusterLockQueryDSLDao: " + rows + " for lock name: " + lockName);
    }

    public void insertEmptyClusterLock(@Nonnull String lockName) {
        log.trace("Creating new empty cluster lock with name: '{}'", (Object)lockName);
        try {
            long databaseTime = this.getDatabaseTime();
            long id = this.executeUpdateOrInsert(dbConnection -> dbConnection.insert(QClusterLockStatus.CLUSTER_LOCK_STATUS).populate(new ClusterLockStatusDTO(null, lockName, null, databaseTime)).executeWithId());
            log.debug("Created new empty cluster lock with name: '{}', id: {}", (Object)lockName, (Object)id);
        }
        catch (QueryException ex) {
            if (this.getClusterLockStatusByName(lockName) == null) {
                throw ex;
            }
            log.trace("Lock " + lockName + " already exists, skipping insert.");
        }
    }

    public void unlock(@Nonnull String lockName) {
        String nodeId = this.clusterNodeHeartBeatDao.getNodeId();
        log.trace("Releasing cluster lock '{}' held by node: {}", (Object)lockName, (Object)nodeId);
        long databaseTime = this.getDatabaseTime();
        long rowsUpdated = this.executeUpdateOrInsert(dbConnection -> dbConnection.update((RelationalPath<?>)QClusterLockStatus.CLUSTER_LOCK_STATUS).setNull((Path)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode).set(QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime, (Object)databaseTime).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockName.eq((Object)lockName)).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.eq((Object)nodeId)).execute());
        if (rowsUpdated == 0L) {
            throw new IllegalMonitorStateException("Attempted to unlock '" + lockName + "' but it was not held by this node ('" + nodeId + "').");
        }
        log.debug("Released cluster lock '{}' held by node: {}", (Object)lockName, (Object)nodeId);
    }

    @Override
    public void releaseAllClusterLocks() {
        log.info("Releasing all cluster locks");
        this.executeUpdateOrInsert(dbConnection -> dbConnection.update((RelationalPath<?>)QClusterLockStatus.CLUSTER_LOCK_STATUS).setNull((Path)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode).execute());
        log.info("Released all cluster locks");
    }

    public void renewLease(@Nonnull String lockName) {
        String nodeId = this.clusterNodeHeartBeatDao.getNodeId();
        log.trace("Renewing lease on lock '{}' held by node: {}", (Object)lockName, (Object)nodeId);
        long now = this.getDatabaseTime();
        long rowsUpdated = this.executeUpdateOrInsert(dbConnection -> dbConnection.update((RelationalPath<?>)QClusterLockStatus.CLUSTER_LOCK_STATUS).set(QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime, (Object)now).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockName.eq((Object)lockName)).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.eq((Object)nodeId)).execute());
        if (rowsUpdated == 0L) {
            throw new IllegalMonitorStateException("Attempted to renew lease on '" + lockName + "' but it was not held by this node ('" + nodeId + "').");
        }
        log.debug("Renewed lease on cluster lock '{}' held by node: {} at time: {}", new Object[]{lockName, nodeId, now});
    }

    public void releaseLocksHeldByNode() {
        String nodeId = this.clusterNodeHeartBeatDao.getNodeId();
        log.trace("Releasing all cluster locks held by node: {}", (Object)nodeId);
        long rowsUpdated = this.executeUpdateOrInsert(dbConnection -> dbConnection.update((RelationalPath<?>)QClusterLockStatus.CLUSTER_LOCK_STATUS).setNull((Path)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.eq((Object)nodeId)).execute());
        log.debug("Released all '{}' cluster locks held by node: {}", (Object)rowsUpdated, (Object)nodeId);
    }

    protected long getDatabaseTime() {
        try {
            return this.databaseSystemTimeReader.getDatabaseSystemTimeMillis();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SQLQuery<ClusterLockStatusDTO> getHeldClusterLocksQuery(DbConnection dbConnection, Long dbTime) {
        return (SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS).from((Expression)QClusterLockStatus.CLUSTER_LOCK_STATUS)).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.isNotNull())).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime.gt((Number)(dbTime - LEASE_EXPIRY_TIME_MS)));
    }

    protected SQLUpdateClause getAcquireLockQuery(DbConnection dbConnection, String lockName, Long dbTime) {
        String nodeId = this.clusterNodeHeartBeatDao.getNodeId();
        return dbConnection.update((RelationalPath<?>)QClusterLockStatus.CLUSTER_LOCK_STATUS).set((Path)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode, (Object)nodeId).set(QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime, (Object)dbTime).where((Predicate)QClusterLockStatus.CLUSTER_LOCK_STATUS.lockName.eq((Object)lockName).andAnyOf(new Predicate[]{QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.isNull(), QClusterLockStatus.CLUSTER_LOCK_STATUS.lockedByNode.eq((Object)nodeId), QClusterLockStatus.CLUSTER_LOCK_STATUS.updateTime.lt((Number)(dbTime - LEASE_EXPIRY_TIME_MS))}));
    }
}

