/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.service;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartbeatService;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class NodeTimeHelper {
    private final ClusterNodeHeartbeatService clusterNodeHeartbeatService;

    public NodeTimeHelper(ClusterNodeHeartbeatService clusterNodeHeartbeatService) {
        this.clusterNodeHeartbeatService = clusterNodeHeartbeatService;
    }

    public Duration getTimeOfNodeBeingInCurrentState(Node node, Clock clock) {
        Duration howLongNodeIsState = Duration.between(this.getLastHeartbeat(node), Instant.now(clock));
        if (howLongNodeIsState.isNegative()) {
            return Duration.ofMillis(0L);
        }
        return howLongNodeIsState;
    }

    public Duration getEstimatedRetentionTime(Node node, Duration retentionPeriod, Clock clock) {
        Instant nodeLiveThreshold = this.getLastHeartbeat(node).plus(retentionPeriod);
        Duration estimatedTime = Duration.between(Instant.now(clock), nodeLiveThreshold);
        if (estimatedTime.isNegative()) {
            return Duration.ofMillis(0L);
        }
        return estimatedTime;
    }

    private Instant getLastHeartbeat(Node node) {
        if (!this.isNodeHeartbeatValid(node) || node.getState() == Node.NodeState.OFFLINE) {
            return Instant.ofEpochMilli(node.getTimestamp());
        }
        return Instant.ofEpochMilli(this.clusterNodeHeartbeatService.getLastHeartbeatTime(node.getNodeId()));
    }

    public boolean isNodeHeartbeatValid(Node node) {
        Long heartbeat = this.clusterNodeHeartbeatService.getLastHeartbeatTime(node.getNodeId());
        long timestamp = node.getTimestamp();
        return heartbeat != null && heartbeat > 0L && heartbeat > timestamp;
    }
}

