/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.throwsafe;

import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafeWith;
import com.atlassian.jira.component.pico.throwsafe.ThrowSavableBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class ThrowSaved<T>
extends AbstractBehavior<T> {
    private static final Logger log = LoggerFactory.getLogger(ThrowSaved.class);
    private final transient ThrowSafeWith throwSafeWith;

    public ThrowSaved(@Nonnull ComponentAdapter<T> componentAdapter, @Nonnull ThrowSafeWith throwSafeWith) {
        super(Objects.requireNonNull(componentAdapter));
        this.throwSafeWith = Objects.requireNonNull(throwSafeWith);
    }

    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        ComponentAdapter delegate = this.getDelegate();
        Object componentKey = delegate.getComponentKey();
        Object componentInstance = super.getComponentInstance(container, into);
        if (componentKey instanceof Class && ((Class)componentKey).isInterface()) {
            Class[] interfaces = new Class[]{(Class)componentKey};
            Class componentImplementation = delegate.getComponentImplementation();
            ThrowSavableBean throwSavableBean = Objects.requireNonNull((ThrowSavableBean)container.getComponent(this.throwSafeWith.value()), String.format("Bean of type %s is required for handle exceptions in bean of type %s", this.throwSafeWith.value().getSimpleName(), componentInstance.getClass().getSimpleName()));
            return (T)Proxy.newProxyInstance(componentImplementation.getClassLoader(), interfaces, (InvocationHandler)new ThrowSafeInvocationHandler(componentInstance, throwSavableBean));
        }
        return (T)componentInstance;
    }

    public String getDescriptor() {
        return "ThrowSaved-";
    }

    private class ThrowSafeInvocationHandler
    implements InvocationHandler {
        private final T componentInstance;
        private final ThrowSavableBean throwSavableBean;
        private final Map<Method, Boolean> isThrowSafeMethodMap = new ConcurrentHashMap<Method, Boolean>();

        public ThrowSafeInvocationHandler(@Nonnull T componentInstance, ThrowSavableBean throwSavableBean) {
            this.componentInstance = Objects.requireNonNull(componentInstance);
            this.throwSavableBean = Objects.requireNonNull(throwSavableBean);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.isThrowSafe(method, this.componentInstance)) {
                Object result = null;
                try {
                    result = method.invoke(this.componentInstance, args);
                }
                catch (InvocationTargetException ex) {
                    try {
                        this.throwSavableBean.handleException(ex.getTargetException(), this.componentInstance, method, args);
                    }
                    catch (Throwable exx) {
                        log.error("ThrowSavable.handleException error", exx);
                    }
                }
                return result;
            }
            try {
                return method.invoke(this.componentInstance, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private boolean isThrowSafe(Method method, T componentInstance) {
            return this.isThrowSafeMethodMap.computeIfAbsent(method, m -> {
                try {
                    Method instanceMethod = componentInstance.getClass().getMethod(m.getName(), m.getParameterTypes());
                    return AnnotationUtils.findAnnotation((Method)instanceMethod, ThrowSafe.class) != null;
                }
                catch (Throwable ex) {
                    return false;
                }
            });
        }
    }
}

