/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.concurrent;

import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class ResettableLazyReference<T> {
    private final Lock lock = new ReentrantLock();
    private volatile T reference;

    public Option<T> reset() {
        this.lock.lock();
        try {
            T oldReference = this.reference;
            this.reference = null;
            Option option = Option.option(oldReference);
            return option;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Option<T> safeReset(T expected) {
        if (expected != null) {
            this.lock.lock();
            try {
                if (this.reference == expected) {
                    this.reference = null;
                    Option option = Option.some(expected);
                    return option;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return Option.none();
    }

    public Option<T> get() {
        return Option.option(this.reference);
    }

    @Nonnull
    public T getOrCreate(Supplier<T> creator) {
        T localReference = this.reference;
        return localReference != null ? localReference : this.getOrCreateUnderLock(creator);
    }

    @Nonnull
    private T getOrCreateUnderLock(Supplier<T> creator) {
        this.lock.lock();
        try {
            if (this.reference == null) {
                this.reference = Assertions.notNull((String)"creator.get()", (Object)creator.get());
            }
            T t = this.reference;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

