/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.types.issuetype.IssueTypeTypeAvatarService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Options;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueTypeService
implements IssueTypeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueTypeService.class);
    private final ConstantsManager constantsManager;
    private final IssueTypeTypeAvatarService avatarService;
    private final I18nHelper i18n;
    private final GlobalPermissionManager globalPermissionManager;
    private final IssueTypeManager issueTypeManager;
    private final PermissionManager permissionManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final SubTaskManager subTaskManager;
    private final ApplicationProperties applicationProperties;

    public DefaultIssueTypeService(ConstantsManager constantsManager, IssueTypeTypeAvatarService avatarService, I18nHelper i18n, GlobalPermissionManager globalPermissionManager, IssueTypeManager issueTypeManager, PermissionManager permissionManager, IssueTypeSchemeManager issueTypeSchemeManager, SubTaskManager subTaskManager, ApplicationProperties applicationProperties) {
        this.constantsManager = constantsManager;
        this.avatarService = avatarService;
        this.i18n = i18n;
        this.globalPermissionManager = globalPermissionManager;
        this.issueTypeManager = issueTypeManager;
        this.permissionManager = permissionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.subTaskManager = subTaskManager;
        this.applicationProperties = applicationProperties;
    }

    public Option<IssueType> getIssueType(ApplicationUser applicationUser, final String id) {
        return Option.option((Object)((IssueType)Iterables.find(this.getIssueTypes(applicationUser), (Predicate)new Predicate<IssueType>(){

            public boolean apply(IssueType issueType) {
                return issueType.getId().equals(id);
            }
        }, null)));
    }

    public Iterable<IssueType> getIssueTypes(ApplicationUser applicationUser) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, applicationUser);
        Iterable visibleIssueTypes = io.atlassian.fugue.Iterables.transform((Iterable)projects, (Function)new Function<Project, Iterable<IssueType>>(){

            @Override
            public Iterable<IssueType> apply(Project project) {
                return DefaultIssueTypeService.this.issueTypeSchemeManager.getIssueTypesForProject(project);
            }
        });
        ImmutableSet.Builder allIssueTypesBuilder = ImmutableSet.builder().addAll(Iterables.concat((Iterable)visibleIssueTypes));
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, applicationUser)) {
            allIssueTypesBuilder.addAll((Iterable)this.issueTypeManager.getIssueTypes());
        }
        return allIssueTypesBuilder.build();
    }

    public Iterable<IssueType> getAvailableAlternativesForIssueType(ApplicationUser applicationUser, String id) {
        return (Iterable)this.getIssueType(applicationUser, id).fold((Supplier)new Supplier<Iterable<IssueType>>(){

            @Override
            public Iterable<IssueType> get() {
                return Collections.emptyList();
            }
        }, (Function)new Function<IssueType, Iterable<IssueType>>(){

            @Override
            public Iterable<IssueType> apply(IssueType issueType) {
                return DefaultIssueTypeService.this.issueTypeManager.getAvailableIssueTypes(issueType);
            }
        });
    }

    public IssueTypeService.CreateValidationResult validateCreateIssueType(ApplicationUser user, @Nonnull IssueTypeService.IssueTypeCreateInput issueTypeCreateInput) {
        Preconditions.checkNotNull((Object)issueTypeCreateInput);
        Option<ErrorCollection> userValidation = this.validateUser(user);
        if (userValidation.isDefined()) {
            return IssueTypeService.CreateValidationResult.error((ErrorCollection)((ErrorCollection)userValidation.get()));
        }
        ErrorCollection errorCollection = this.validateCreate(issueTypeCreateInput);
        if (errorCollection.hasAnyErrors()) {
            return IssueTypeService.CreateValidationResult.error((ErrorCollection)errorCollection);
        }
        return IssueTypeService.CreateValidationResult.ok((IssueTypeService.IssueTypeCreateInput)issueTypeCreateInput);
    }

    public IssueTypeService.IssueTypeResult createIssueType(ApplicationUser user, @Nonnull IssueTypeService.CreateValidationResult validationResult) {
        Preconditions.checkArgument((boolean)validationResult.isValid());
        Preconditions.checkArgument((boolean)validationResult.getIssueTypeInput().isDefined());
        IssueTypeService.IssueTypeCreateInput issueTypeCreateInput = (IssueTypeService.IssueTypeCreateInput)validationResult.getIssueTypeInput().get();
        String name = issueTypeCreateInput.getName();
        IssueTypeService.IssueTypeCreateInput.Type type = issueTypeCreateInput.getType();
        String description = (String)issueTypeCreateInput.getDescription().getOrElse((Object)"");
        IssueType issueType = this.createIssueTypeOrSubTaskType(name, type, description);
        return new IssueTypeService.IssueTypeResult(issueType);
    }

    public IssueTypeService.UpdateValidationResult validateUpdateIssueType(final ApplicationUser user, @Nonnull String issueTypeId, final @Nonnull IssueTypeService.IssueTypeUpdateInput issueTypeUpdateInput) {
        Preconditions.checkNotNull((Object)issueTypeId);
        Preconditions.checkNotNull((Object)issueTypeUpdateInput);
        Option<ErrorCollection> userValidation = this.validateUser(user);
        if (userValidation.isDefined()) {
            return IssueTypeService.UpdateValidationResult.error((ErrorCollection)((ErrorCollection)userValidation.get()));
        }
        return (IssueTypeService.UpdateValidationResult)this.getIssueType(user, issueTypeId).fold((Supplier)new Supplier<IssueTypeService.UpdateValidationResult>(){

            @Override
            public IssueTypeService.UpdateValidationResult get() {
                return IssueTypeService.UpdateValidationResult.error((ErrorCollection)new SimpleErrorCollection(DefaultIssueTypeService.this.i18n.getText("admin.error.issue.type.update.not.exist"), ErrorCollection.Reason.NOT_FOUND));
            }
        }, (Function)new Function<IssueType, IssueTypeService.UpdateValidationResult>(){

            @Override
            public IssueTypeService.UpdateValidationResult apply(IssueType issueType) {
                ErrorCollection errorCollection = DefaultIssueTypeService.this.validateUpdate(user, issueTypeUpdateInput, issueType);
                if (errorCollection.hasAnyErrors()) {
                    return IssueTypeService.UpdateValidationResult.error((ErrorCollection)errorCollection);
                }
                return IssueTypeService.UpdateValidationResult.ok((IssueTypeService.IssueTypeUpdateInput)issueTypeUpdateInput, (IssueType)issueType);
            }
        });
    }

    public IssueTypeService.IssueTypeResult updateIssueType(ApplicationUser user, @Nonnull IssueTypeService.UpdateValidationResult validationResult) {
        Preconditions.checkArgument((boolean)validationResult.getIssueTypeInput().isDefined());
        Preconditions.checkArgument((boolean)validationResult.getIssueType().isDefined());
        final IssueType issueTypeToUpdate = (IssueType)validationResult.getIssueType().get();
        IssueTypeService.IssueTypeUpdateInput issueTypeUpdateInput = (IssueTypeService.IssueTypeUpdateInput)validationResult.getIssueTypeInput().get();
        String name = (String)issueTypeUpdateInput.getName().getOrElse((Object)issueTypeToUpdate.getName());
        String description = (String)issueTypeUpdateInput.getDescription().getOrElse((Object)issueTypeToUpdate.getDescription());
        Long avatarId = (Long)issueTypeUpdateInput.getAvatarId().getOrElse((Supplier)new Supplier<Long>(){

            @Override
            public Long get() {
                return issueTypeToUpdate.getAvatar() != null ? issueTypeToUpdate.getAvatar().getId() : null;
            }
        });
        this.issueTypeManager.updateIssueType(issueTypeToUpdate, name, description, avatarId);
        return new IssueTypeService.IssueTypeResult(this.issueTypeManager.getIssueType(issueTypeToUpdate.getId()));
    }

    public IssueTypeService.DeleteValidationResult validateDeleteIssueType(ApplicationUser user, @Nonnull IssueTypeService.IssueTypeDeleteInput issueTypeDeleteInput) {
        Preconditions.checkNotNull((Object)issueTypeDeleteInput);
        Preconditions.checkNotNull((Object)issueTypeDeleteInput.getIssueTypeToDeleteId());
        Option<ErrorCollection> userValidationResult = this.validateUser(user);
        if (userValidationResult.isDefined()) {
            return this.deleteValidationFailed((ErrorCollection)userValidationResult.get());
        }
        Option<IssueType> issueTypeToDelete = this.getIssueType(user, issueTypeDeleteInput.getIssueTypeToDeleteId());
        if (issueTypeToDelete.isEmpty()) {
            return this.deleteValidationFailed(this.i18n.getText("admin.error.issue.type.delete.not.exist"), ErrorCollection.Reason.NOT_FOUND);
        }
        if (!this.alternativeProvided(issueTypeDeleteInput, issueTypeToDelete) || !this.alternativeExists(user, issueTypeDeleteInput)) {
            return this.deleteValidationFailed(this.i18n.getText("admin.error.issue.type.delete.alternative.not.exist"), ErrorCollection.Reason.NOT_FOUND);
        }
        if (this.issueTypeManager.hasAssociatedIssues((IssueType)issueTypeToDelete.get())) {
            Iterable<IssueType> alternativesForIssueType = this.getAvailableAlternativesForIssueType(user, issueTypeDeleteInput.getIssueTypeToDeleteId());
            if (Iterables.isEmpty(alternativesForIssueType)) {
                return this.deleteValidationFailed(this.i18n.getText("admin.error.issue.type.delete.no.alternative.available"), ErrorCollection.Reason.NOT_FOUND);
            }
            if (issueTypeDeleteInput.getAlternativeIssueTypeId().isDefined() && !this.containsAlternative(alternativesForIssueType, (String)issueTypeDeleteInput.getAlternativeIssueTypeId().get())) {
                return this.deleteValidationFailed(this.i18n.getText("admin.error.issue.type.delete.invalid.alternative"), ErrorCollection.Reason.CONFLICT);
            }
        }
        return new IssueTypeService.DeleteValidationResult((ErrorCollection)new SimpleErrorCollection(), Option.some((Object)issueTypeDeleteInput));
    }

    private boolean containsAlternative(Iterable<IssueType> alternativesForIssueType, final String alternativeIssueTypeId) {
        return Iterables.any(alternativesForIssueType, (Predicate)new Predicate<IssueType>(){

            public boolean apply(IssueType issueType) {
                return issueType.getId().equals(alternativeIssueTypeId);
            }
        });
    }

    public void deleteIssueType(ApplicationUser user, @Nonnull IssueTypeService.DeleteValidationResult validationResult) {
        Preconditions.checkNotNull((Object)validationResult);
        Preconditions.checkArgument((boolean)validationResult.isValid());
        Preconditions.checkNotNull((Object)validationResult.getDeleteIssueTypeInput());
        Preconditions.checkArgument((boolean)validationResult.getDeleteIssueTypeInput().isDefined());
        String issueTypeToDeleteId = ((IssueTypeService.IssueTypeDeleteInput)validationResult.getDeleteIssueTypeInput().get()).getIssueTypeToDeleteId();
        this.issueTypeManager.removeIssueType(issueTypeToDeleteId, (String)((IssueTypeService.IssueTypeDeleteInput)validationResult.getDeleteIssueTypeInput().get()).getAlternativeIssueTypeId().getOrNull());
    }

    public Stream<IssueType> findIssueTypes(@Nullable ApplicationUser user, @Nonnull String substring) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
        return this.findIssueTypes(substring, projects);
    }

    public Stream<IssueType> findIssueTypes(@Nullable ApplicationUser user, @Nonnull String substring, @NotEmpty Set<Long> projectIds) {
        Set<Project> projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user).stream().filter(project -> projectIds.contains(project.getId())).collect(Collectors.toSet());
        return this.findIssueTypes(substring, projects);
    }

    private Stream<IssueType> findIssueTypes(@Nonnull String substring, Collection<Project> projects) {
        Stream issueTypes = this.subTaskManager.isSubTasksEnabled() ? projects.stream().flatMap(project -> this.issueTypeSchemeManager.getIssueTypesForProject(project).stream()) : projects.stream().flatMap(project -> this.issueTypeSchemeManager.getNonSubTaskIssueTypesForProject(project).stream());
        if (StringUtils.isEmpty((CharSequence)substring)) {
            return issueTypes.distinct();
        }
        Pattern searchPattern = ConstantsManager.createIssueConstantNameSearchPattern((String)substring);
        return issueTypes.distinct().filter(issueType -> searchPattern.matcher(issueType.getNameTranslation()).matches());
    }

    private ErrorCollection validateCreate(@Nonnull IssueTypeService.IssueTypeCreateInput issueTypeCreateInput) {
        Iterable errorCollections = Options.flatten((Iterable)Lists.newArrayList((Object[])new Option[]{this.validateType(issueTypeCreateInput), this.validateName(issueTypeCreateInput.getName(), (Option<IssueType>)Option.none())}));
        return this.buildAllErrors(errorCollections);
    }

    private ErrorCollection validateUpdate(ApplicationUser user, @Nonnull IssueTypeService.IssueTypeUpdateInput issueTypeUpdateInput, @Nonnull IssueType issueTypeToUpdate) {
        Preconditions.checkNotNull((Object)issueTypeUpdateInput);
        Preconditions.checkNotNull((Object)issueTypeToUpdate);
        final ImmutableList.Builder builder = ImmutableList.builder();
        Effect<ErrorCollection> errorCollectionEffect = new Effect<ErrorCollection>(){

            public void apply(ErrorCollection errorCollection) {
                builder.add((Object)errorCollection);
            }
        };
        if (issueTypeUpdateInput.getAvatarId().isDefined()) {
            this.validateAvatar(user, issueTypeUpdateInput).foreach((Effect)errorCollectionEffect);
        }
        if (issueTypeUpdateInput.getName().isDefined()) {
            this.validateName((String)issueTypeUpdateInput.getName().get(), (Option<IssueType>)Option.some((Object)issueTypeToUpdate)).foreach((Effect)errorCollectionEffect);
        }
        return this.buildAllErrors((Iterable<ErrorCollection>)builder.build());
    }

    private IssueType createIssueTypeOrSubTaskType(String name, IssueTypeService.IssueTypeCreateInput.Type type, String description) {
        Long avatarID = null;
        if (type.equals((Object)IssueTypeService.IssueTypeCreateInput.Type.STANDARD)) {
            String avatarIDProperty = this.applicationProperties.getString("jira.avatar.issuetype.default.id");
            if (avatarIDProperty == null) {
                log.warn("Default Issue Type avatar property missing");
            } else {
                try {
                    avatarID = Long.parseLong(this.applicationProperties.getString("jira.avatar.issuetype.default.id"));
                }
                catch (NumberFormatException e) {
                    log.warn("Default Issue Type avatar not correctly defined");
                }
            }
            return this.issueTypeManager.createIssueType(name, description, avatarID);
        }
        String avatarIDProperty = this.applicationProperties.getString("jira.avatar.issuetype.subtask.default.id");
        if (avatarIDProperty == null) {
            log.warn("Default subtask Issue Type avatar missing");
        } else {
            try {
                avatarID = Long.parseLong(avatarIDProperty);
            }
            catch (NumberFormatException e) {
                log.warn("Default subtask Issue Type avatar not correctly defined");
            }
        }
        return this.issueTypeManager.createSubTaskIssueType(name, description, avatarID);
    }

    private ErrorCollection buildAllErrors(Iterable<ErrorCollection> errorCollections) {
        SimpleErrorCollection allErrors = new SimpleErrorCollection();
        for (ErrorCollection errorCollection : errorCollections) {
            allErrors.addErrorMessages(errorCollection.getErrorMessages());
            allErrors.addErrors(errorCollection.getErrors());
            allErrors.addReasons(errorCollection.getReasons());
        }
        return allErrors;
    }

    private Option<ErrorCollection> validateType(IssueTypeService.IssueTypeCreateInput issueTypeCreateInput) {
        if (!this.subTaskManager.isSubTasksEnabled() && IssueTypeService.IssueTypeCreateInput.Type.SUBTASK.equals((Object)issueTypeCreateInput.getType())) {
            return this.errorCollection(this.i18n.getText("admin.errors.subtasks.disabled"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return Option.none();
    }

    private Option<ErrorCollection> validateName(String name, Option<IssueType> issueTypeToUpdate) {
        Option nameValidation = this.constantsManager.validateName(name, issueTypeToUpdate);
        if (nameValidation.isDefined()) {
            return this.errorCollection("name", (String)((Pair)nameValidation.get()).first(), (ErrorCollection.Reason)((Pair)nameValidation.get()).second());
        }
        return Option.none();
    }

    private Option<ErrorCollection> validateUser(ApplicationUser user) {
        if (user == null) {
            return this.errorCollection(this.i18n.getText("rest.authentication.no.user.logged.in"), ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return this.errorCollection(this.i18n.getText("rest.authorization.admin.required"), ErrorCollection.Reason.FORBIDDEN);
        }
        return Option.none();
    }

    private Option<ErrorCollection> validateAvatar(final ApplicationUser user, IssueTypeService.IssueTypeUpdateInput issueTypeCreateInput) {
        return issueTypeCreateInput.getAvatarId().flatMap((Function)new Function<Long, Option<ErrorCollection>>(){

            @Override
            public Option<ErrorCollection> apply(Long avatarId) {
                Avatar avatar = DefaultIssueTypeService.this.avatarService.getAvatar(user, avatarId);
                if (avatar == null) {
                    return DefaultIssueTypeService.this.errorCollection("avatarId", DefaultIssueTypeService.this.i18n.getText("admin.errors.project.no.avatar.with.id"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                return Option.none();
            }
        });
    }

    private boolean alternativeExists(ApplicationUser user, IssueTypeService.IssueTypeDeleteInput issueTypeDeleteInput) {
        return issueTypeDeleteInput.getAlternativeIssueTypeId().isDefined() && this.getIssueType(user, (String)issueTypeDeleteInput.getAlternativeIssueTypeId().get()).isDefined() || issueTypeDeleteInput.getAlternativeIssueTypeId().isEmpty();
    }

    private boolean alternativeProvided(IssueTypeService.IssueTypeDeleteInput issueTypeDeleteInput, Option<IssueType> issueTypeToDelete) {
        boolean hasAssociatedIssues = this.issueTypeManager.hasAssociatedIssues((IssueType)issueTypeToDelete.get());
        return hasAssociatedIssues && issueTypeDeleteInput.getAlternativeIssueTypeId().isDefined() || !hasAssociatedIssues;
    }

    private Option<ErrorCollection> errorCollection(String field, String text, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addError(field, text, reason);
        return Option.some((Object)errorCollection);
    }

    private Option<ErrorCollection> errorCollection(String text, ErrorCollection.Reason reason) {
        return Option.some((Object)new SimpleErrorCollection(text, reason));
    }

    private IssueTypeService.DeleteValidationResult deleteValidationFailed(ErrorCollection errorCollection) {
        return new IssueTypeService.DeleteValidationResult(errorCollection, Option.none());
    }

    private IssueTypeService.DeleteValidationResult deleteValidationFailed(String text, ErrorCollection.Reason reason) {
        return this.deleteValidationFailed((ErrorCollection)new SimpleErrorCollection(text, reason));
    }
}

