/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.fields.StatusCreatedEvent;
import com.atlassian.jira.event.fields.StatusDeletedEvent;
import com.atlassian.jira.event.fields.StatusEditedEvent;
import com.atlassian.jira.event.fields.StatusMovedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultStatusManager
extends AbstractIssueConstantsManager<Status>
implements StatusManager,
Startable {
    private static final String CREATION_LOCK_NAME = DefaultStatusManager.class.getName() + ".creationLock";
    private final WorkflowManager workflowManager;
    private final IssueConstantFactory factory;
    private final StatusCategoryManager statusCategoryManager;
    private final ClusterLockService clusterLockService;
    private final EventPublisher eventPublisher;
    private ClusterLock creationLock;
    private static final Long NEW_STATUS_START_ID = 10000L;

    public DefaultStatusManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexingService issueIndexingService, WorkflowManager workflowManager, IssueConstantFactory factory, StatusCategoryManager statusCategoryManager, ClusterLockService clusterLockService, IssueManager issueManager, QueryDslAccessor queryDslAccessor, EventPublisher eventPublisher) {
        super(constantsManager, ofBizDelegator, issueIndexingService, issueManager, queryDslAccessor);
        this.workflowManager = workflowManager;
        this.factory = factory;
        this.statusCategoryManager = statusCategoryManager;
        this.clusterLockService = clusterLockService;
        this.eventPublisher = eventPublisher;
    }

    public void start() {
        this.creationLock = this.clusterLockService.getLockForName(CREATION_LOCK_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status createStatus(String name, String description, String iconUrl, StatusCategory statusCategory) {
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        Assertions.notNull((String)"statusCategory", (Object)statusCategory);
        this.creationLock.lock();
        try {
            for (Status status : this.constantsManager.getStatuses()) {
                if (!name.trim().equalsIgnoreCase(status.getName())) continue;
                throw new DataAccessException("A status with the name '" + name + "' already exists.");
            }
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("iconurl", iconUrl);
            fields.put("sequence", this.getMaxSequenceNo() + 1L);
            fields.put("statuscategory", statusCategory.getId());
            String nextStringId = this.getNextStringId();
            Long nextId = Long.valueOf(nextStringId);
            if (nextId < NEW_STATUS_START_ID) {
                fields.put("id", NEW_STATUS_START_ID.toString());
            } else {
                fields.put("id", nextStringId);
            }
            GenericValue statusGv = this.createConstant(fields);
            Status status = this.factory.createStatus(statusGv);
            this.eventPublisher.publish((Object)new StatusCreatedEvent(status));
            Status status2 = status;
            return status2;
        }
        finally {
            this.creationLock.unlock();
            this.clearCaches();
        }
    }

    public Status createStatus(String name, String description, String iconUrl) {
        return this.createStatus(name, description, iconUrl, this.statusCategoryManager.getDefaultStatusCategory());
    }

    public void editStatus(Status status, String name, String description, String iconUrl, StatusCategory statusCategory) {
        Assertions.notNull((String)"status", (Object)status);
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        Assertions.notNull((String)"statusCategory", (Object)statusCategory);
        for (Status st : this.getStatuses()) {
            if (!name.equalsIgnoreCase(st.getName()) || status.getId().equals(st.getId())) continue;
            throw new IllegalStateException("Cannot rename status. A status with the name '" + name + "' exists already.");
        }
        try {
            StatusImpl updatedStatus = (StatusImpl)this.factory.createStatus(((StatusImpl)status).getGenericValue());
            updatedStatus.setName(name);
            updatedStatus.setIconUrl(iconUrl);
            updatedStatus.setDescription(description);
            updatedStatus.setStatusCategory(statusCategory);
            updatedStatus.getGenericValue().store();
            this.eventPublisher.publish((Object)new StatusEditedEvent(status, (Status)updatedStatus));
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update status '" + status.getName() + "'", (Throwable)e);
        }
    }

    public void editStatus(Status status, String name, String description, String iconUrl) {
        Assertions.notNull((String)"status", (Object)status);
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        for (Status st : this.getStatuses()) {
            if (!name.equalsIgnoreCase(st.getName()) || status.getId().equals(st.getId())) continue;
            throw new IllegalStateException("Cannot rename status. A status with the name '" + name + "' exists already.");
        }
        try {
            StatusImpl updatedStatus = (StatusImpl)this.factory.createStatus(((StatusImpl)status).getGenericValue());
            updatedStatus.setName(name);
            updatedStatus.setIconUrl(iconUrl);
            updatedStatus.setDescription(description);
            updatedStatus.getGenericValue().store();
            this.eventPublisher.publish((Object)new StatusEditedEvent(status, (Status)updatedStatus));
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update status '" + status.getName() + "'", (Throwable)e);
        }
    }

    public Collection<Status> getStatuses() {
        return this.constantsManager.getStatuses();
    }

    public void removeStatus(String id) {
        Status status = this.getStatusOrThrowIllegalArgumentException(id);
        List existingWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
        for (JiraWorkflow workflow : existingWorkflows) {
            List linkStatuses = workflow.getLinkedStatusObjects();
            if (!linkStatuses.contains(status)) continue;
            throw new IllegalStateException("Cannot delete a status which is associated with a workflow. Status is associated with workflow " + workflow.getName());
        }
        try {
            this.removeConstant(QIssue.ISSUE.status, status, null);
            this.eventPublisher.publish((Object)new StatusDeletedEvent(status));
        }
        catch (IndexException | GenericEntityException e) {
            throw new DataAccessException("Failed to remove status with id '" + id + "'", e);
        }
    }

    public Status getStatus(String id) {
        Assertions.notBlank((String)"id", (String)id);
        return this.constantsManager.getStatusObject(id);
    }

    public void moveStatusUp(String id) {
        Status status = this.getStatusOrThrowIllegalArgumentException(id);
        this.moveUp(status);
        this.eventPublisher.publish((Object)new StatusMovedEvent(status, status.getSequence(), Long.valueOf(status.getSequence() - 1L)));
    }

    public void moveStatusDown(String id) {
        Status status = this.getStatusOrThrowIllegalArgumentException(id);
        this.moveDown(status);
        this.eventPublisher.publish((Object)new StatusMovedEvent(status, status.getSequence(), Long.valueOf(status.getSequence() + 1L)));
    }

    private Status getStatusOrThrowIllegalArgumentException(String id) {
        Status status = this.getStatus(id);
        if (status == null) {
            throw new IllegalArgumentException("A status with id '" + id + "' does not exist.");
        }
        return status;
    }

    @Override
    protected void postProcess(Status constant) {
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshStatuses();
    }

    @Override
    protected String getIssueConstantField() {
        return ConstantsManager.CONSTANT_TYPE.STATUS.getType();
    }

    @Override
    protected List<Status> getAllValues() {
        return Lists.newArrayList(this.getStatuses());
    }
}

