/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.SubTaskService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.List;

public class SubTaskServiceImpl
implements SubTaskService {
    private final SubTaskManager manager;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;

    public SubTaskServiceImpl(SubTaskManager manager, PermissionManager permissionManager, FeatureManager featureManager) {
        this.manager = manager;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
    }

    @Override
    public ServiceResult moveSubTask(ApplicationUser user, Issue parentIssue, Long currentSequence, Long sequence) {
        I18nBean i18n = new I18nBean(user);
        ErrorCollection result = ErrorCollections.empty();
        if (this.canMoveSubtask(user, parentIssue)) {
            List subTaskIssueLinks = this.manager.getSubTaskIssueLinks(parentIssue.getId());
            if (!this.withinBounds(subTaskIssueLinks, currentSequence) || !this.withinBounds(subTaskIssueLinks, sequence)) {
                result.addErrorMessage(String.format("%s. %s", i18n.getText("admin.permissions.feedback.unspecifiederror.title"), i18n.getText("admin.permissions.feedback.unspecifiederror.description")), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            try {
                this.manager.moveSubTask(parentIssue, currentSequence, sequence);
            }
            catch (Exception e) {
                result.addErrorMessage(String.format("%s. %s", i18n.getText("admin.permissions.feedback.unspecifiederror.title"), i18n.getText("admin.permissions.feedback.unspecifiederror.description")), ErrorCollection.Reason.SERVER_ERROR);
            }
        } else {
            result.addErrorMessage(i18n.getText("editissue.error.no.edit.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        return ServiceOutcomeImpl.from(result);
    }

    @Override
    public boolean isReorderColumnShown() {
        return !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ISSUE_TABLE_DRAGGABLE_FEATURE) || !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ISSUE_TABLE_SUBTASKS_MOVE_LINKS_HIDDEN_FEATURE);
    }

    @Override
    public boolean canMoveSubtask(ApplicationUser user, Issue parentIssue) {
        return this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, parentIssue, user);
    }

    private boolean withinBounds(List<IssueLink> list, Long index) {
        return index >= 0L && index < (long)list.size();
    }
}

